/*
 * Decompiled with CFR 0.152.
 */
package utafx;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import utafx.IUtaSolver;
import utafx.UtaStarSolver;

public class UtaSolverFactory {
    private static final Logger LOG = Logger.getLogger(UtaSolverFactory.class.getName());
    private static final String FOUND_SOLVER = "Found solver: ";
    private static final String CHOOSING_SOLVER = "Will solve using the following solver class: ";
    private String solverJarPath = "";

    public IUtaSolver createSolver() {
        IUtaSolver solver;
        block11: {
            solver = null;
            try {
                URL[] urls = new URL[]{new URL("file://" + this.solverJarPath)};
                ServiceLoader<IUtaSolver> serviceLoader = ServiceLoader.load(IUtaSolver.class, new URLClassLoader(urls));
                Iterator<IUtaSolver> loadedServicesIterator = serviceLoader.iterator();
                if (loadedServicesIterator.hasNext()) {
                    solver = loadedServicesIterator.next();
                    LOG.info(FOUND_SOLVER + solver.getClass().getName());
                }
            }
            catch (AccessControlException e) {
                LOG.log(Level.INFO, null, e);
                if (solver == null) {
                    solver = new UtaStarSolver();
                }
                break block11;
            }
            catch (MalformedURLException e) {
                try {
                    LOG.log(Level.SEVERE, null, e);
                    break block11;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (solver == null) {
                        solver = new UtaStarSolver();
                    }
                }
            }
            if (solver == null) {
                solver = new UtaStarSolver();
            }
        }
        LOG.info(CHOOSING_SOLVER + solver.getClass().getName());
        return solver;
    }

    public void setSolverJarPath(String path) {
        this.solverJarPath = path;
    }
}

