/*
 * Decompiled with CFR 0.152.
 */
package eu.telecom_bretagne.xmcda;

import eu.telecom_bretagne.xmcda.Alternatives;
import eu.telecom_bretagne.xmcda.Criteria;
import eu.telecom_bretagne.xmcda.PerformanceTable_Config2;
import java.util.ArrayList;

public class GestionIncoherentFiles {
    private Criteria criter;
    private Alternatives altern;
    private PerformanceTable_Config2 perfTable;
    private String warningMessageCriter;
    private String warningMessageAltern;

    public GestionIncoherentFiles() {
    }

    public GestionIncoherentFiles(Criteria criter, Alternatives altern, PerformanceTable_Config2 perfTable) {
        this.criter = criter;
        this.altern = altern;
        this.perfTable = perfTable;
        this.warningMessageCriter = "";
        this.warningMessageAltern = "";
    }

    public boolean checkAlternatives(Alternatives altern, PerformanceTable_Config2 perfTable) {
        boolean result = true;
        int diff = 0;
        if (altern.getListAlternatives().size() != perfTable.getAlternativeIDs().size()) {
            this.warningMessageAltern = this.warningMessageAltern.concat("\nPlease check the file containing the alternatives tag:incoherence with the number of alternatives given in the file containing the performanceTable tag.");
            result = false;
        } else {
            for (String s : altern.getAlternativesIDs()) {
                if (perfTable.getAlternativeIDs().contains(s)) continue;
                result = false;
                ++diff;
            }
            if (diff > 1) {
                this.warningMessageAltern = this.warningMessageAltern.concat("\nPlease check the file containing the alternatives tag:incoherence with the alternatives given in the file containing the performanceTable tag. There are " + diff + " different alternatives.");
            }
            if (diff == 1) {
                this.warningMessageAltern = this.warningMessageAltern.concat("\nPlease check the file containing the alternatives tag:incoherence with the alternatives given in the file containing the performanceTable tag. There is one different alternative.");
            }
        }
        return result;
    }

    public boolean checkCriteria(Criteria criter, PerformanceTable_Config2 perfTable) {
        boolean result = true;
        int diff = 0;
        if (criter.getListCriteria().size() != perfTable.getCriterionIDs().size()) {
            this.warningMessageCriter = this.warningMessageCriter.concat("\nPlease check the file containing the criteria tag:incoherence with the number of criteria given in the file containing the performanceTable tag.");
            result = false;
        } else {
            for (String s : criter.getCriteriaIDs()) {
                if (perfTable.getCriterionIDs().contains(s)) continue;
                result = false;
                ++diff;
            }
            if (diff > 1) {
                this.warningMessageCriter = this.warningMessageCriter.concat("\nPlease check the file containing the criteria tag:incoherence with the criteria given in the file containing the performanceTable tag. There are " + diff + " different criteria.");
            }
            if (diff == 1) {
                this.warningMessageCriter = this.warningMessageCriter.concat("\nPlease check the file containing the criteria tag:incoherence with the criteria given in the file containing the performanceTable tag. There is one different criterion.");
            }
        }
        return result;
    }

    public String getWarningCriteria() {
        return this.warningMessageCriter;
    }

    public String getWarningAlternatives() {
        return this.warningMessageAltern;
    }

    public ArrayList<String> getIntersectionAlternativesIDs() {
        ArrayList<Object> listintersection = new ArrayList();
        listintersection = this.perfTable.getAlternativeIDs();
        listintersection.retainAll(this.altern.getAlternativesIDs());
        return listintersection;
    }

    public ArrayList<String> getIntersectionCriteriaIDs() {
        ArrayList<Object> listintersection = new ArrayList();
        listintersection = this.perfTable.getCriterionIDs();
        listintersection.retainAll(this.criter.getCriteriaIDs());
        return listintersection;
    }
}

