/*
 * Decompiled with CFR 0.152.
 */
package eu.telecom_bretagne.xmcda;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class Matrix<ROW_T, COLUMN_T, VALUE_T> {
    private LinkedHashSet<ROW_T> rows = new LinkedHashSet();
    private LinkedHashSet<COLUMN_T> columns = new LinkedHashSet();
    private Map<Coord<ROW_T, COLUMN_T>, VALUE_T> values = new HashMap<Coord<ROW_T, COLUMN_T>, VALUE_T>();
    private boolean frozen = false;

    public Matrix() {
    }

    public Matrix(List<ROW_T> rows, List<COLUMN_T> columns) {
        for (ROW_T row : rows) {
            this.addRow(row, false);
        }
        for (Object column : columns) {
            this.addColumn(column, false);
        }
    }

    public Matrix(Matrix<ROW_T, COLUMN_T, VALUE_T> matrix) {
        this.rows = new LinkedHashSet<ROW_T>(matrix.rows);
        this.columns = new LinkedHashSet<COLUMN_T>(matrix.columns);
        for (Object row : this.rows) {
            for (Object column : this.columns) {
                if (!matrix.isSet(row, column)) continue;
                this.setValue(row, column, matrix.getValue(row, column));
            }
        }
    }

    public List<ROW_T> rows() {
        return new ArrayList<ROW_T>(this.rows);
    }

    public List<COLUMN_T> columns() {
        return new ArrayList<COLUMN_T>(this.columns);
    }

    public int nbRows() {
        return this.rows.size();
    }

    public int nbColumns() {
        return this.columns.size();
    }

    public boolean isSquare() {
        return this.nbColumns() == this.nbRows();
    }

    public void setIsFrozen(boolean isFrozen) {
        this.frozen = isFrozen;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void addRow(ROW_T row, boolean ignoreDups) {
        if (this.isFrozen()) {
            throw new IllegalStateException("Matrix is frozen");
        }
        if (!this.rows.add(row) && !ignoreDups) {
            throw new IllegalArgumentException("Duplicate row");
        }
    }

    public void addColumn(COLUMN_T column, boolean ignoreDups) {
        if (this.isFrozen()) {
            throw new IllegalStateException("Matrix is frozen");
        }
        if (!this.columns.add(column) && !ignoreDups) {
            throw new IllegalArgumentException("Duplicate column");
        }
    }

    public List<Cell<ROW_T, COLUMN_T, VALUE_T>> removeRow(ROW_T row) {
        if (this.isFrozen()) {
            throw new IllegalStateException("Matrix is frozen");
        }
        if (!this.hasRow(row)) {
            return null;
        }
        ArrayList<Cell<ROW_T, COLUMN_T, VALUE_T>> rowCells = new ArrayList<Cell<ROW_T, COLUMN_T, VALUE_T>>();
        for (Object column : this.columns) {
            if (!this.isSet(row, column)) continue;
            rowCells.add(new Cell(row, column, this.unset(row, column)));
        }
        this.rows.remove(row);
        return rowCells;
    }

    public List<Cell<ROW_T, COLUMN_T, VALUE_T>> removeColumn(COLUMN_T column) {
        if (this.isFrozen()) {
            throw new IllegalStateException("Matrix is frozen");
        }
        if (!this.hasColumn(column)) {
            return null;
        }
        ArrayList<Cell<ROW_T, COLUMN_T, VALUE_T>> columnCells = new ArrayList<Cell<ROW_T, COLUMN_T, VALUE_T>>();
        for (Object row : this.rows) {
            if (!this.isSet(row, column)) continue;
            columnCells.add(new Cell(row, column, this.unset(row, column)));
        }
        this.columns.remove(column);
        return columnCells;
    }

    public boolean hasRow(ROW_T row) {
        return this.rows.contains(row);
    }

    public boolean hasColumn(COLUMN_T column) {
        return this.columns.contains(column);
    }

    public List<Cell<ROW_T, COLUMN_T, VALUE_T>> nonEmptyCells() {
        ArrayList<Cell<ROW_T, COLUMN_T, VALUE_T>> cells = new ArrayList<Cell<ROW_T, COLUMN_T, VALUE_T>>();
        for (Object row : this.rows) {
            for (Object column : this.columns) {
                if (!this.isSet(row, column)) continue;
                cells.add(new Cell(row, column, this.getValue(row, column)));
            }
        }
        return cells;
    }

    public VALUE_T setValue(ROW_T row, COLUMN_T column, VALUE_T value) {
        if (!this.hasRow(row)) {
            throw new IllegalArgumentException("Unknown row " + row == null ? "(null)" : row.toString());
        }
        if (!this.hasColumn(column)) {
            throw new IllegalArgumentException("Unknown column " + column == null ? "(null)" : column.toString());
        }
        return this.values.put(new Coord<ROW_T, COLUMN_T>(row, column), value);
    }

    public VALUE_T getValue(ROW_T row, COLUMN_T column) {
        return this.values.get(new Coord<ROW_T, COLUMN_T>(row, column));
    }

    public boolean isSet(ROW_T row, COLUMN_T column) {
        return this.values.containsKey(new Coord<ROW_T, COLUMN_T>(row, column));
    }

    public VALUE_T unset(ROW_T row, COLUMN_T column) {
        return this.values.remove(new Coord<ROW_T, COLUMN_T>(row, column));
    }

    public static class Cell<R, C, V> {
        public final R row;
        public final C column;
        public final V value;

        public Cell(R row, C column, V value) {
            this.row = row;
            this.column = column;
            this.value = value;
        }
    }

    protected static class Coord<R, C> {
        R row;
        C column;

        public Coord(R row, C column) {
            this.row = row;
            this.column = column;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Coord)) {
                return false;
            }
            Coord c = (Coord)obj;
            if (this.row == null && c.row == null || this.row != null && this.row.equals(c.row)) {
                return this.column == null && c.column == null || this.column != null && this.column.equals(c.column);
            }
            return false;
        }

        public int hashCode() {
            int hashCode = 0;
            if (this.row != null) {
                hashCode = this.row.hashCode();
            }
            if (this.column != null) {
                hashCode ^= this.column.hashCode();
            }
            return hashCode;
        }

        public String toString() {
            return "(" + this.row + "," + this.column + ")";
        }
    }
}

