/*
 * Decompiled with CFR 0.152.
 */
import Xmcda_by_Dhouha.Alternatives;
import Xmcda_by_Dhouha.Criteria;
import Xmcda_by_Dhouha.GestionIncoherentFiles;
import Xmcda_by_Dhouha.PerformanceTable_Config2;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseNonNumericPerfTable {
    static Document document;
    public static final int size = 100;
    private static Object[][] matricePerf;
    private static int index_matrix_line;
    private static int index_matrix_column;
    private String[] type;
    private PerformanceTable_Config2 perfTableConfig2 = new PerformanceTable_Config2();
    private ArrayList<String> listCriterionIDInperformanceTable = new ArrayList();
    private ArrayList<String> listAlternativeIDInperformanceTable = new ArrayList();
    private String errorMessage = "";
    private String warningMessage = "";
    private String warningFromRun = "";

    static {
        matricePerf = new Object[100][100];
        index_matrix_line = 0;
        index_matrix_column = 0;
    }

    public ParseNonNumericPerfTable() {
        this.type = new String[1000];
    }

    public ArrayList<String> getCriterionIDInperformanceTable() {
        return this.listCriterionIDInperformanceTable;
    }

    public ArrayList<String> getAlternativeIDInperformanceTable() {
        return this.listAlternativeIDInperformanceTable;
    }

    public Element getRacine(String path) {
        try {
            SAXBuilder sxb = new SAXBuilder();
            document = sxb.build(new File(path));
        }
        catch (Exception sxb) {
            // empty catch block
        }
        Element racine = document.getRootElement();
        return racine;
    }

    public PerformanceTable_Config2 exploreObjectsPerformanceTable(Element racine) {
        if (racine.getChild("performanceTable") != null) {
            Element perfTabl = racine.getChild("performanceTable");
            if (perfTabl.getChildren("alternativePerformances") != null) {
                List listAltPerF = perfTabl.getChildren("alternativePerformances");
                Iterator i = listAltPerF.iterator();
                String temp = "";
                int numberCriterMax = 0;
                while (i.hasNext()) {
                    numberCriterMax = 0;
                    Element courant = (Element)i.next();
                    if (!this.listAlternativeIDInperformanceTable.contains(courant.getChild("alternativeID").getValue())) {
                        this.listAlternativeIDInperformanceTable.add(courant.getChild("alternativeID").getValue());
                    }
                    index_matrix_line = this.listAlternativeIDInperformanceTable.indexOf(courant.getChild("alternativeID").getValue());
                    List listPerfObjects = courant.getChildren("performance");
                    Iterator j = listPerfObjects.iterator();
                    if (courant.getChildren().size() > numberCriterMax) {
                        // empty if block
                    }
                    numberCriterMax = courant.getChildren().size() - 1;
                    boolean alternativeIDOK = true;
                    int indexType = 0;
                    while (j.hasNext()) {
                        Element courantNiv2 = (Element)j.next();
                        temp = "";
                        if (courantNiv2.getChild("value").getChild("label") != null) {
                            temp = courantNiv2.getChild("value").getChild("label").getValue();
                            this.type[indexType] = "label";
                            ++indexType;
                        } else if (courantNiv2.getChild("value").getChild("boolean") != null) {
                            temp = courantNiv2.getChild("value").getChild("boolean").getValue();
                            this.type[indexType] = "boolean";
                            ++indexType;
                        } else if (courantNiv2.getChild("value").getChild("real") != null) {
                            temp = courantNiv2.getChild("value").getChild("real").getValue();
                            this.type[indexType] = "real";
                            ++indexType;
                        } else if (courantNiv2.getChild("value").getChild("integer") != null) {
                            temp = courantNiv2.getChild("value").getChild("integer").getValue();
                            this.type[indexType] = "integer";
                            ++indexType;
                        } else {
                            alternativeIDOK = false;
                        }
                        if (!this.listCriterionIDInperformanceTable.contains(courantNiv2.getChild("criterionID").getValue())) {
                            this.listCriterionIDInperformanceTable.add(courantNiv2.getChild("criterionID").getValue());
                        }
                        if (temp == "") continue;
                        index_matrix_column = this.listCriterionIDInperformanceTable.indexOf(courantNiv2.getChild("criterionID").getValue());
                        ParseNonNumericPerfTable.matricePerf[ParseNonNumericPerfTable.index_matrix_line][ParseNonNumericPerfTable.index_matrix_column] = temp;
                    }
                    if (alternativeIDOK) continue;
                    this.listAlternativeIDInperformanceTable.remove(courant.getChild("alternativeID").getValue());
                    this.errorMessage = this.errorMessage.concat("Error in the file containing the performance table tag. The value must be real, integer, label or boolean.We have eliminated the corresponding alternative:" + courant.getChild("alternativeID").getValue() + ".");
                }
                for (Element courant : listAltPerF) {
                    String id = courant.getChild("alternativeID").getValue();
                    int sizeInferior = courant.getChildren().size() - 1;
                    if (!this.listAlternativeIDInperformanceTable.contains(id) || sizeInferior >= numberCriterMax) continue;
                    this.listAlternativeIDInperformanceTable.remove(id);
                    this.warningMessage = this.warningMessage.concat("\nThe alternativeID " + id + " was removed because " + "the number of criteria is " + sizeInferior + " instead of " + numberCriterMax + ".");
                }
                this.perfTableConfig2 = new PerformanceTable_Config2(this.listAlternativeIDInperformanceTable, this.listCriterionIDInperformanceTable, matricePerf);
                return this.perfTableConfig2;
            }
            return null;
        }
        return null;
    }

    public PerformanceTable_Config2 run(PerformanceTable_Config2 perfTableAfterParsingXML, Criteria criteriaToUse, Alternatives alternativesToUse) {
        ArrayList<String> listintersectionCriteria;
        ArrayList<String> listintersectionAlternatives;
        GestionIncoherentFiles gest = new GestionIncoherentFiles(criteriaToUse, alternativesToUse, perfTableAfterParsingXML);
        boolean checkAlt = gest.checkAlternatives(alternativesToUse, perfTableAfterParsingXML);
        boolean checkCrit = gest.checkCriteria(criteriaToUse, perfTableAfterParsingXML);
        if (!checkAlt) {
            this.warningFromRun = this.warningFromRun.concat(gest.getWarningAlternatives());
        }
        if (!checkCrit) {
            this.warningFromRun = this.warningFromRun.concat(gest.getWarningCriteria());
        }
        if ((listintersectionAlternatives = gest.getIntersectionAlternativesIDs()).isEmpty()) {
            this.warningFromRun = this.warningFromRun.concat("\nOnly the alternativesIDs in the file containing the performance table tag were considered. Please check your input file containing the alternatives tag.");
            listintersectionAlternatives = perfTableAfterParsingXML.getAlternativeIDs();
        }
        if ((listintersectionCriteria = gest.getIntersectionCriteriaIDs()).isEmpty()) {
            this.warningFromRun = this.warningFromRun.concat("\nOnly the criterionIDs in the file containing the performance table tag were considered. Please check your input file containing the criteria tag.");
            listintersectionCriteria = perfTableAfterParsingXML.getCriterionIDs();
        }
        Object[][] matricePerf = new Object[listintersectionAlternatives.size()][listintersectionCriteria.size()];
        int l = 0;
        while (l < listintersectionAlternatives.size()) {
            int c = 0;
            while (c < listintersectionCriteria.size()) {
                matricePerf[l][c] = perfTableAfterParsingXML.getMatrixObjectElement(perfTableAfterParsingXML.getAlternativeIDs().indexOf(listintersectionAlternatives.get(l)), perfTableAfterParsingXML.getCriterionIDs().indexOf(listintersectionCriteria.get(c)));
                ++c;
            }
            ++l;
        }
        perfTableAfterParsingXML = new PerformanceTable_Config2(listintersectionAlternatives, listintersectionCriteria, matricePerf);
        return perfTableAfterParsingXML;
    }

    public String getError() {
        return this.errorMessage;
    }

    public String getWarning() {
        return this.warningMessage;
    }

    public String gerWarningFromRun() {
        return this.warningFromRun;
    }

    public ArrayList<String> getList(String id) {
        ArrayList<String> result = new ArrayList();
        if (id.equals("alternativeID")) {
            result = this.listAlternativeIDInperformanceTable;
        } else if (id.equals("criterionID")) {
            result = this.listCriterionIDInperformanceTable;
        }
        return result;
    }

    public String[] getTypes() {
        return this.type;
    }
}

