/*
 * Decompiled with CFR 0.152.
 */
import Xmcda_by_Dhouha.Alternatives;
import Xmcda_by_Dhouha.Criteria;
import Xmcda_by_Dhouha.JDOM_Alternatives;
import Xmcda_by_Dhouha.JDOM_Criteria;
import Xmcda_by_Dhouha.Main;
import Xmcda_by_Dhouha.PerformanceTable_Config2;
import Xmcda_by_Dhouha.XmcdaMessage;
import java.io.File;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToNumericTransform {
    private String warningNumericTransform = "";

    public PerformanceTable_Config2 NumericTransform(PerformanceTable_Config2 test, ArrayList<ArrayList<String>> listTransformationLabels, ArrayList<ArrayList<Integer>> listTransformationRanks, boolean[] listStateTransform) {
        int nbrAltern = test.getAlternativeIDs().size();
        int nbrCriter = test.getCriterionIDs().size();
        Object[][] matricePerf = new Object[nbrAltern][nbrCriter];
        int i = 0;
        while (i < nbrAltern) {
            int j = 0;
            while (j < nbrCriter) {
                matricePerf[i][j] = test.getMatrixObjectElement(i, j);
                if (listStateTransform[j]) {
                    ArrayList<String> currentListLabel = listTransformationLabels.get(j);
                    ArrayList<Integer> currentListRanks = listTransformationRanks.get(j);
                    String temp = (String)matricePerf[i][j];
                    if (currentListLabel.contains(temp)) {
                        matricePerf[i][j] = currentListRanks.get(currentListLabel.indexOf(temp));
                    } else {
                        this.warningNumericTransform = this.warningNumericTransform.concat("Error in the file containing the 'scale' tag: there is no ranked label for the value" + matricePerf[i][j] + ".");
                    }
                } else if (i == 0) {
                    this.warningNumericTransform = this.warningNumericTransform.concat("\nWarning: No transformation was proposed for criterion (" + test.getCriterionIDs().get(j) + "). " + "Please check the entry file containing the 'scale' tag.");
                }
                ++j;
            }
            ++i;
        }
        PerformanceTable_Config2 result = new PerformanceTable_Config2(test.getAlternativeIDs(), test.getCriterionIDs(), matricePerf);
        return result;
    }

    public static void main(String[] argv) {
        boolean stopRunning = false;
        String tempErrorMessage = "";
        String warningMessage = "";
        if (!(new File(argv[0]).exists() && new File(argv[1]).exists() && new File(argv[2]).exists() && argv.length == 5)) {
            stopRunning = true;
        }
        if (stopRunning) {
            tempErrorMessage = "Error: unable to run the algorithm. Reason: missing one (or more) entry file(s). Please check your entry files.";
        }
        if (!stopRunning) {
            Main mainFunction = new Main();
            PerformanceTable_Config2 test = new PerformanceTable_Config2();
            String pathAlternatives = argv[0];
            String pathCriteria = argv[1];
            String pathPerfTable = argv[2];
            String errAltern = mainFunction.checkEntryFile(pathAlternatives);
            String errCriter = mainFunction.checkEntryFile(pathCriteria);
            String errPerfTable = mainFunction.checkEntryFile(pathPerfTable);
            if (errAltern != "") {
                tempErrorMessage = tempErrorMessage.concat("\nFatal Error: the file containing the alternatives tag is not a valid XMCDA document.");
            }
            if (errCriter != "") {
                tempErrorMessage = tempErrorMessage.concat("\nFatal Error: the file containing the criteria tag is not a valid XMCDA document.");
            }
            if (errPerfTable != "") {
                tempErrorMessage = tempErrorMessage.concat("\nFatal Error: the file containing the performanceTable tag is not a valid XMCDA document.");
            }
            if (errAltern != "" || errCriter != "" || errPerfTable != "") {
                XmcdaMessage xmcdaMess = new XmcdaMessage();
                xmcdaMess.createErrorMessage(tempErrorMessage);
                String pathOutputMessage = argv[5];
                xmcdaMess.enregistre(pathOutputMessage);
            } else {
                JDOM_Criteria jdomCriter = new JDOM_Criteria();
                mainFunction.PrepareParsing(pathCriteria);
                boolean parseCriterNull = false;
                Criteria criter = jdomCriter.parseCriteriaXML(mainFunction.getRacine());
                if (jdomCriter.getWarning() != "") {
                    warningMessage = warningMessage.equals("") ? "\n" + jdomCriter.getWarning() : warningMessage.concat("\n" + jdomCriter.getWarning());
                }
                if (criter == null) {
                    parseCriterNull = true;
                    tempErrorMessage = tempErrorMessage.equals("") ? "\nFatal Error: the file containing the criteria tag is erroneous or empty." : tempErrorMessage.concat("\nFatal Error: the file containing the criteria tag is erroneous or empty.");
                }
                mainFunction.PrepareParsing(pathAlternatives);
                JDOM_Alternatives jdomAlter = new JDOM_Alternatives();
                boolean parseAlternativesNull = false;
                Alternatives alter = jdomAlter.exploreAlternativesXML(mainFunction.getRacine());
                if (jdomAlter.getWarning() != "") {
                    warningMessage = warningMessage.equals("") ? "\n" + jdomAlter.getWarning() : warningMessage.concat("\n" + jdomAlter.getWarning());
                }
                if (alter == null) {
                    parseAlternativesNull = true;
                    tempErrorMessage = tempErrorMessage.equals("") ? "\nFatal Error: the file containing the alternatives tag is erroneous or empty." : tempErrorMessage.concat("\nFatal Error: the file containing the alternatives tag is erroneous or empty.");
                }
                mainFunction.PrepareParsing(pathPerfTable);
                ParseNonNumericPerfTable jdomPerfTable = new ParseNonNumericPerfTable();
                boolean parsePerfTableNull = false;
                PerformanceTable_Config2 perfTable = jdomPerfTable.exploreObjectsPerformanceTable(mainFunction.getRacine());
                if (jdomPerfTable.getError() != "") {
                    warningMessage = warningMessage.concat("\n" + jdomPerfTable.getError());
                }
                if (jdomPerfTable.getWarning() != "") {
                    warningMessage = warningMessage.concat("\n" + jdomPerfTable.getWarning());
                }
                if (perfTable == null) {
                    parsePerfTableNull = true;
                    tempErrorMessage = tempErrorMessage.equals("") ? "\nFatal Error: the file containing the performanceTable tag is erroneous or empty." : tempErrorMessage.concat("\nFatal Error: the file containing the performanceTable tag is erroneous or empty.");
                }
                if (!(parseCriterNull || parseAlternativesNull || parsePerfTableNull)) {
                    test = jdomPerfTable.run(perfTable, criter, alter);
                    warningMessage = warningMessage.concat(jdomPerfTable.gerWarningFromRun());
                    boolean statusParseMethod = true;
                    String[] typesInPerfTable = jdomPerfTable.getTypes();
                    if (test.getAlternativeIDs().size() != 0 && test.getCriterionIDs().size() != 0) {
                        ParseCriteria pc = new ParseCriteria();
                        mainFunction.PrepareParsing(pathCriteria);
                        statusParseMethod = pc.getTransformation(mainFunction.getRacine(), test.getCriterionIDs());
                        if (!statusParseMethod) {
                            tempErrorMessage = tempErrorMessage.concat("\n We cannot run the algorithm since the transformation is not specified.\n");
                        } else {
                            ArrayList<ArrayList<String>> listTransformationLabels = pc.getLabels();
                            ArrayList<ArrayList<Integer>> listTransformationRanks = pc.getRanks();
                            boolean[] listStateTransform = pc.getListStateTransforma();
                            ToNumericTransform numTrans = new ToNumericTransform();
                            test = numTrans.NumericTransform(test, listTransformationLabels, listTransformationRanks, listStateTransform);
                            warningMessage = warningMessage.concat(numTrans.getWarningNumericTransform());
                        }
                    } else {
                        tempErrorMessage = tempErrorMessage.concat("\n We cannot run the algorithm since the criteria list or the alternatives list of the PROJECT is empty.\n");
                    }
                    XmcdaMessage xmcdaMess = new XmcdaMessage();
                    xmcdaMess.createLogMessage(errCriter, errAltern, errPerfTable, warningMessage, tempErrorMessage);
                    String pathOutputMessage = argv[argv.length - 1];
                    xmcdaMess.enregistre(pathOutputMessage);
                    if (test.getAlternativeIDs().size() != 0 && test.getCriterionIDs().size() != 0 && statusParseMethod) {
                        NumPerfTableFile outputPerfTable = new NumPerfTableFile();
                        outputPerfTable.createOutputFile(test, typesInPerfTable, perfTable.getCriterionIDs(), "Transformed numeric performance table");
                        String pathOutputFile = argv[argv.length - 2];
                        outputPerfTable.save(pathOutputFile);
                    }
                } else {
                    XmcdaMessage xmcdaMess = new XmcdaMessage();
                    xmcdaMess.createErrorMessage(tempErrorMessage);
                    String pathOutputMessage = argv[argv.length - 1];
                    xmcdaMess.enregistre(pathOutputMessage);
                }
            }
        } else {
            XmcdaMessage xmcdaMess = new XmcdaMessage();
            xmcdaMess.createErrorMessage(tempErrorMessage);
            String pathOutputMessage = argv[argv.length - 1];
            xmcdaMess.enregistre(pathOutputMessage);
        }
    }

    public String getWarningNumericTransform() {
        return this.warningNumericTransform;
    }

    public void setWarningNumericTransform(String war) {
        this.warningNumericTransform = war;
    }
}

