/*
 * Decompiled with CFR 0.152.
 */
import Xmcda_by_Dhouha.Alternatives;
import Xmcda_by_Dhouha.Criteria;
import Xmcda_by_Dhouha.JDOM_Alternatives;
import Xmcda_by_Dhouha.JDOM_Criteria;
import Xmcda_by_Dhouha.JDOM_PerformanceTable;
import Xmcda_by_Dhouha.Main;
import Xmcda_by_Dhouha.PerformanceTable_Config2;
import Xmcda_by_Dhouha.XmcdaMessage;
import java.io.File;

public class AlgoFirst {
    private PerformanceTable_Config2 projectPerfTable;

    public AlgoFirst(PerformanceTable_Config2 projectPerfTable) {
        this.projectPerfTable = projectPerfTable;
    }

    public float[] maximum() {
        float[] max = new float[this.projectPerfTable.getCriterionIDs().size()];
        float element = this.projectPerfTable.getMatrixElement(0, 0);
        int j = 0;
        while (j < this.projectPerfTable.getCriterionIDs().size()) {
            int indexCrit = this.projectPerfTable.getCriterionIDs().indexOf(this.projectPerfTable.getCriterionIDs().get(j));
            max[j] = this.projectPerfTable.getMatrixElement(this.projectPerfTable.getAlternativeIDs().indexOf(this.projectPerfTable.getAlternativeIDs().get(0)), indexCrit);
            int i = 0;
            while (i < this.projectPerfTable.getAlternativeIDs().size()) {
                int indexAlt = this.projectPerfTable.getAlternativeIDs().indexOf(this.projectPerfTable.getAlternativeIDs().get(i));
                element = this.projectPerfTable.getMatrixElement(indexAlt, indexCrit);
                if (element > max[j]) {
                    max[j] = element;
                }
                ++i;
            }
            ++j;
        }
        return max;
    }

    public float[] minimmum() {
        float[] min = new float[this.projectPerfTable.getCriterionIDs().size()];
        int j = 0;
        while (j < this.projectPerfTable.getCriterionIDs().size()) {
            int indexCrit = this.projectPerfTable.getCriterionIDs().indexOf(this.projectPerfTable.getCriterionIDs().get(j));
            min[j] = this.projectPerfTable.getMatrixElement(this.projectPerfTable.getAlternativeIDs().indexOf(this.projectPerfTable.getAlternativeIDs().get(0)), indexCrit);
            int i = 0;
            while (i < this.projectPerfTable.getAlternativeIDs().size()) {
                int indexAlt = this.projectPerfTable.getAlternativeIDs().indexOf(this.projectPerfTable.getAlternativeIDs().get(i));
                if (this.projectPerfTable.getMatrixElement(indexAlt, indexCrit) < min[j]) {
                    min[j] = this.projectPerfTable.getMatrixElement(indexAlt, indexCrit);
                }
                ++i;
            }
            ++j;
        }
        return min;
    }

    public float[] variance(float[] moyenne) {
        float[] variance = new float[this.projectPerfTable.getCriterionIDs().size()];
        int j = 0;
        while (j < this.projectPerfTable.getCriterionIDs().size()) {
            variance[j] = 0.0f;
            int indexCrit = this.projectPerfTable.getCriterionIDs().indexOf(this.projectPerfTable.getCriterionIDs().get(j));
            int i = 0;
            while (i < this.projectPerfTable.getAlternativeIDs().size()) {
                int indexAlt = this.projectPerfTable.getAlternativeIDs().indexOf(this.projectPerfTable.getAlternativeIDs().get(i));
                int n = j;
                variance[n] = (float)((double)variance[n] + Math.pow(this.projectPerfTable.getMatrixElement(indexAlt, indexCrit) - moyenne[j], 2.0));
                ++i;
            }
            ++j;
        }
        j = 0;
        while (j < this.projectPerfTable.getCriterionIDs().size()) {
            int n = j;
            variance[n] = variance[n] / (float)this.projectPerfTable.getAlternativeIDs().size();
            variance[j] = (float)(Math.floor((double)variance[j] * 100.0) / 100.0);
            ++j;
        }
        return variance;
    }

    public float[] standardDeviation(float[] variance) {
        float[] stdDev = new float[this.projectPerfTable.getCriterionIDs().size()];
        int j = 0;
        while (j < this.projectPerfTable.getCriterionIDs().size()) {
            stdDev[j] = 0.0f;
            ++j;
        }
        j = 0;
        while (j < this.projectPerfTable.getCriterionIDs().size()) {
            int n = j;
            stdDev[n] = (float)((double)stdDev[n] + Math.sqrt(variance[j]));
            ++j;
        }
        j = 0;
        while (j < this.projectPerfTable.getCriterionIDs().size()) {
            stdDev[j] = (float)(Math.floor((double)stdDev[j] * 100.0) / 100.0);
            ++j;
        }
        return stdDev;
    }

    public float[] median() {
        float[] median = new float[this.projectPerfTable.getCriterionIDs().size()];
        int size = this.projectPerfTable.getAlternativeIDs().size();
        float[] tri = new float[size];
        int j = 0;
        while (j < this.projectPerfTable.getCriterionIDs().size()) {
            median[j] = 0.0f;
            ++j;
        }
        int j2 = 0;
        while (j2 < this.projectPerfTable.getCriterionIDs().size()) {
            int indexCrit = this.projectPerfTable.getCriterionIDs().indexOf(this.projectPerfTable.getCriterionIDs().get(j2));
            int i = 0;
            while (i < size) {
                int indexAlt = this.projectPerfTable.getAlternativeIDs().indexOf(this.projectPerfTable.getAlternativeIDs().get(i));
                tri[i] = this.projectPerfTable.getMatrixElement(indexAlt, indexCrit);
                ++i;
            }
            i = 0;
            while (i < size - 1) {
                if (tri[i] > tri[i + 1]) {
                    float temp = tri[i];
                    tri[i] = tri[i + 1];
                    tri[i + 1] = temp;
                }
                ++i;
            }
            if (size % 2 == 0) {
                median[j2] = size > 2 ? (float)((double)(tri[size / 2] + tri[size / 2 + 1]) / 2.0) : (float)((double)(tri[0] + tri[1]) / 2.0);
                median[j2] = (float)(Math.floor((double)median[j2] * 100.0) / 100.0);
            } else {
                median[j2] = size > 1 ? tri[(size + 1) / 2] : tri[0];
                median[j2] = (float)(Math.floor((double)median[j2] * 100.0) / 100.0);
            }
            ++j2;
        }
        return median;
    }

    public float[] mean() {
        float[] mean = new float[this.projectPerfTable.getCriterionIDs().size()];
        int j = 0;
        while (j < this.projectPerfTable.getCriterionIDs().size()) {
            mean[j] = 0.0f;
            ++j;
        }
        j = 0;
        while (j < this.projectPerfTable.getCriterionIDs().size()) {
            int indexCrit = this.projectPerfTable.getCriterionIDs().indexOf(this.projectPerfTable.getCriterionIDs().get(j));
            int i = 0;
            while (i < this.projectPerfTable.getAlternativeIDs().size()) {
                int indexAlt = this.projectPerfTable.getAlternativeIDs().indexOf(this.projectPerfTable.getAlternativeIDs().get(i));
                int n = j;
                mean[n] = mean[n] + this.projectPerfTable.getMatrixElement(indexAlt, indexCrit);
                ++i;
            }
            ++j;
        }
        j = 0;
        while (j < this.projectPerfTable.getCriterionIDs().size()) {
            int n = j;
            mean[n] = mean[n] / (float)this.projectPerfTable.getAlternativeIDs().size();
            mean[j] = (float)(Math.floor((double)mean[j] * 100.0) / 100.0);
            ++j;
        }
        return mean;
    }

    public void printMean(float[] mean) {
        int j = 0;
        while (j < this.projectPerfTable.getCriterionIDs().size()) {
            System.out.println("Mean:" + mean[j]);
            ++j;
        }
    }

    public static void main(String[] argv) {
        boolean stopRunning = false;
        String tempErrorMessage = "";
        String warningMessage = "";
        if (!(argv[0] != null && argv[1] != null && argv[2] != null && argv.length == 10 && new File(argv[0]).exists() && new File(argv[1]).exists() && new File(argv[2]).exists())) {
            stopRunning = true;
            tempErrorMessage = "Error: unable to run the algorithm. Reason: missing one (or more) entry file(s). Please check your entry files.";
        }
        if (!stopRunning) {
            Main mainFunction = new Main();
            PerformanceTable_Config2 test = new PerformanceTable_Config2();
            String pathAlternatives = argv[0];
            String errAltern = mainFunction.checkEntryFile(pathAlternatives);
            String pathCriteria = argv[1];
            String errCriter = mainFunction.checkEntryFile(pathCriteria);
            String pathPerfTable = argv[2];
            String errPerfTable = mainFunction.checkEntryFile(pathPerfTable);
            if (errAltern != "") {
                tempErrorMessage = tempErrorMessage.concat("\nFatal Error: the file containing the alternatives tag is not a valid XMCDA document.");
            }
            if (errCriter != "") {
                tempErrorMessage = tempErrorMessage.concat("\nFatal Error: the file containing the criteria tag is not a valid XMCDA document.");
            }
            if (errPerfTable != "") {
                tempErrorMessage = tempErrorMessage.concat("\nFatal Error: the file containing the performanceTable tag is not a valid XMCDA document.");
            }
            if (errAltern != "" || errCriter != "" || errPerfTable != "") {
                XmcdaMessage xmcdaMess = new XmcdaMessage();
                xmcdaMess.createErrorMessage(tempErrorMessage);
                String pathOutputMessage = argv[5];
                xmcdaMess.enregistre(pathOutputMessage);
            } else {
                JDOM_Criteria jdomCriter = new JDOM_Criteria();
                mainFunction.PrepareParsing(pathCriteria);
                boolean parseCriterNull = false;
                Criteria criter = jdomCriter.parseCriteriaXML(mainFunction.getRacine());
                if (jdomCriter.getWarning() != "") {
                    warningMessage = warningMessage.equals("") ? "\n" + jdomCriter.getWarning() : warningMessage.concat("\n" + jdomCriter.getWarning());
                }
                if (criter == null) {
                    parseCriterNull = true;
                    tempErrorMessage = tempErrorMessage.equals("") ? "\nFatal Error: the file containing the criteria tag is erroneous or empty." : tempErrorMessage.concat("\nFatal Error: the file containing the criteria tag is erroneous or empty.");
                }
                mainFunction.PrepareParsing(pathAlternatives);
                JDOM_Alternatives jdomAlter = new JDOM_Alternatives();
                boolean parseAlternativesNull = false;
                Alternatives alter = jdomAlter.exploreAlternativesXML(mainFunction.getRacine());
                if (jdomAlter.getWarning() != "") {
                    warningMessage = warningMessage.equals("") ? "\n" + jdomAlter.getWarning() : warningMessage.concat("\n" + jdomAlter.getWarning());
                }
                if (alter == null) {
                    parseAlternativesNull = true;
                    tempErrorMessage = tempErrorMessage.equals("") ? "\nFatal Error: the file containing the alternatives tag is erroneous or empty." : tempErrorMessage.concat("\nFatal Error: the file containing the alternatives tag is erroneous or empty.");
                }
                mainFunction.PrepareParsing(pathPerfTable);
                JDOM_PerformanceTable jdomPerfTable = new JDOM_PerformanceTable();
                boolean parsePerfTableNull = false;
                PerformanceTable_Config2 perfTable = jdomPerfTable.explorePerformanceTable(mainFunction.getRacine());
                if (jdomPerfTable.getErrorMessage() != "") {
                    warningMessage = warningMessage.concat("\n" + jdomPerfTable.getErrorMessage());
                }
                if (jdomPerfTable.getWarningMessage() != "") {
                    warningMessage = warningMessage.concat(jdomPerfTable.getWarningMessage());
                }
                if (perfTable == null) {
                    parsePerfTableNull = true;
                    tempErrorMessage = tempErrorMessage.equals("") ? "\nFatal Error: the file containing the performanceTable tag is erroneous or empty." : tempErrorMessage.concat("\nFatal Error: the file containing the performanceTable tag is erroneous or empty.");
                }
                if (!(parseCriterNull || parseAlternativesNull || parsePerfTableNull)) {
                    String pathOutputMessage;
                    XmcdaMessage xmcdaMess;
                    test = mainFunction.run(test, pathCriteria, pathAlternatives, pathPerfTable);
                    warningMessage = mainFunction.getWarningMessage();
                    tempErrorMessage = mainFunction.getErrorMessage();
                    AlgoFirst algo = new AlgoFirst(test);
                    float[] tabMean = new float[]{};
                    float[] tabVariance = new float[]{};
                    float[] tabStandardDeviation = new float[]{};
                    float[] tabMaximum = new float[]{};
                    float[] tabMinumum = new float[]{};
                    float[] tabMedian = new float[]{};
                    if (test.getAlternativeIDs().size() != 0 && test.getCriterionIDs().size() != 0) {
                        tabMean = algo.mean();
                        tabMaximum = algo.maximum();
                        tabMinumum = algo.minimmum();
                        tabVariance = algo.variance(tabMean);
                        tabStandardDeviation = algo.standardDeviation(tabVariance);
                        tabMedian = algo.median();
                        xmcdaMess = new XmcdaMessage();
                        xmcdaMess.createLogMessage(errCriter, errAltern, errPerfTable, warningMessage, tempErrorMessage);
                        pathOutputMessage = argv[3];
                        xmcdaMess.enregistre(pathOutputMessage);
                    } else {
                        tempErrorMessage = tempErrorMessage.concat("\n We cannot run the algorithm since the criteria list or the alternatives list of the PROJECT is empty.\n");
                        xmcdaMess = new XmcdaMessage();
                        xmcdaMess.createErrorMessage(tempErrorMessage);
                        pathOutputMessage = argv[3];
                        xmcdaMess.enregistre(pathOutputMessage);
                    }
                    if (test.getAlternativeIDs().size() != 0 && test.getCriterionIDs().size() != 0) {
                        OutputXmcdaFile outputStatisticsFileMean = new OutputXmcdaFile();
                        outputStatisticsFileMean.createOutputFile(test, tabMean, "mean values");
                        String pathOutputFileMean = argv[4];
                        outputStatisticsFileMean.enregistre(pathOutputFileMean);
                        OutputXmcdaFile outputStatisticsFileMax = new OutputXmcdaFile();
                        outputStatisticsFileMax.createOutputFile(test, tabMaximum, "maximum values");
                        String pathOutputFileMax = argv[5];
                        outputStatisticsFileMax.enregistre(pathOutputFileMax);
                        OutputXmcdaFile outputStatisticsFileMin = new OutputXmcdaFile();
                        outputStatisticsFileMin.createOutputFile(test, tabMinumum, "minimum values");
                        String pathOutputFileMin = argv[6];
                        outputStatisticsFileMin.enregistre(pathOutputFileMin);
                        OutputXmcdaFile outputStatisticsFileVar = new OutputXmcdaFile();
                        outputStatisticsFileVar.createOutputFile(test, tabVariance, "variance");
                        String pathOutputFileVar = argv[7];
                        outputStatisticsFileVar.enregistre(pathOutputFileVar);
                        OutputXmcdaFile outputStatisticsFileStdv = new OutputXmcdaFile();
                        outputStatisticsFileStdv.createOutputFile(test, tabStandardDeviation, "standard deviation");
                        String pathOutputMeanFileStdv = argv[8];
                        outputStatisticsFileStdv.enregistre(pathOutputMeanFileStdv);
                        OutputXmcdaFile outputStatisticsFileMedian = new OutputXmcdaFile();
                        outputStatisticsFileMedian.createOutputFile(test, tabMedian, "median values");
                        String pathOutputMeanFileMedian = argv[9];
                        outputStatisticsFileMedian.enregistre(pathOutputMeanFileMedian);
                    }
                } else {
                    XmcdaMessage xmcdaMess = new XmcdaMessage();
                    xmcdaMess.createErrorMessage(tempErrorMessage);
                    String pathOutputMessage = argv[3];
                    xmcdaMess.enregistre(pathOutputMessage);
                }
            }
        } else {
            XmcdaMessage xmcdaMess = new XmcdaMessage();
            xmcdaMess.createErrorMessage(tempErrorMessage);
            String pathOutputMessage = argv[3];
            xmcdaMess.enregistre(pathOutputMessage);
        }
    }
}

