	public static PerformanceTable filter(PerformanceTable performanceTable, CriteriaValues intervals)
	{
		PerformanceTable filtered = new PerformanceTable();

		for (Alternative alternative: performanceTable.alternatives())
		{
			for (Criterion criterion: performanceTable.criteria())
			{
				CriterionValue crit_interval = intervals.getCriterionValue(criterion);
				final float value = performanceTable.getValue(alternative, criterion);
				if ( crit_interval != null && ! ( (Interval) crit_interval.getObject()).isWithin(value) )
				{
					filtered.removeRow(alternative);
					break;
				}
				filtered.addAlternative(alternative, true);
				filtered.addCriterion(criterion, true);
				filtered.setValue(alternative, criterion, value);
			}
		}
		return filtered;
	}
