/*
 * Decompiled with CFR 0.152.
 */
import eu.telecom_bretagne.xmcda.Alternative;
import eu.telecom_bretagne.xmcda.Criterion;
import eu.telecom_bretagne.xmcda.PerformanceTable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class OutputPerfTableFile {
    static Element racine = new Element("XMCDA");
    private Namespace xsi = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    private Namespace xmcda = Namespace.getNamespace((String)"xmcda", (String)"http://www.decision-deck.org/2009/XMCDA-2.0.0");
    static Document document = new Document(racine);

    public void save(String fichier) {
        try {
            XMLOutputter sortie = new XMLOutputter(Format.getPrettyFormat());
            FileOutputStream fos = new FileOutputStream(fichier);
            sortie.output(document, (OutputStream)fos);
            fos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void createOutputFile(PerformanceTable projectPerfTable, String commentToPut) {
        racine.setNamespace(this.xmcda);
        racine.addNamespaceDeclaration(this.xsi);
        racine.addNamespaceDeclaration(this.xmcda);
        racine.setAttribute("schemaLocation", "http://www.decision-deck.org/2009/XMCDA-2.0.0 http://www.decision-deck.org/xmcda/_downloads/XMCDA-2.0.0.xsd", this.xsi);
        List contents = racine.getContent();
        contents.clear();
        Element performanceTable = new Element("performanceTable");
        racine.addContent((Content)performanceTable);
        Attribute name = new Attribute("mcdaConcept", commentToPut);
        performanceTable.setAttribute(name);
        for (Alternative alternative : projectPerfTable.alternatives()) {
            Element alternativePerformances = new Element("alternativePerformances");
            performanceTable.addContent((Content)alternativePerformances);
            Element alternativeID = new Element("alternativeID");
            alternativePerformances.addContent((Content)alternativeID);
            alternativeID.setText(alternative.id());
            for (Criterion criterion : projectPerfTable.criteria()) {
                Element performance = new Element("performance");
                alternativePerformances.addContent((Content)performance);
                Element criterionID = new Element("criterionID");
                performance.addContent((Content)criterionID);
                criterionID.setText(criterion.id());
                Element value = new Element("value");
                performance.addContent((Content)value);
                Element real = new Element("real");
                value.addContent((Content)real);
                real.setText(Float.toString(((Float)projectPerfTable.getValue(alternative, criterion)).floatValue()));
            }
        }
    }
}

