/*
 * Decompiled with CFR 0.152.
 */
import eu.telecom_bretagne.xmcda.Alternative;
import eu.telecom_bretagne.xmcda.Alternatives;
import eu.telecom_bretagne.xmcda.Criteria;
import eu.telecom_bretagne.xmcda.Criterion;
import eu.telecom_bretagne.xmcda.JDOM_Alternatives;
import eu.telecom_bretagne.xmcda.JDOM_Criteria;
import eu.telecom_bretagne.xmcda.JDOM_PerformanceTable;
import eu.telecom_bretagne.xmcda.Main;
import eu.telecom_bretagne.xmcda.PerformanceTable;
import eu.telecom_bretagne.xmcda.XmcdaMessage;
import java.io.File;
import java.util.Map;

public class transformation {
    protected float getMaximum(PerformanceTable test, Criterion criterion) {
        float max = Float.MIN_VALUE;
        for (Alternative alternative : test.alternatives()) {
            float courant = ((Float)test.getValue(alternative, criterion)).floatValue();
            if (!(courant > max)) continue;
            max = courant;
        }
        return max;
    }

    protected float getMinimum(PerformanceTable test, Criterion criterion) {
        float min = Float.MAX_VALUE;
        for (Alternative alternative : test.alternatives()) {
            float courant = ((Float)test.getValue(alternative, criterion)).floatValue();
            if (!(courant < min)) continue;
            min = courant;
        }
        return min;
    }

    protected float getMean(PerformanceTable test, Criterion criterion) {
        float mean = 0.0f;
        for (Alternative alternative : test.alternatives()) {
            mean += ((Float)test.getValue(alternative, criterion)).floatValue();
        }
        return mean /= (float)test.alternatives().size();
    }

    protected float getVariance(PerformanceTable test, Criterion criterion, float mean) {
        float var = 0.0f;
        for (Alternative alternative : test.alternatives()) {
            float courant = ((Float)test.getValue(alternative, criterion)).floatValue();
            var = (float)((double)var + Math.pow(courant - mean, 2.0));
        }
        return var;
    }

    protected PerformanceTable divideByMax(PerformanceTable test, Criterion criterion, boolean allTheCriteria, PerformanceTable matrixToUse) {
        PerformanceTable matricePerf = new PerformanceTable(test);
        if (allTheCriteria) {
            for (Criterion _criterion : test.criteria()) {
                float max = this.getMaximum(test, _criterion);
                for (Alternative alternative : test.alternatives()) {
                    matricePerf.setValue(alternative, _criterion, Float.valueOf(((Float)test.getValue(alternative, _criterion)).floatValue() / max));
                }
            }
        } else {
            float max = this.getMaximum(test, criterion);
            for (Alternative alternative : test.alternatives()) {
                matrixToUse.setValue(alternative, criterion, Float.valueOf(((Float)test.getValue(alternative, criterion)).floatValue() / max));
            }
        }
        if (allTheCriteria) {
            return matricePerf;
        }
        return matrixToUse;
    }

    protected PerformanceTable minMax(PerformanceTable test, Criterion criterion, boolean allTheCriteria, PerformanceTable matrixToUse) {
        PerformanceTable matricePerf = new PerformanceTable(test);
        if (allTheCriteria) {
            for (Criterion _criterion : test.criteria()) {
                float max = this.getMaximum(test, _criterion);
                float min = this.getMinimum(test, _criterion);
                for (Alternative alternative : test.alternatives()) {
                    matricePerf.setValue(alternative, _criterion, Float.valueOf((((Float)test.getValue(alternative, _criterion)).floatValue() - min) / (max - min)));
                }
            }
        } else {
            float max = this.getMaximum(test, criterion);
            float min = this.getMinimum(test, criterion);
            for (Alternative alternative : test.alternatives()) {
                matrixToUse.setValue(alternative, criterion, Float.valueOf((((Float)test.getValue(alternative, criterion)).floatValue() - min) / (max - min)));
            }
        }
        if (allTheCriteria) {
            return matricePerf;
        }
        return matrixToUse;
    }

    protected PerformanceTable meanStdv(PerformanceTable test, Criterion criterion, boolean allTheCriteria, PerformanceTable matrixToUse) {
        PerformanceTable matricePerf = new PerformanceTable(test);
        if (allTheCriteria) {
            for (Criterion _criterion : test.criteria()) {
                float mean = this.getMean(test, _criterion);
                float var = this.getVariance(test, _criterion, mean);
                float stdv = (float)Math.sqrt(var);
                for (Alternative alternative : test.alternatives()) {
                    matricePerf.setValue(alternative, _criterion, Float.valueOf((float)(1.0 / ((double)stdv * Math.sqrt(Math.PI * 2)) * Math.exp(-Math.pow(((Float)test.getValue(alternative, _criterion)).floatValue() - mean, 2.0) / (double)(2.0f * var)))));
                }
            }
        } else {
            float mean = this.getMean(test, criterion);
            float var = this.getVariance(test, criterion, mean);
            float stdv = (float)Math.sqrt(var);
            for (Alternative alternative : test.alternatives()) {
                matrixToUse.setValue(alternative, criterion, Float.valueOf((float)(1.0 / ((double)stdv * Math.sqrt(Math.PI * 2)) * Math.exp(-Math.pow(((Float)test.getValue(alternative, criterion)).floatValue() - mean, 2.0) / (double)(2.0f * var)))));
            }
        }
        if (allTheCriteria) {
            return matricePerf;
        }
        return matrixToUse;
    }

    public PerformanceTable uniqueTransform(PerformanceTable test, String transf_type) {
        PerformanceTable matricePerf = new PerformanceTable(test);
        for (Alternative alternative : test.alternatives()) {
            for (Criterion criterion : test.criteria()) {
                matricePerf.addRow(alternative, true);
                matricePerf.addColumn(criterion, true);
                matricePerf.setValue(alternative, criterion, (Float)test.getValue(alternative, criterion));
            }
        }
        if (transf_type.equals("by max")) {
            matricePerf = this.divideByMax(test, null, true, null);
        } else if (transf_type.equals("min max")) {
            matricePerf = this.minMax(test, null, true, null);
        } else if (transf_type.equals("by mean and stdv")) {
            matricePerf = this.meanStdv(test, null, true, null);
        }
        return matricePerf;
    }

    public String UniqueTransformWarning(PerformanceTable test, String transf_type) {
        String warning = "";
        if (!(transf_type.equals("by max") || transf_type.equals("min max") || transf_type.equals("by mean and stdv"))) {
            warning = "You have not entered a specific transformation for criteria. No transformation was applied.";
        }
        return warning;
    }

    public PerformanceTable MultipleTransform(PerformanceTable test, String warningMessage, Map<String, String> transformations) {
        PerformanceTable matricePerf = new PerformanceTable(test);
        for (Alternative alternative : test.alternatives()) {
            for (Criterion criterion : test.criteria()) {
                matricePerf.setValue(alternative, criterion, (Float)test.getValue(alternative, criterion));
            }
        }
        for (Criterion criterion : test.criteria()) {
            if (transformations.containsKey(criterion.id())) {
                String transformation2 = transformations.get(criterion.id());
                if (transformation2.equals("by max")) {
                    matricePerf = this.divideByMax(test, criterion, false, matricePerf);
                    continue;
                }
                if (transformation2.equals("min max")) {
                    matricePerf = this.minMax(test, criterion, false, matricePerf);
                    continue;
                }
                if (!transformation2.equals("by mean and stdv")) continue;
                matricePerf = this.meanStdv(test, criterion, false, matricePerf);
                continue;
            }
            warningMessage = warningMessage.concat("You have not entered a specific transformation for criterion " + criterion.id() + ". No transformation was applied.");
        }
        return matricePerf;
    }

    public String MultipleTransformWarning(PerformanceTable test, Map<String, String> transformations) {
        String warningMessage = "";
        for (Criterion criterion : test.criteria()) {
            if (transformations.containsKey(criterion.id())) {
                String transformation2 = transformations.get(criterion.id());
                if (transformation2.equals("by max") || transformation2.equals("min max") || transformation2.equals("by mean and stdv")) continue;
                warningMessage = String.valueOf(warningMessage) + "You have not entered a correct transformation for criterion " + criterion.id() + ". No transformation was applied.";
                continue;
            }
            warningMessage = String.valueOf(warningMessage) + "You have not entered a specific transformation for criterion " + criterion.id() + ". No transformation was applied.";
        }
        return warningMessage;
    }

    public static void main(String[] argv) {
        String tempErrorMessage = "";
        String warningMessage = "";
        if (argv.length != 6) {
            System.err.println("Usage: alternatives.xml criteria.xml performanceTable.xml parameters.xml transformedPerformanceTable.xml messages.xml");
            System.err.println("       The 4 first files are inputs, the remaining ones are outputs");
            System.exit(-1);
        }
        String pathAlternatives = argv[0];
        String pathCriteria = argv[1];
        String pathPerfTable = argv[2];
        String pathParameters = argv[3];
        String pathOutputFile = argv[4];
        String pathOutputMessage = argv[5];
        if (!(new File(pathAlternatives).exists() && new File(pathCriteria).exists() && new File(pathPerfTable).exists() && new File(pathParameters).exists())) {
            tempErrorMessage = "Error: unable to run the algorithm. Reason: missing one (or more) entry file(s). Please check your entry files.";
            new XmcdaMessage().createErrorMessage(tempErrorMessage).enregistre(pathOutputMessage);
            return;
        }
        Main mainFunction = new Main();
        String errAltern = mainFunction.checkEntryFile(pathAlternatives);
        String errCriter = mainFunction.checkEntryFile(pathCriteria);
        String errPerfTable = mainFunction.checkEntryFile(pathPerfTable);
        String errParam = mainFunction.checkEntryFile(pathParameters);
        if (!"".equals(errAltern)) {
            tempErrorMessage = String.valueOf(tempErrorMessage) + "\nFatal Error: the file containing the alternatives tag is not a valid XMCDA document (" + errAltern + ").";
        }
        if (!"".equals(errCriter)) {
            tempErrorMessage = String.valueOf(tempErrorMessage) + "\nFatal Error: the file containing the criteria tag is not a valid XMCDA document (" + errCriter + ").";
        }
        if (!"".equals(errPerfTable)) {
            tempErrorMessage = String.valueOf(tempErrorMessage) + "\nFatal Error: the file containing the performanceTable tag is not a valid XMCDA document (" + errPerfTable + ").";
        }
        if (!"".equals(errParam)) {
            tempErrorMessage = String.valueOf(tempErrorMessage) + "\nFatal Error: the file containing the methodParameters tag is not a valid XMCDA document (" + errParam + ").";
        }
        if (!"".equals(tempErrorMessage)) {
            new XmcdaMessage().createErrorMessage(tempErrorMessage).enregistre(pathOutputMessage);
            return;
        }
        ParametersPerCriter paramPerCriter = new ParametersPerCriter();
        mainFunction.PrepareParsing(pathParameters);
        boolean statusUserParam = paramPerCriter.parse(mainFunction.getRacine());
        boolean uniqueTransform = paramPerCriter.getUniqueTransformation();
        if (!"".equals(paramPerCriter.getWarning())) {
            warningMessage = String.valueOf(warningMessage) + "\n" + paramPerCriter.getWarning();
        }
        if (!statusUserParam) {
            tempErrorMessage = !"".equals(paramPerCriter.getWarning()) ? String.valueOf(tempErrorMessage) + "\nFatal Error: the file containing the parameters is erroneous or empty (" + paramPerCriter.getWarning() + ")." : String.valueOf(tempErrorMessage) + "\nFatal Error: the file containing the parameters is erroneous or empty.";
        }
        JDOM_Criteria jdomCriter = new JDOM_Criteria();
        mainFunction.PrepareParsing(pathCriteria);
        Criteria criter = jdomCriter.parseCriteriaXML(mainFunction.getRacine());
        if (!"".equals(jdomCriter.getWarning())) {
            warningMessage = String.valueOf(warningMessage) + "\n" + jdomCriter.getWarning();
        }
        if (criter == null) {
            tempErrorMessage = String.valueOf(tempErrorMessage) + "\nFatal Error: the file containing the criteria tag is erroneous or empty.";
        }
        mainFunction.PrepareParsing(pathAlternatives);
        JDOM_Alternatives jdomAlter = new JDOM_Alternatives();
        Alternatives alter = jdomAlter.exploreAlternativesXML(mainFunction.getRacine());
        if (!"".equals(jdomAlter.getWarning())) {
            warningMessage = String.valueOf(warningMessage) + "\n" + jdomAlter.getWarning();
        }
        if (alter == null) {
            tempErrorMessage = String.valueOf(tempErrorMessage) + "\nFatal Error: the file containing the alternatives tag is erroneous or empty.";
        }
        mainFunction.PrepareParsing(pathPerfTable);
        JDOM_PerformanceTable jdomPerfTable = new JDOM_PerformanceTable();
        PerformanceTable perfTable = jdomPerfTable.explorePerformanceTable(mainFunction.getRacine());
        if ("".equals(jdomPerfTable.getErrorMessage())) {
            warningMessage = String.valueOf(warningMessage) + "\n" + jdomPerfTable.getErrorMessage();
        }
        if (perfTable == null) {
            tempErrorMessage = String.valueOf(tempErrorMessage) + "\nFatal Error: the file containing the performanceTable tag is erroneous or empty.";
        }
        if (criter != null && alter != null && perfTable != null && statusUserParam) {
            PerformanceTable test = mainFunction.run(perfTable, criter, alter);
            warningMessage = String.valueOf(warningMessage) + mainFunction.getWarningMessage();
            tempErrorMessage = String.valueOf(tempErrorMessage) + mainFunction.getErrorMessage();
            transformation transf = new transformation();
            if (test.nbAlternatives() != 0 && test.nbCriteria() != 0) {
                if (uniqueTransform) {
                    String transf_type = paramPerCriter.getGlobalTransform();
                    warningMessage = warningMessage.concat(transf.UniqueTransformWarning(test, transf_type));
                    test = transf.uniqueTransform(test, transf_type);
                } else {
                    warningMessage = String.valueOf(warningMessage) + transf.MultipleTransformWarning(test, paramPerCriter.getAllTransforms());
                    test = transf.MultipleTransform(test, warningMessage, paramPerCriter.getAllTransforms());
                }
            } else {
                tempErrorMessage = String.valueOf(tempErrorMessage) + "\n We cannot run the algorithm since the criteria list or the alternatives list of the PROJECT is empty.\n";
            }
            XmcdaMessage xmcdaMess = new XmcdaMessage();
            xmcdaMess.createLogMessage(errCriter, errAltern, errPerfTable, warningMessage, tempErrorMessage);
            xmcdaMess.enregistre(pathOutputMessage);
            if (test.nbAlternatives() != 0 && test.nbCriteria() != 0) {
                OutputPerfTableFile outputPerfTable = new OutputPerfTableFile();
                outputPerfTable.createOutputFile(test, "Transformed performance table");
                outputPerfTable.save(pathOutputFile);
            }
        } else {
            new XmcdaMessage().createErrorMessage(tempErrorMessage).enregistre(pathOutputMessage);
        }
    }
}

