/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class ParseAlternatives {
    private Alternatives alternativesToTest = new Alternatives();
    private String pathXMLFile;
    static Document document;
    private String warning = "";

    public Element getRacine(String path) {
        try {
            SAXBuilder sxb = new SAXBuilder();
            document = sxb.build(new File(path));
        }
        catch (Exception sxb) {
            // empty catch block
        }
        Element racine = document.getRootElement();
        return racine;
    }

    public void setPath(String path) {
        this.pathXMLFile = path;
    }

    public String getPath() {
        return this.pathXMLFile;
    }

    public Alternatives getAlternatives() {
        return this.alternativesToTest;
    }

    public void printAlternatives() {
        System.out.println("There are " + this.alternativesToTest.getListAlternatives().size() + " alternatives:");
        int i = 0;
        while (i < this.alternativesToTest.getListAlternatives().size()) {
            System.out.print(String.valueOf(this.alternativesToTest.getListAlternatives().get(i).getAlternativeId()) + "\t");
            ++i;
        }
        System.out.println("");
    }

    public Alternatives exploreAlternativesXML(Element racine) {
        if (racine.getChild("alternatives") != null) {
            Element alternatives = racine.getChild("alternatives");
            if (alternatives.getChildren("alternative") != null) {
                List listAlternatives = alternatives.getChildren("alternative");
                for (Element courant : listAlternatives) {
                    if (courant.getAttributeValue("id") != null && courant.getAttributeValue("name") != null) {
                        if (courant.getChild("active") != null && courant.getChild("active").getValue().equals("false")) {
                            this.warning = this.warning.concat("The alternative " + courant.getAttributeValue("id") + " was ignored " + "because it is not active: active=false.\n");
                            continue;
                        }
                        if (!this.alternativesToTest.getAlternativeIDs().contains(courant.getAttributeValue("id"))) {
                            this.alternativesToTest.addAlternative(new Alternative(courant.getAttributeValue("id"), courant.getAttributeValue("name")));
                            this.alternativesToTest.getListAlternativesIDs().add(courant.getAttributeValue("id"));
                            continue;
                        }
                        this.warning = this.warning.concat("\nWarning: duplicated alternative (" + courant.getAttributeValue("id") + "). Only the first occurence is considered.");
                        continue;
                    }
                    if (courant.getAttributeValue("id") == null || courant.getAttributeValue("name") != null) continue;
                    if (courant.getChild("active") != null && courant.getChild("active").getValue().equals("false")) {
                        this.warning = this.warning.concat("The alternative " + courant.getAttributeValue("id") + " was ignored " + "because it is not active: active=false.\n");
                        continue;
                    }
                    if (!this.alternativesToTest.getAlternativeIDs().contains(courant.getAttributeValue("id"))) {
                        this.alternativesToTest.addAlternative(new Alternative(courant.getAttributeValue("id")));
                        this.alternativesToTest.getListAlternativesIDs().add(courant.getAttributeValue("id"));
                        continue;
                    }
                    this.warning = this.warning.concat("\nWarning: duplicated alternative (" + courant.getAttributeValue("id") + "). Only the first occurence is considered.");
                }
                if (this.alternativesToTest.getAlternativeIDs().size() == 0) {
                    return null;
                }
                return this.alternativesToTest;
            }
            return null;
        }
        return null;
    }

    public String getWarning() {
        return this.warning;
    }
}

