/*
 * Decompiled with CFR 0.152.
 */
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import eu.telecom_bretagne.utils.GraphViz;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class classification {
    private Element racine = new Element("XMCDA");
    private Document document = new Document(this.racine);
    public static final String XMCDA_2_0_0_NAMESPACE = "http://www.decision-deck.org/2009/XMCDA-2.0.0";
    public static final String XMCDA_2_0_0_SCHEMA = "http://www.decision-deck.org/xmcda/_downloads/XMCDA-2.0.0.xsd";
    public static final String XMCDA_2_1_0_NAMESPACE = "http://www.decision-deck.org/2009/XMCDA-2.1.0";
    public static final String XMCDA_2_1_0_SCHEMA = "http://www.decision-deck.org/xmcda/_downloads/XMCDA-2.1.0.xsd";
    public static final String XMCDA_2_2_0_NAMESPACE = "http://www.decision-deck.org/2009/XMCDA-2.2.0";
    public static final String XMCDA_2_2_0_SCHEMA = "http://www.decision-deck.org/xmcda/_downloads/XMCDA-2.2.0.xsd";
    public static final String ACCEPTED_SCHEMA_LOCATIONS = "http://www.decision-deck.org/2009/XMCDA-2.0.0 http://www.decision-deck.org/xmcda/_downloads/XMCDA-2.0.0.xsd http://www.decision-deck.org/2009/XMCDA-2.1.0 http://www.decision-deck.org/xmcda/_downloads/XMCDA-2.1.0.xsd http://www.decision-deck.org/2009/XMCDA-2.2.0 http://www.decision-deck.org/xmcda/_downloads/XMCDA-2.2.0.xsd";

    public void PrepareParsing(String path) {
        try {
            SAXBuilder sxb = new SAXBuilder();
            this.document = sxb.build(new File(path));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.racine = this.document.getRootElement();
    }

    protected static String checkEntryFile(String path) {
        String error = "";
        try {
            classification.parseXML(path);
        }
        catch (JDOMException e) {
            error = error.concat("File is not well-formed: " + e.getMessage());
        }
        catch (IOException e) {
            error = error.concat("Could not check file because: " + e.getMessage());
        }
        return error;
    }

    protected static void parseXML(String xml) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser", true);
        builder.setFeature("http://apache.org/xml/features/validation/schema", true);
        builder.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (Object)ACCEPTED_SCHEMA_LOCATIONS);
        Document doc = builder.build(xml);
    }

    protected static Color getColorFromOptions(boolean black_and_white, String colorToUse) {
        Color color = Color.black;
        if (black_and_white) {
            return color;
        }
        Color c = null;
        try {
            c = (Color)Color.class.getField(colorToUse.toLowerCase()).get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (c == null) {
            return color;
        }
        color = c;
        return color;
    }

    protected static ArrayList<String> searchClasses(ArrayList<String> affectations) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < affectations.size()) {
            if (!result.contains(affectations.get(i))) {
                result.add(affectations.get(i));
            }
            ++i;
        }
        return result;
    }

    protected static Polygon positions(Point p, Dimension size, int nbr) {
        int[] abscissa = new int[nbr];
        int[] ordonates = new int[nbr];
        double delta = Math.PI * 2 / (double)nbr;
        double angle = 0.0;
        int i = 0;
        while (i < nbr) {
            angle = delta * (double)i + 1.5707963267948966;
            abscissa[i] = (int)((double)size.width * Math.cos(angle) + 0.5) + p.x;
            ordonates[i] = p.y - (int)((double)size.height * Math.sin(angle) + 0.5);
            ++i;
        }
        return new Polygon(abscissa, ordonates, nbr);
    }

    protected static String convertImage(File image_png, String format) {
        String encodedImage = "";
        try {
            BufferedImage image = ImageIO.read(image_png);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, format, baos);
            encodedImage = Base64.encode(baos.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!image_png.delete()) {
            System.err.println("Warning: " + image_png.getAbsolutePath() + " could not be deleted!");
        }
        return encodedImage;
    }

    protected static String classifyAlternativesUsingGraphViz(ArrayList<String> alter, ArrayList<String> affectations, String colorToUse, String currentClass, String shape, String dotFilename) {
        GraphViz gv = new GraphViz();
        gv.addln(gv.start_graph(colorToUse, shape));
        char guillemet = '\"';
        String titlePosition = "l";
        titlePosition = "t";
        gv.addln("labelloc=" + guillemet + titlePosition + guillemet + ";");
        String title = currentClass;
        gv.addln("label=" + guillemet + title + guillemet + "; fontcolor=" + colorToUse + ";");
        String label = "";
        int i = 0;
        while (i < affectations.size()) {
            if (affectations.get(i).equals(currentClass)) {
                label = label.equals("") ? alter.get(i) : String.valueOf(label) + ", " + alter.get(i);
            }
            ++i;
        }
        String nameLabel = "label" + currentClass;
        gv.addln(String.valueOf(nameLabel) + " [label = " + guillemet + label + guillemet + ", shape=" + shape + ", fontcolor=" + colorToUse + "];");
        gv.addln(gv.end_graph());
        String type2 = "png";
        File png_image = null;
        try {
            png_image = File.createTempFile("MyImage_", "." + type2, new File(System.getProperty("java.io.tmpdir")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        gv.createDotFile(new File(dotFilename));
        gv.writeGraphToFile(gv.getGraph(gv.getDotSource(), type2), png_image);
        String encodedImage = classification.convertImage(png_image, type2);
        return encodedImage;
    }

    protected static String classifyAlternatives(ArrayList<String> alter, ArrayList<String> affectations, Color colorToUse, String currentClass, String shape) {
        String encodedImage = "";
        int translation = 10;
        int width = 400;
        int height = 300;
        BufferedImage bi = new BufferedImage(width, height, 2);
        Graphics2D g = bi.createGraphics();
        g.setColor(colorToUse);
        Font fontText = new Font("Arial", 1, 16);
        g.setFont(fontText);
        g.setStroke(new BasicStroke(3.0f));
        if (shape.equals("rectangle")) {
            g.drawRect(70, height / 6, 300, 200);
        } else if (shape.equals("oval")) {
            g.drawOval(70, height / 6, 300, 200);
        } else if (shape.equals("diamond")) {
            int[] abscissa = new int[]{220 + translation, 50 + translation, 220 + translation, 370 + translation};
            int[] ordonates = new int[]{50, 150, 250, 150};
            Polygon pShape = new Polygon(abscissa, ordonates, 4);
            g.drawPolygon(pShape);
        }
        int nbrOfAlternatives = 0;
        int i = 0;
        while (i < affectations.size()) {
            if (affectations.get(i).equals(currentClass)) {
                ++nbrOfAlternatives;
            }
            ++i;
        }
        int taille = nbrOfAlternatives * 10;
        Polygon p = classification.positions(new Point(width / 2, height / 2), new Dimension(taille, taille), nbrOfAlternatives);
        int delta = 5;
        g.setColor(colorToUse);
        int i2 = 0;
        while (i2 < nbrOfAlternatives) {
            g.drawLine(p.xpoints[i2] - delta, p.ypoints[i2] - delta + translation, p.xpoints[i2] + delta, p.ypoints[i2] + delta + translation);
            g.drawLine(p.xpoints[i2] - delta, p.ypoints[i2] + delta + translation, p.xpoints[i2] + delta, p.ypoints[i2] - delta + translation);
            ++i2;
        }
        int j = 0;
        int i3 = 0;
        while (i3 < alter.size()) {
            if (affectations.get(i3).equals(currentClass)) {
                g.drawString(alter.get(i3), p.xpoints[j], p.ypoints[j] - 2 * delta + translation);
                ++j;
            }
            ++i3;
        }
        if (j != nbrOfAlternatives) {
            System.out.println("erreur pour les classes!!!");
        }
        g.drawString(currentClass, 0, height / 2 - 3 * translation);
        g.dispose();
        try {
            File file = File.createTempFile("classifyAltern_", ".png", new File(System.getProperty("java.io.tmpdir")));
            ImageIO.write((RenderedImage)bi, "PNG", file);
            FileInputStream input = new FileInputStream(file);
            BufferedImage image = ImageIO.read(input);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", baos);
            encodedImage = Base64.encode(baos.toByteArray());
            baos.close();
            input.close();
            if (!file.delete()) {
                System.err.println("Warning: " + file.getAbsolutePath() + " could not be deleted!");
            }
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
        return encodedImage;
    }

    protected static String classifyUniquePlot(ArrayList<String> alter, ArrayList<String> affectations, ArrayList<String> classes, int[] ranks, Color colorToUse, String plotsOrganisation, String order, String shape) {
        int translation = 10;
        int width = 400;
        int height = 300;
        ByteArrayOutputStream[] chart_png_image = new ByteArrayOutputStream[classes.size()];
        int indexClass = 0;
        while (indexClass < classes.size()) {
            BufferedImage bi = new BufferedImage(width, height, 2);
            Graphics2D g = bi.createGraphics();
            g.setColor(colorToUse);
            Font fontText = new Font("Arial", 1, 16);
            g.setFont(fontText);
            g.setStroke(new BasicStroke(3.0f));
            if (shape.equals("rectangle")) {
                g.drawRect(70, height / 6, 300, 200);
            } else if (shape.equals("oval")) {
                g.drawOval(70, height / 6, 300, 200);
            } else if (shape.equals("diamond")) {
                int[] abscissa = new int[]{220 + translation, 50 + translation, 220 + translation, 370 + translation};
                int[] ordonates = new int[]{50, 150, 250, 150};
                Polygon pShape = new Polygon(abscissa, ordonates, 4);
                g.drawPolygon(pShape);
            }
            int nbrOfAlternatives = 0;
            int i = 0;
            while (i < affectations.size()) {
                if (affectations.get(i).equals(classes.get(indexClass))) {
                    ++nbrOfAlternatives;
                }
                ++i;
            }
            int taille = nbrOfAlternatives * 10;
            Polygon p = classification.positions(new Point(width / 2, height / 2), new Dimension(taille, taille), nbrOfAlternatives);
            int delta = 5;
            g.setColor(colorToUse);
            int i2 = 0;
            while (i2 < nbrOfAlternatives) {
                g.drawLine(p.xpoints[i2] - delta, p.ypoints[i2] - delta + translation, p.xpoints[i2] + delta, p.ypoints[i2] + delta + translation);
                g.drawLine(p.xpoints[i2] - delta, p.ypoints[i2] + delta + translation, p.xpoints[i2] + delta, p.ypoints[i2] - delta + translation);
                ++i2;
            }
            int j = 0;
            int i3 = 0;
            while (i3 < alter.size()) {
                if (affectations.get(i3).equals(classes.get(indexClass))) {
                    g.drawString(alter.get(i3), p.xpoints[j], p.ypoints[j] - 2 * delta + translation);
                    ++j;
                }
                ++i3;
            }
            if (j != nbrOfAlternatives) {
                System.out.println("erreur pour les classes!!!");
            }
            g.drawString(classes.get(indexClass), 0, height / 2 - 3 * translation);
            g.dispose();
            try {
                File file = File.createTempFile("classifyAltern_", ".png", new File(System.getProperty("java.io.tmpdir")));
                ImageIO.write((RenderedImage)bi, "PNG", file);
                FileInputStream input = new FileInputStream(file);
                BufferedImage image = ImageIO.read(input);
                chart_png_image[indexClass] = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)image, "png", chart_png_image[indexClass]);
                chart_png_image[indexClass].close();
                input.close();
                if (!file.delete()) {
                    System.err.println("Warning: " + file.getAbsolutePath() + " could not be deleted!");
                }
            }
            catch (IOException ie) {
                ie.printStackTrace();
            }
            ++indexClass;
        }
        classification.orderClassesUniquePlot(classes, ranks, order, chart_png_image);
        InputStream[] inputStream = new InputStream[classes.size()];
        int i = 0;
        while (i < classes.size()) {
            inputStream[i] = new ByteArrayInputStream(chart_png_image[i].toByteArray());
            ++i;
        }
        String encodedImage = "";
        if (plotsOrganisation.equals("Line")) {
            encodedImage = classification.convertImageByLine(inputStream, "png", classes.size());
        } else if (plotsOrganisation.equals("Column")) {
            encodedImage = classification.convertImageByColumn(inputStream, "png", classes.size());
        } else if (plotsOrganisation.equals("Grid")) {
            encodedImage = classification.convertImageByGrid(inputStream, "png", classes.size());
        }
        return encodedImage;
    }

    protected static String classifyUniquePlotUsingGraphViz(ArrayList<String> alter, ArrayList<String> affectations, ArrayList<String> classes, int[] ranks, String colorToUse, String plotsOrganisation, String order, String shape, String dotFilename) {
        ByteArrayOutputStream[] png_image = new ByteArrayOutputStream[classes.size()];
        int indexClass = 0;
        while (indexClass < classes.size()) {
            GraphViz gv = new GraphViz();
            gv.addln(gv.start_graph(colorToUse, shape));
            char guillemet = '\"';
            String titlePosition = "t";
            gv.addln("labelloc=" + guillemet + titlePosition + guillemet + ";");
            String title = classes.get(indexClass);
            gv.addln("label=" + guillemet + title + guillemet + "; fontcolor=" + colorToUse + ";");
            String label = "";
            int i = 0;
            while (i < affectations.size()) {
                if (affectations.get(i).equals(classes.get(indexClass))) {
                    label = label.equals("") ? alter.get(i) : String.valueOf(label) + ", " + alter.get(i);
                }
                ++i;
            }
            String nameLabel = "label" + classes.get(indexClass);
            gv.addln(String.valueOf(nameLabel) + " [label = " + guillemet + label + guillemet + ", shape=" + shape + ", fontcolor=" + colorToUse + "];");
            gv.addln(gv.end_graph());
            String type2 = "png";
            png_image[indexClass] = new ByteArrayOutputStream();
            try {
                gv.createDotFile(new File(dotFilename));
                png_image[indexClass].write(gv.getGraph(gv.getDotSource(), type2));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++indexClass;
        }
        classification.orderClassesUniquePlot(classes, ranks, order, png_image);
        InputStream[] inputStream = new InputStream[classes.size()];
        int i = 0;
        while (i < classes.size()) {
            inputStream[i] = new ByteArrayInputStream(png_image[i].toByteArray());
            ++i;
        }
        String encodedImage = "";
        if (plotsOrganisation.equals("Line")) {
            encodedImage = classification.convertImageByLine(inputStream, "png", classes.size());
        } else if (plotsOrganisation.equals("Column")) {
            encodedImage = classification.convertImageByColumn(inputStream, "png", classes.size());
        } else if (plotsOrganisation.equals("Grid")) {
            encodedImage = classification.convertImageByGrid(inputStream, "png", classes.size());
        }
        return encodedImage;
    }

    protected static void exchange(ByteArrayOutputStream[] chart_png_image, int i, int j) {
        ByteArrayOutputStream temp = chart_png_image[j];
        chart_png_image[j] = chart_png_image[i];
        chart_png_image[i] = temp;
    }

    protected static void exchangeFiles(File[] chart_png_image, int i, int j) {
        File temp = chart_png_image[j];
        chart_png_image[j] = chart_png_image[i];
        chart_png_image[i] = temp;
    }

    protected static String convertImageByLine(InputStream[] inputStream, String format, int size) {
        String encodedImage = "";
        BufferedImage[] images = new BufferedImage[size];
        int i = 0;
        while (i < size) {
            try {
                images[i] = ImageIO.read(inputStream[i]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        int w = images[0].getWidth();
        int i2 = 1;
        while (i2 < size) {
            w += images[i2].getWidth();
            ++i2;
        }
        int h = images[0].getHeight();
        int i3 = 1;
        while (i3 < size) {
            if (images[i3].getHeight() > h) {
                h = images[i3].getHeight();
            }
            ++i3;
        }
        BufferedImage combined = new BufferedImage(w, h, 2);
        Graphics g = combined.getGraphics();
        int x = 0;
        int y = 0;
        int i4 = 0;
        while (i4 < size) {
            g.drawImage(images[i4], x, y, null);
            x += images[i4].getWidth();
            ++i4;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)combined, format, baos);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        encodedImage = Base64.encode(baos.toByteArray());
        return encodedImage;
    }

    protected static String convertImageByColumn(InputStream[] inputStream, String format, int size) {
        String encodedImage = "";
        BufferedImage[] images = new BufferedImage[size];
        int i = 0;
        while (i < size) {
            try {
                images[i] = ImageIO.read(inputStream[i]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        int w = images[0].getWidth();
        int i2 = 1;
        while (i2 < size) {
            if (images[i2].getWidth() > w) {
                w = images[i2].getWidth();
            }
            ++i2;
        }
        int h = images[0].getHeight();
        int i3 = 1;
        while (i3 < size) {
            h += images[i3].getHeight();
            ++i3;
        }
        BufferedImage combined = new BufferedImage(w, h, 2);
        Graphics g = combined.getGraphics();
        int x = 0;
        int y = 0;
        int i4 = 0;
        while (i4 < size) {
            g.drawImage(images[i4], x, y, null);
            y += images[i4].getHeight();
            ++i4;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)combined, format, baos);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        encodedImage = Base64.encode(baos.toByteArray());
        return encodedImage;
    }

    protected static String convertImageByGrid(InputStream[] inputStream, String format, int size) {
        String encodedImage = "";
        BufferedImage[] images = new BufferedImage[size];
        int i = 0;
        while (i < size) {
            try {
                images[i] = ImageIO.read(inputStream[i]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        int maxNumberOfImagesByLine = (int)Math.ceil(Math.sqrt(size));
        int w = images[0].getWidth();
        int i2 = 1;
        while (i2 < size) {
            if (images[i2].getWidth() > w) {
                w = images[i2].getWidth();
            }
            ++i2;
        }
        int maxWidth = w;
        w *= maxNumberOfImagesByLine;
        int h = images[0].getHeight();
        int i3 = 1;
        while (i3 < size) {
            if (images[i3].getHeight() > h) {
                h = images[i3].getHeight();
            }
            ++i3;
        }
        int maxHeight = h;
        BufferedImage combined = new BufferedImage(w, h *= maxNumberOfImagesByLine, 2);
        Graphics g = combined.getGraphics();
        int x = 0;
        int y = 0;
        int i4 = 0;
        while (i4 < size) {
            g.drawImage(images[i4], x, y, null);
            if ((x += maxWidth) >= w) {
                x = 0;
                y += maxHeight;
            }
            ++i4;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)combined, format, baos);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            ImageIO.write((RenderedImage)combined, format, baos);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        encodedImage = Base64.encode(baos.toByteArray());
        return encodedImage;
    }

    protected static void orderClasses(ArrayList<String> classes, int[] ranks, String order, String[] encodedImage) {
        block10: {
            block11: {
                block9: {
                    if (!order.equals("increasing")) break block9;
                    int i = 0;
                    while (i < classes.size() - 1) {
                        int j = i + 1;
                        while (j < classes.size()) {
                            if (classes.get(j).toLowerCase().compareTo(classes.get(i).toLowerCase()) < 0) {
                                classification.exchangeImages(encodedImage, i, j);
                            }
                            ++j;
                        }
                        ++i;
                    }
                    break block10;
                }
                if (!order.equals("decreasing")) break block11;
                int i = 0;
                while (i < classes.size() - 1) {
                    int j = i + 1;
                    while (j < classes.size()) {
                        if (classes.get(j).toLowerCase().compareTo(classes.get(i).toLowerCase()) > 0) {
                            classification.exchangeImages(encodedImage, i, j);
                        }
                        ++j;
                    }
                    ++i;
                }
                break block10;
            }
            if (!order.equals("categories")) break block10;
            int i = 0;
            while (i < classes.size() - 1) {
                int j = i + 1;
                while (j < classes.size()) {
                    if (ranks[j] < ranks[i]) {
                        classification.exchangeImages(encodedImage, i, j);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    protected static void orderClassesUniquePlot(ArrayList<String> classes, int[] ranks, String order, ByteArrayOutputStream[] encodedImage) {
        block10: {
            block11: {
                block9: {
                    if (!order.equals("increasing")) break block9;
                    int i = 0;
                    while (i < classes.size() - 1) {
                        int j = i + 1;
                        while (j < classes.size()) {
                            if (classes.get(j).toLowerCase().compareTo(classes.get(i).toLowerCase()) < 0) {
                                classification.exchangeBOS(encodedImage, i, j);
                            }
                            ++j;
                        }
                        ++i;
                    }
                    break block10;
                }
                if (!order.equals("decreasing")) break block11;
                int i = 0;
                while (i < classes.size() - 1) {
                    int j = i + 1;
                    while (j < classes.size()) {
                        if (classes.get(j).toLowerCase().compareTo(classes.get(i).toLowerCase()) > 0) {
                            classification.exchangeBOS(encodedImage, i, j);
                        }
                        ++j;
                    }
                    ++i;
                }
                break block10;
            }
            if (!order.equals("categories")) break block10;
            int i = 0;
            while (i < classes.size() - 1) {
                int j = i + 1;
                while (j < classes.size()) {
                    if (ranks[j] < ranks[i]) {
                        classification.exchangeBOS(encodedImage, i, j);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    protected static void orderClassesUniquePlotUsingGraphViz(ArrayList<String> classes, int[] ranks, String order, File[] encodedImage) {
        block10: {
            block11: {
                block9: {
                    if (!order.equals("increasing")) break block9;
                    int i = 0;
                    while (i < classes.size() - 1) {
                        int j = i + 1;
                        while (j < classes.size()) {
                            if (classes.get(j).toLowerCase().compareTo(classes.get(i).toLowerCase()) < 0) {
                                classification.exchangeFiles(encodedImage, i, j);
                            }
                            ++j;
                        }
                        ++i;
                    }
                    break block10;
                }
                if (!order.equals("decreasing")) break block11;
                int i = 0;
                while (i < classes.size() - 1) {
                    int j = i + 1;
                    while (j < classes.size()) {
                        if (classes.get(j).toLowerCase().compareTo(classes.get(i).toLowerCase()) > 0) {
                            classification.exchangeFiles(encodedImage, i, j);
                        }
                        ++j;
                    }
                    ++i;
                }
                break block10;
            }
            if (!order.equals("categories")) break block10;
            int i = 0;
            while (i < classes.size() - 1) {
                int j = i + 1;
                while (j < classes.size()) {
                    if (ranks[j] < ranks[i]) {
                        classification.exchangeFiles(encodedImage, i, j);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    protected static void exchangeImages(String[] chart_png_image, int i, int j) {
        String temp = chart_png_image[j];
        chart_png_image[j] = chart_png_image[i];
        chart_png_image[i] = temp;
    }

    protected static void exchangeBOS(ByteArrayOutputStream[] chart_png_image, int i, int j) {
        ByteArrayOutputStream temp = chart_png_image[j];
        chart_png_image[j] = chart_png_image[i];
        chart_png_image[i] = temp;
    }

    public static void main(String[] argv) {
        classification classf = new classification();
        String errorMessage = "";
        String warningMessage = "";
        if (argv.length != 6 && argv.length != 7) {
            System.err.println("Usage: alternatives.xml alternativesAssignments.xml [categories.xml] parameters.xml alternativesAssignments.dot alternativesAssignments.png messages.xml");
            System.err.println("       The 4 first files are inputs, the remaining ones are outputs.");
            System.err.println("       'categories.xml' may be omitted.  If supplied but the file does not exist, the program behaves as if it was not supplied.");
            System.exit(-1);
        }
        String pathAlternatives = argv[0];
        String pathAlternAffect = argv[1];
        String pathCategories = argv.length == 7 && new File(argv[2]).exists() ? argv[2] : null;
        String pathParameters = argv[argv.length - 4];
        String pathOutputFileDot = argv[argv.length - 3];
        String pathOutputFilePlot = argv[argv.length - 2];
        String pathOutputMessage = argv[argv.length - 1];
        boolean stopRunning = false;
        boolean useCategories = true;
        if (argv.length == 7) {
            if (!(new File(pathAlternatives).exists() && new File(pathAlternAffect).exists() && new File(pathParameters).exists())) {
                stopRunning = true;
                errorMessage = "Error: unable to run the algorithm. Reason: missing one (or more) entry file(s). Please check your entry files.";
            }
            if (pathCategories == null) {
                useCategories = false;
            }
        } else {
            stopRunning = true;
        }
        if (!stopRunning) {
            String errAlternAffect;
            String errAltern;
            String errMethodParameters = classification.checkEntryFile(pathParameters);
            if (errMethodParameters != "") {
                errorMessage = errorMessage.equals("") ? errMethodParameters : errorMessage.concat("\n" + errMethodParameters);
            }
            if ((errAltern = classification.checkEntryFile(pathAlternatives)) != "") {
                errorMessage = errorMessage.equals("") ? errAltern : errorMessage.concat("\n" + errAltern);
            }
            if ((errAlternAffect = classification.checkEntryFile(pathAlternAffect)) != "") {
                errorMessage = errorMessage.equals("") ? errAlternAffect : errorMessage.concat("\n" + errAlternAffect);
            }
            String errCategories = "";
            if (useCategories && (errCategories = classification.checkEntryFile(pathCategories)) != "") {
                errorMessage = errorMessage.equals("") ? errCategories : errorMessage.concat("\n" + errCategories);
            }
            if (errMethodParameters != "" || errAltern != "" || errAlternAffect != "" || errCategories != "") {
                StatusMessage xmcdaMess = new StatusMessage();
                xmcdaMess.createErrorMessage(errorMessage);
                xmcdaMess.save(pathOutputMessage);
            } else {
                ParseMethodParameters parseMethodParam = new ParseMethodParameters();
                classf.PrepareParsing(pathParameters);
                boolean statusParseMethod = parseMethodParam.parse(classf.getRacine());
                if (!statusParseMethod) {
                    errorMessage = errorMessage.equals("") ? "\nFatal error: the file containing the parameters is erroneous or empty." : errorMessage.concat("\nFatal Error: the file containing the parameters is erroneous or empty.");
                }
                if (parseMethodParam.getWarning() != "") {
                    warningMessage = warningMessage.concat("\n" + parseMethodParam.getWarning());
                }
                classf.PrepareParsing(pathAlternatives);
                Alternatives alternativesToUse = new Alternatives();
                ParseAlternatives jdomAlter = new ParseAlternatives();
                boolean parseAlternativesNull = false;
                alternativesToUse = jdomAlter.exploreAlternativesXML(classf.getRacine());
                if (alternativesToUse == null) {
                    parseAlternativesNull = true;
                    errorMessage = errorMessage.equals("") ? "\nFatal Error: the file containing the alternatives tag is erroneous or empty." : errorMessage.concat("\nFatal Error: the file containing the alternatives tag is erroneous or empty.");
                }
                if (jdomAlter.getWarning() != "") {
                    warningMessage = warningMessage.concat("\n" + jdomAlter.getWarning());
                }
                classf.PrepareParsing(pathAlternAffect);
                parseAffectations alternAffect = new parseAffectations();
                boolean parseAlterAffect = alternAffect.parseAlternativesAffectations(classf.getRacine());
                ArrayList<String> listAlternIds = alternAffect.getAlternIDs();
                ArrayList<String> listAffectations = alternAffect.getAffectations();
                if (!parseAlterAffect) {
                    errorMessage = errorMessage.equals("") ? "\nFatal error: the file containing the alternativesAffectations tag is erroneous or empty." : errorMessage.concat("\nFatal Error: the file containing the alternativesAffectations tag is erroneous or empty.");
                }
                if (alternAffect.getWarningMessage() != "") {
                    warningMessage = warningMessage.concat("\n" + alternAffect.getWarningMessage());
                }
                if (parseAlterAffect && !parseAlternativesNull && statusParseMethod) {
                    String plotTitle;
                    CheckEntryFiles check = new CheckEntryFiles();
                    boolean verif = check.checkIDs(alternativesToUse, listAlternIds);
                    if (!verif) {
                        warningMessage = warningMessage.concat(check.getWarning());
                    }
                    Alternatives intersectAlternatives = check.getIntersectionIDs(alternativesToUse, listAlternIds);
                    ArrayList<String> listIntersectAffectations = check.getIntersectionAffectations(intersectAlternatives.getAlternativeIDs(), listAlternIds, listAffectations);
                    if (intersectAlternatives.getAlternativeIDs().isEmpty()) {
                        warningMessage = warningMessage.concat("\nOnly the alternatives IDs in the file containing the alternativesAffectations tag were considered. Please check your input file containing the alternatives tag.");
                        intersectAlternatives = new Alternatives();
                        listIntersectAffectations = new ArrayList();
                        int i = 0;
                        while (i < listAlternIds.size()) {
                            intersectAlternatives.addAlternative(new Alternative(listAlternIds.get(i)));
                            intersectAlternatives.getAlternativeIDs().add(listAlternIds.get(i));
                            listIntersectAffectations.add(listAffectations.get(i));
                            ++i;
                        }
                    }
                    boolean uniquePlot = parseMethodParam.getUniquePlot();
                    String plotsOrganisation = parseMethodParam.getPlotsOrganisation();
                    String colorFromOptions = parseMethodParam.getColorToUse();
                    String order = parseMethodParam.getOrder();
                    String shape = parseMethodParam.getShape();
                    if (useCategories && !order.equals("categories")) {
                        warningMessage = warningMessage.concat("\nError in the file containing the parameters: the parameter 'order' must be equal to 'categories' in this case.");
                        order = "categories";
                    }
                    if (!useCategories && order.equals("categories")) {
                        warningMessage = warningMessage.concat("\nError in the file containing the parameters: the parameter 'order' cannot be equal to 'categories' when no categories are supplied.");
                        order = "increasing";
                    }
                    if ((plotTitle = parseMethodParam.getTitle()).isEmpty()) {
                        plotTitle = "Alternatives assignments plot";
                    }
                    if (intersectAlternatives.getAlternativeIDs().size() != 0) {
                        if (useCategories && pathCategories == null) {
                            errorMessage = errorMessage.concat("\n Inexistant entry file containing the categories tag. Check also your parameter 'Use categories' in the entry file containing method parameters tag.");
                        } else {
                            FilePlotClasses outputFile = new FilePlotClasses();
                            ArrayList<String> classes = classification.searchClasses(listIntersectAffectations);
                            boolean statusCateg = true;
                            int[] ranks = null;
                            if (useCategories) {
                                ParseCategories parseCateg = new ParseCategories();
                                classf.PrepareParsing(pathCategories);
                                statusCateg = parseCateg.parse(classf.getRacine(), classes);
                                ranks = parseCateg.getRanks();
                                if (parseCateg.getWarning() != "") {
                                    warningMessage = warningMessage.concat("\n" + parseCateg.getWarning());
                                }
                                if (!statusCateg) {
                                    errorMessage = errorMessage.equals("") ? "\nFatal error: the file containing the categories tag is erroneous or empty." : errorMessage.concat("\nFatal Error: the file containing the categories tag is erroneous or empty.");
                                }
                            }
                            if (statusCateg) {
                                String[] encodedImage = new String[classes.size()];
                                String image = null;
                                ArrayList<String> listAlternIdsOrdered = new ArrayList<String>();
                                int i = 0;
                                while (i < intersectAlternatives.getAlternativeIDs().size()) {
                                    int indexAltern = listAlternIds.indexOf(intersectAlternatives.getAlternativeIDs().get(i));
                                    listAlternIdsOrdered.add(listAlternIds.get(indexAltern));
                                    ++i;
                                }
                                if (!uniquePlot) {
                                    String dot_template = String.valueOf(pathOutputFileDot.substring(0, pathOutputFileDot.indexOf(46))) + "-%02d.dot";
                                    int i2 = 0;
                                    while (i2 < classes.size()) {
                                        encodedImage[i2] = classification.classifyAlternativesUsingGraphViz(listAlternIdsOrdered, listIntersectAffectations, colorFromOptions.toLowerCase(), classes.get(i2), shape, String.format(dot_template, i2));
                                        ++i2;
                                    }
                                    classification.orderClasses(classes, ranks, order, encodedImage);
                                    outputFile.createFileMultiplePlots(listAlternIdsOrdered, encodedImage, plotTitle);
                                } else {
                                    image = classification.classifyUniquePlotUsingGraphViz(listAlternIdsOrdered, listIntersectAffectations, classes, ranks, colorFromOptions.toLowerCase(), plotsOrganisation, order, shape, pathOutputFileDot);
                                    outputFile.createFile(listAlternIdsOrdered, image, plotTitle);
                                }
                                outputFile.saveFile(pathOutputFilePlot);
                            }
                        }
                    } else {
                        errorMessage = errorMessage.concat("\n We cannot run the algorithm since the alternatives list  of the PROJECT is empty.\n");
                    }
                    StatusMessage xmcdaMess = new StatusMessage();
                    xmcdaMess.createLogMessage(warningMessage, errorMessage);
                    xmcdaMess.save(pathOutputMessage);
                } else {
                    StatusMessage xmcdaMess = new StatusMessage();
                    xmcdaMess.createErrorMessage(errorMessage);
                    xmcdaMess.save(pathOutputMessage);
                }
            }
        } else {
            StatusMessage xmcdaMess = new StatusMessage();
            xmcdaMess.createErrorMessage(errorMessage);
            xmcdaMess.save(pathOutputMessage);
        }
    }

    public Element getRacine() {
        return this.racine;
    }
}

