/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;

public class StreamGobbler
extends Thread {
    private InputStream stream;
    private Writer sw;
    private long limit = 0L;
    private boolean started = false;

    public StreamGobbler(InputStream stream, Writer writer) {
        this.stream = stream;
        this.sw = writer;
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(long limit) {
        if (this.started) {
            throw new IllegalStateException("Thread has already been started, the limit cannot be changed anymore");
        }
        this.limit = limit;
    }

    @Override
    public void run() {
        this.started = true;
        if (this.sw == null) {
            this.run_nowriter();
        } else if (this.limit < 1L) {
            this.run_nolimit();
        } else {
            this.run_limit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run_nolimit() {
        try {
            int c;
            while ((c = this.stream.read()) != -1) {
                Writer writer = this.sw;
                synchronized (writer) {
                    this.sw.write(c);
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        try {
            this.sw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run_limit() {
        try {
            int c;
            for (long idx = 0L; idx < this.limit && (c = this.stream.read()) != -1; ++idx) {
                Writer writer = this.sw;
                synchronized (writer) {
                    this.sw.write(c);
                    continue;
                }
            }
            while ((c = this.stream.read()) != -1) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void run_nowriter() {
        try {
            while (this.stream.read() != -1) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStreamContent() {
        Writer writer = this.sw;
        synchronized (writer) {
            return this.sw != null ? this.sw.toString() : null;
        }
    }
}

