/*
 * Decompiled with CFR 0.152.
 */
package eu.telecom_bretagne.xmcda;

import org.jdom2.Element;

public class Alternative {
    private final String id;
    private String name;
    private boolean isActive = true;
    private boolean isReference = false;

    public Alternative(String id, boolean active) {
        this.id = id;
        this.isActive = active;
    }

    public Alternative(String id) {
        this.id = id;
        this.name = null;
    }

    public Alternative(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public boolean isReference() {
        return this.isReference;
    }

    public void setReference(boolean reference) {
        this.isReference = reference;
    }

    public static Alternative fromXML(Element xml) {
        String reference;
        String id = xml.getAttributeValue("id");
        if (id == null) {
            return null;
        }
        Alternative alternative = new Alternative(xml.getAttributeValue("id"));
        alternative.setName(xml.getAttributeValue("name"));
        String active = xml.getChildText("active");
        if ("false".equals(active) || "0".equals(active)) {
            alternative.setActive(false);
        }
        if ("true".equals(reference = xml.getAttributeValue("reference")) || "1".equals(reference)) {
            alternative.setReference(true);
        }
        return alternative;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Alternative)) {
            return false;
        }
        Alternative alt = (Alternative)obj;
        return this.id.equals(alt.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id;
    }
}

