/*
 * Decompiled with CFR 0.152.
 */
package eu.telecom_bretagne.xmcda;

import eu.telecom_bretagne.xmcda.Alternative;
import eu.telecom_bretagne.xmcda.Alternatives;
import eu.telecom_bretagne.xmcda.Criteria;
import eu.telecom_bretagne.xmcda.Criterion;
import eu.telecom_bretagne.xmcda.PerformanceTable;

public class GestionIncoherentFiles {
    private Criteria criter;
    private Alternatives altern;
    private PerformanceTable perfTable;
    private String warningMessageCriter;
    private String warningMessageAltern;

    public GestionIncoherentFiles() {
    }

    public GestionIncoherentFiles(Criteria criter, Alternatives altern, PerformanceTable perfTable) {
        this.criter = criter;
        this.altern = altern;
        this.perfTable = perfTable;
        this.warningMessageCriter = "";
        this.warningMessageAltern = "";
    }

    public boolean checkAlternatives(Alternatives altern, PerformanceTable perfTable) {
        boolean result = true;
        int diff = 0;
        int inactive = 0;
        if (altern.getNumberOfActiveAlternatives() != perfTable.nbRows()) {
            this.warningMessageAltern = this.warningMessageAltern.concat("\nPlease check the file containing the alternatives tag:incoherence with the number of alternatives given in the file containing the performanceTable tag.");
            return false;
        }
        for (Alternative a : altern) {
            if (!perfTable.rows().contains(a)) {
                result = false;
                ++diff;
                continue;
            }
            if (a.isActive()) continue;
            result = false;
            ++inactive;
            this.warningMessageAltern = this.warningMessageAltern.concat("meuh");
        }
        if (diff > 1) {
            this.warningMessageAltern = this.warningMessageAltern.concat("\nPlease check the file containing the alternatives tag:incoherence with the alternatives given in the file containing the performanceTable tag. There are " + diff + " different alternatives.");
        }
        if (diff == 1) {
            this.warningMessageAltern = this.warningMessageAltern.concat("\nPlease check the file containing the alternatives tag:incoherence with the alternatives given in the file containing the performanceTable tag. There is one different alternative.");
        }
        return result;
    }

    public boolean checkCriteria(Criteria criter, PerformanceTable perfTable) {
        boolean result = true;
        int diff = 0;
        if (criter.size() != perfTable.nbColumns()) {
            this.warningMessageCriter = this.warningMessageCriter.concat("\nPlease check the file containing the criteria tag:incoherence with the number of criteria given in the file containing the performanceTable tag.");
            return false;
        }
        for (Criterion criterion : criter) {
            if (perfTable.hasColumn(criterion)) continue;
            result = false;
            ++diff;
        }
        if (diff > 1) {
            this.warningMessageCriter = this.warningMessageCriter.concat("\nPlease check the file containing the criteria tag:incoherence with the criteria given in the file containing the performanceTable tag. There are " + diff + " different criteria.");
        }
        if (diff == 1) {
            this.warningMessageCriter = this.warningMessageCriter.concat("\nPlease check the file containing the criteria tag:incoherence with the criteria given in the file containing the performanceTable tag. There is one different criterion.");
        }
        return result;
    }

    public String getWarningCriteria() {
        return this.warningMessageCriter;
    }

    public String getWarningAlternatives() {
        return this.warningMessageAltern;
    }
}

