/*
 * Decompiled with CFR 0.152.
 */
import eu.telecom_bretagne.xmcda.Alternative;
import eu.telecom_bretagne.xmcda.Alternatives;
import eu.telecom_bretagne.xmcda.AlternativesComparisons;
import eu.telecom_bretagne.xmcda.JDOM_Alternatives;
import eu.telecom_bretagne.xmcda.JDOM_Alternatives_Comparisons;
import eu.telecom_bretagne.xmcda.Main;
import eu.telecom_bretagne.xmcda.XmcdaMessage;
import java.io.File;

public class plotAlternativesComparisons {
    private String warningMessage = "";

    public GraphViz createGraphiz(AlternativesComparisons alternComp, String color, boolean valuedGraph, boolean transitiveReduction, String node_shape) {
        GraphViz gv = new GraphViz();
        gv.setTransitiveReduction(transitiveReduction);
        gv.addln(gv.start_graph(color, node_shape));
        for (Alternative alternative_i : alternComp.rows()) {
            for (Alternative alternative_j : alternComp.columns()) {
                if (!alternComp.isSet(alternative_i, alternative_j)) continue;
                if (!valuedGraph) {
                    gv.addln(alternative_i + " -> " + alternative_j + ";");
                    continue;
                }
                String label = Float.toString(((Float)alternComp.getValue(alternative_i, alternative_j)).floatValue());
                gv.addln(alternative_i + " -> " + alternative_j + " [label=" + label + ", fontcolor=" + color + "];");
            }
        }
        for (Alternative alternative : alternComp.rows()) {
            gv.addln(String.valueOf(alternative.id()) + "[fontcolor=" + color + "]");
        }
        gv.addln(gv.end_graph());
        return gv;
    }

    protected static String getColorFromOptions(boolean black_and_white, String colorToUse) {
        String color = "";
        color = black_and_white ? "black" : colorToUse.toLowerCase();
        return color;
    }

    public static void main(String[] argv) {
        String errAlternativesComparisons;
        String errAlternatives;
        if (argv.length != 5 && argv.length != 6) {
            System.err.println("Usage: alternatives.xml alternativesComparisons.xml parameters.xml [alternativesValuesPlot.dot] alternativesValuesPlot.png messages.xml");
            System.err.println("       The 3 first files are inputs, the remaining ones are outputs");
            System.exit(-1);
        }
        String pathAlternatives = argv[0];
        String pathAlternativesComparisons = argv[1];
        String pathMethodParameters = argv[2];
        File pathOutputDotFile = argv.length == 6 ? new File(argv[3]) : null;
        File pathOutputFile = new File(argv[argv.length - 2]);
        String pathOutputMessage = argv[argv.length - 1];
        String errorMessage = "";
        if (!(new File(pathMethodParameters).exists() && new File(pathAlternatives).exists() && new File(pathAlternativesComparisons).exists())) {
            errorMessage = "Error: unable to run the algorithm. Reason: one (or more) missing entry file. Please check your entry files.";
            XmcdaMessage xmcdaMess = new XmcdaMessage();
            xmcdaMess.createErrorMessage(errorMessage);
            xmcdaMess.enregistre(pathOutputMessage);
            return;
        }
        Main mainFunction = new Main();
        String errMethodParameters = mainFunction.checkEntryFile(pathMethodParameters);
        if (errMethodParameters != "") {
            errorMessage = errorMessage.concat("\nFatal Error: the file containing the methodParameters tag is not a valid XMCDA document.");
        }
        if ((errAlternatives = mainFunction.checkEntryFile(pathAlternatives)) != "") {
            errorMessage = errorMessage.concat("\nFatal Error: the file containing the alternatives tag is not a valid XMCDA document.");
        }
        if ((errAlternativesComparisons = mainFunction.checkEntryFile(pathAlternativesComparisons)) != "") {
            errorMessage = errorMessage.concat("\nFatal Error: the file containing the alternativesComparisons tag is not a valid XMCDA document.");
        }
        if (errMethodParameters != "" || errAlternatives != "" || errAlternativesComparisons != "") {
            XmcdaMessage xmcdaMess = new XmcdaMessage();
            xmcdaMess.createErrorMessage(errorMessage);
            xmcdaMess.enregistre(pathOutputMessage);
            return;
        }
        plotAlternativesComparisons plot = new plotAlternativesComparisons();
        if (mainFunction.getWarningMessage() != "") {
            plot.warningMessage = plot.warningMessage.concat(mainFunction.getWarningMessage());
        }
        mainFunction.PrepareParsing(pathAlternatives);
        Alternatives alternativesToUse = new Alternatives();
        JDOM_Alternatives jdomAlter = new JDOM_Alternatives();
        boolean parseAlternativesNull = false;
        alternativesToUse = jdomAlter.exploreAlternativesXML(mainFunction.getRacine());
        if (alternativesToUse == null) {
            parseAlternativesNull = true;
            errorMessage = errorMessage.equals("") ? "\nFatal Error: the file containing the alternatives tag is erroneous or empty." : errorMessage.concat("\nFatal Error: the file containing the alternatives tag is erroneous or empty.");
        }
        if (jdomAlter.getWarning() != "") {
            plot.warningMessage = plot.warningMessage.concat("\n" + jdomAlter.getWarning());
        }
        mainFunction.PrepareParsing(pathAlternativesComparisons);
        AlternativesComparisons alternCompaToUse = new AlternativesComparisons();
        JDOM_Alternatives_Comparisons jdomAlterComp = new JDOM_Alternatives_Comparisons();
        boolean parseAlternCompNull = false;
        alternCompaToUse = jdomAlterComp.exploreAlternativesComparisonsXML(mainFunction.getRacine(), alternativesToUse);
        if (alternCompaToUse == null) {
            parseAlternCompNull = true;
            errorMessage = errorMessage.equals("") ? "\nFatal Error: the file containing the alternativesComparisons tag is erroneous or empty." : errorMessage.concat("\nFatal Error: the file containing the alternativesComparisons tag is erroneous or empty.");
        }
        if (jdomAlterComp.getWarningMessage() != "") {
            plot.warningMessage = plot.warningMessage.concat("\n" + jdomAlterComp.getWarningMessage());
        }
        MethodParamAlternCompa parseMethodParam = new MethodParamAlternCompa();
        mainFunction.PrepareParsing(pathMethodParameters);
        boolean statusParseMethod = parseMethodParam.parse(mainFunction.getRacine());
        if (parseMethodParam.getWarning() != "") {
            plot.warningMessage = plot.warningMessage.concat(parseMethodParam.getWarning());
        }
        if (!statusParseMethod) {
            errorMessage = errorMessage.equals("") ? "\nFatal Error: the file containing the methodParameters tag is erroneous or empty." : errorMessage.concat("\nFatal Error: the file containing the methodParameters tag is erroneous or empty.");
        }
        if (parseAlternCompNull || parseAlternativesNull || !statusParseMethod) {
            XmcdaMessage xmcdaMess = new XmcdaMessage();
            xmcdaMess.createErrorMessage(errorMessage);
            xmcdaMess.enregistre(pathOutputMessage);
            return;
        }
        if (alternCompaToUse.nbRows() == 0) {
            XmcdaMessage xmcdaMess = new XmcdaMessage();
            errorMessage = errorMessage.concat("Failure to run the algorithm because it seems that the file containing the alternativesComparisons tag is empty or erroneous.");
            xmcdaMess.createLogMessagePlotAlternativesComparisons(errAlternatives, errAlternativesComparisons, plot.warningMessage, errorMessage);
            xmcdaMess.enregistre(pathOutputMessage);
            return;
        }
        boolean color = parseMethodParam.getColor();
        String colorToUse = parseMethodParam.getColorToUse();
        colorToUse = plotAlternativesComparisons.getColorFromOptions(!color, colorToUse);
        boolean valuedGraph = parseMethodParam.getValuedGraph();
        boolean transitiveReduction = parseMethodParam.getTransitiveReduction();
        if (valuedGraph) {
            transitiveReduction = false;
        }
        String node_shape = parseMethodParam.getShape();
        GraphViz gv = plot.createGraphiz(alternCompaToUse, colorToUse, valuedGraph, transitiveReduction, node_shape);
        XmcdaMessage xmcdaMess = new XmcdaMessage();
        xmcdaMess.createLogMessagePlotAlternativesComparisons(errAlternatives, errAlternativesComparisons, plot.warningMessage, errorMessage);
        xmcdaMess.enregistre(pathOutputMessage);
        String commentToPut = "Alternatives comparisons plot";
        OutputAlterComp.createFiles(alternCompaToUse.rows(), gv, commentToPut, pathOutputFile, pathOutputDotFile);
    }
}

