/*
 * Decompiled with CFR 0.152.
 */
package plotAlternValues;

import eu.telecom_bretagne.xmcda.Alternative;
import eu.telecom_bretagne.xmcda.AlternativeValue;
import eu.telecom_bretagne.xmcda.Alternatives;
import eu.telecom_bretagne.xmcda.AlternativesValues;
import eu.telecom_bretagne.xmcda.JDOM_Alternatives;
import eu.telecom_bretagne.xmcda.JDOM_AlternativesValues;
import eu.telecom_bretagne.xmcda.Main;
import eu.telecom_bretagne.xmcda.XmcdaMessage;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.TreeSet;
import plotAlternValues.BarChart;
import plotAlternValues.ImageToBase64;
import plotAlternValues.OutputPlotFile;
import plotAlternValues.ParseMethodParameters;
import plotAlternValues.PieChart;

public class Plot {
    private String warningMessage = "";

    public boolean checkFiles(Alternatives alter, AlternativesValues alternVal) {
        boolean result = true;
        int diff = 0;
        if (alter.getAlternativesIDs().size() != alternVal.size()) {
            this.warningMessage = String.valueOf(this.warningMessage) + "\nPlease check the file containing the alternatives tag:incoherence with the number of alternatives given in the file containing the alternativesValues tag.";
            return false;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (AlternativeValue av : alternVal) {
            list.add(av.getAlternativeValueId());
        }
        for (String s : alter.getAlternativesIDs()) {
            if (list.contains(s)) continue;
            result = false;
            ++diff;
        }
        if (diff > 1) {
            this.warningMessage = this.warningMessage.concat("\nPlease check the file containing the alternatives tag:incoherence with the alternatives given in the file containing the alternativesValues tag. There are " + diff + "different alternatives.");
        }
        if (diff == 1) {
            this.warningMessage = this.warningMessage.concat("\nPlease check the file containing the alternatives tag:incoherence with the alternatives given in the file containing the alternativesValues tag. There is one different alternative.");
        }
        return result;
    }

    public ArrayList<String> getIntersectionAlternativesIDs(Alternatives alter, AlternativesValues alternVal) {
        ArrayList<String> listintersection = new ArrayList<String>();
        for (String t : alternVal.getListAlternativesIDs()) {
            Alternative a = alter.getAlternative(t);
            if (a == null || !a.isActive()) continue;
            listintersection.add(t);
        }
        listintersection = new ArrayList(new TreeSet(listintersection));
        return listintersection;
    }

    public ArrayList<String> getIntersectionAlternativesNames(Alternatives alter, AlternativesValues alternVal, ArrayList<String> listintersectionIds) {
        ArrayList<String> listintersectionNames = new ArrayList<String>();
        int i = 0;
        while (i < listintersectionIds.size()) {
            if (alter.getAlternativesIDs().contains(listintersectionIds.get(i))) {
                int index = alter.getAlternativesIDs().indexOf(listintersectionIds.get(i));
                if (alter.getListAlternativesNames().get(index) != null) {
                    listintersectionNames.add(alter.getListAlternativesNames().get(index));
                } else {
                    listintersectionNames.add(null);
                }
            } else {
                listintersectionNames.add(null);
            }
            ++i;
        }
        return listintersectionNames;
    }

    public String plotAlternativesValuesBarChart(AlternativesValues alternativesValuesToPlot, Alternatives alter, ArrayList<String> listintersectionIds, ArrayList<String> listintersectionNames, int format, String tempErrorMessage, boolean color, Color color1, Color color2, String chartTitle, String XaxisLabel, String YaxisLabel, String order, String maxMin) {
        double[] ySeriesAlternValues = new double[listintersectionIds.size()];
        int i = 0;
        while (i < listintersectionIds.size()) {
            if (alternativesValuesToPlot.getListAlternativesIDs().contains(listintersectionIds.get(i))) {
                ySeriesAlternValues[i] = alternativesValuesToPlot.getListAlternativesValues().get(alternativesValuesToPlot.getListAlternativesIDs().indexOf(listintersectionIds.get(i))).getRealValue();
            }
            ++i;
        }
        ByteArrayOutputStream chart_png_image = new ByteArrayOutputStream();
        BarChart barChartAlterVal = new BarChart("Bar Chart", ySeriesAlternValues, color1, color2, chartTitle, XaxisLabel, YaxisLabel, alter, listintersectionIds, listintersectionNames, alternativesValuesToPlot, order, maxMin);
        barChartAlterVal.saveChart(chart_png_image);
        ImageToBase64 imageConvert = new ImageToBase64();
        String encodedImage = imageConvert.convertImage(new ByteArrayInputStream(chart_png_image.toByteArray()), "png");
        if (imageConvert.getImageErrorMessage() != "") {
            tempErrorMessage = tempErrorMessage.concat(imageConvert.getImageErrorMessage());
        }
        return encodedImage;
    }

    public String plotAlternativesValuesPieChart(AlternativesValues alterValuesToPlot, Alternatives alter, int format, String tempErrorMessage, boolean color, Color color1, Color color2, String chartTitle, ArrayList<String> listintersectionIds, ArrayList<String> listintersectionNames, String order, String maxMin) {
        double[] ySeriesAlterValues = new double[listintersectionIds.size()];
        int i = 0;
        while (i < listintersectionIds.size()) {
            if (alterValuesToPlot.getListAlternativesIDs().contains(listintersectionIds.get(i))) {
                ySeriesAlterValues[i] = alterValuesToPlot.getListAlternativesValues().get(alterValuesToPlot.getListAlternativesIDs().indexOf(listintersectionIds.get(i))).getRealValue();
            }
            ++i;
        }
        ByteArrayOutputStream chart_png_image = new ByteArrayOutputStream();
        PieChart pieChartAlternVal = new PieChart("PieChartDemo4", ySeriesAlterValues, alterValuesToPlot, alter, color1, color2, chartTitle, listintersectionIds, listintersectionNames, order, maxMin);
        pieChartAlternVal.saveChart(chart_png_image);
        ImageToBase64 imageConvert = new ImageToBase64();
        String encodedImage = imageConvert.convertImage(new ByteArrayInputStream(chart_png_image.toByteArray()), "png");
        if (imageConvert.getImageErrorMessage() != "") {
            tempErrorMessage = tempErrorMessage.concat(imageConvert.getImageErrorMessage());
        }
        return encodedImage;
    }

    protected static Color[] getColorsFromOptions(boolean black_and_white, String colors1ToUse, String colors2ToUse) {
        Color[] colors = new Color[]{Color.black, Color.black};
        if (black_and_white) {
            return colors;
        }
        Color c1 = null;
        Color c2 = null;
        try {
            c1 = (Color)Color.class.getField(colors1ToUse.toLowerCase()).get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (c1 == null) {
            return colors;
        }
        try {
            c2 = (Color)Color.class.getField(colors2ToUse.toLowerCase()).get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (c2 == null) {
            return colors;
        }
        colors[0] = c1;
        colors[1] = c2;
        return colors;
    }

    public static void main(String[] argv) {
        String errAlternativesValues;
        String errAlternatives;
        String tempErrorMessage = "";
        if (argv.length != 5) {
            System.err.println("Usage: methodPlotOptions.xml alternatives.xml alternativesValues.xml alternativesValuesPlot.xml messages.xml");
            System.err.println("       The 3 first files are inputs, the remaining ones are outputs");
            System.exit(-1);
        }
        String pathMethodParameters = argv[0];
        String pathAlternatives = argv[1];
        String pathAlternativesValues = argv[2];
        String pathOutputFilePlot = argv[3];
        String pathOutputMessage = argv[4];
        if (!(new File(argv[0]).exists() && new File(argv[1]).exists() && new File(argv[2]).exists())) {
            tempErrorMessage = "Error: unable to run the algorithm. Reason: missing one (or more) entry file(s). Please check your entry files.";
            new XmcdaMessage().createErrorMessage(tempErrorMessage).enregistre(pathOutputMessage);
            return;
        }
        Main mainFunction = new Main();
        String errMethodParameters = mainFunction.checkEntryFile(pathMethodParameters);
        if (errMethodParameters != "") {
            tempErrorMessage = String.valueOf(tempErrorMessage) + "\nFatal error: the file containing the methodParameters tag is not a valid XMCDA document.";
        }
        if ((errAlternatives = mainFunction.checkEntryFile(pathAlternatives)) != "") {
            tempErrorMessage = String.valueOf(tempErrorMessage) + "\nFatal error: the file containing the alternatives tag is not a valid XMCDA document.";
        }
        if ((errAlternativesValues = mainFunction.checkEntryFile(pathAlternativesValues)) != "") {
            tempErrorMessage = String.valueOf(tempErrorMessage) + "\nFatal error: the file containing the alternativesValues tag is not a valid XMCDA document.";
        }
        if (!("".equals(errMethodParameters) && "".equals(errAlternatives) && "".equals(errAlternativesValues))) {
            new XmcdaMessage().createErrorMessage(tempErrorMessage).enregistre(pathOutputMessage);
            return;
        }
        Plot plot = new Plot();
        if (mainFunction.getWarningMessage() != "") {
            plot.warningMessage = plot.warningMessage.concat(mainFunction.getWarningMessage());
        }
        mainFunction.PrepareParsing(pathAlternatives);
        Alternatives alternatives = new Alternatives();
        JDOM_Alternatives jdomAlter = new JDOM_Alternatives();
        alternatives = jdomAlter.exploreAlternativesXML(mainFunction.getRacine());
        if (alternatives == null) {
            tempErrorMessage = String.valueOf(tempErrorMessage) + "\nFatal error: the file containing the alternatives tag is erroneous or empty.";
        }
        if (jdomAlter.getWarning() != "") {
            plot.warningMessage = String.valueOf(plot.warningMessage) + "\n" + jdomAlter.getWarning();
        }
        mainFunction.PrepareParsing(pathAlternativesValues);
        AlternativesValues alternativesValues = new AlternativesValues();
        JDOM_AlternativesValues jdomAlternVal = new JDOM_AlternativesValues();
        alternativesValues = jdomAlternVal.parseAlternativesValuesXML(mainFunction.getRacine());
        if (jdomAlternVal.getWarningMessage() != "") {
            plot.warningMessage = String.valueOf(plot.warningMessage) + "\n" + jdomAlternVal.getWarningMessage();
        }
        if (alternativesValues == null || alternativesValues.size() == 0) {
            alternativesValues = null;
            tempErrorMessage = String.valueOf(tempErrorMessage) + "\nFatal error: the file containing the alternativesValues tag is erroneous or empty.";
        }
        ParseMethodParameters parseMethodParam = new ParseMethodParameters();
        mainFunction.PrepareParsing(pathMethodParameters);
        boolean optionsSuccessfullyParsed = parseMethodParam.parse(mainFunction.getRacine());
        if (!optionsSuccessfullyParsed) {
            tempErrorMessage = String.valueOf(tempErrorMessage) + "\nFatal error: the file containing the methodParameters tag is erroneous or empty.";
        }
        if (alternatives == null || alternativesValues == null || !optionsSuccessfullyParsed) {
            new XmcdaMessage().createErrorMessage(tempErrorMessage).enregistre(pathOutputMessage);
            return;
        }
        plot.checkFiles(alternatives, alternativesValues);
        ArrayList<String> listintersectionAlternatives = plot.getIntersectionAlternativesIDs(alternatives, alternativesValues);
        if (listintersectionAlternatives.isEmpty()) {
            plot.warningMessage = String.valueOf(plot.warningMessage) + "\nOnly the alternatives IDs in the file containing the alternativesValues tag were considered. Please check your input file containing the alternatives tag.";
            for (AlternativeValue av : alternativesValues) {
                listintersectionAlternatives.add(av.getAlternativeValueId());
            }
        }
        boolean color = parseMethodParam.getColor();
        String chartType = parseMethodParam.getChartType();
        if (parseMethodParam.getError() != "") {
            plot.warningMessage = plot.warningMessage.concat(parseMethodParam.getError());
        }
        String colors1ToUse = parseMethodParam.getInitialColor();
        String colors2ToUse = parseMethodParam.getFinalColor();
        Color[] colors = Plot.getColorsFromOptions(!color, colors1ToUse, colors2ToUse);
        String order = parseMethodParam.getOrder();
        String maxMin = parseMethodParam.getMaxMin();
        int format = 5;
        String encodedImage = "";
        String chartTitle = parseMethodParam.getChartTitle();
        String XaxisLabel = parseMethodParam.getDomainAxisLabel();
        String YaxisLabel = parseMethodParam.getRangeAxisLabel();
        if (listintersectionAlternatives.size() != 0) {
            if (chartType.equals("bc")) {
                encodedImage = plot.plotAlternativesValuesBarChart(alternativesValues, alternatives, listintersectionAlternatives, plot.getIntersectionAlternativesNames(alternatives, alternativesValues, listintersectionAlternatives), format, tempErrorMessage, color, colors[0], colors[1], chartTitle, XaxisLabel, YaxisLabel, order, maxMin);
            } else if (chartType.equals("pc")) {
                encodedImage = plot.plotAlternativesValuesPieChart(alternativesValues, alternatives, format, tempErrorMessage, color, colors[0], colors[1], chartTitle, listintersectionAlternatives, plot.getIntersectionAlternativesNames(alternatives, alternativesValues, listintersectionAlternatives), order, maxMin);
            } else {
                tempErrorMessage = String.valueOf(tempErrorMessage) + "\nError in chart type. Only Pie chart or Bar chart are available plots.";
            }
        } else {
            tempErrorMessage = String.valueOf(tempErrorMessage) + "\n We cannot run the algorithm since the alternatives list  of the PROJECT is empty.\n";
        }
        if (encodedImage.equals("")) {
            tempErrorMessage = String.valueOf(tempErrorMessage) + "\n Error: the chart is empty. Please check your parameters.";
        }
        XmcdaMessage xmcdaMess = new XmcdaMessage();
        xmcdaMess.createLogMessageForAlternativesValPlot(errAlternatives, errAlternativesValues, plot.warningMessage, tempErrorMessage);
        xmcdaMess.enregistre(pathOutputMessage);
        String commentToPut = "Alternatives values plot";
        if (listintersectionAlternatives.size() != 0 && encodedImage != "") {
            OutputPlotFile outputPlotFile = new OutputPlotFile();
            outputPlotFile.createOutputFile(listintersectionAlternatives, encodedImage, commentToPut);
            outputPlotFile.saveFile(pathOutputFilePlot);
        }
    }
}

