/*
 * Decompiled with CFR 0.152.
 */
import Xmcda_by_Dhouha.Criteria;
import Xmcda_by_Dhouha.CriteriaComparisons;
import Xmcda_by_Dhouha.JDOM_Criteria;
import Xmcda_by_Dhouha.JDOM_Criteria_Comparisons;
import Xmcda_by_Dhouha.Main;
import Xmcda_by_Dhouha.XmcdaMessage;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeSet;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class plotCriteriaComp {
    private String warningMessage = "";

    public boolean checkFiles(Criteria criter, CriteriaComparisons criterComp) {
        int size2;
        boolean result = true;
        int diff = 0;
        int size1 = criter.getCriteriaIDs().size();
        if (size1 == (size2 = criterComp.getListCriteriaIDs().size())) {
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (i < size2) {
                list.add(criterComp.getListCriteriaIDs().get(i));
                ++i;
            }
            for (String s : criter.getCriteriaIDs()) {
                if (list.contains(s)) continue;
                result = false;
                ++diff;
            }
            if (diff > 1) {
                this.warningMessage = this.warningMessage.concat("\nPlease check the file containing the criteria tag:incoherence with the criteria given in the file containing the criteriaComparisons tag. There are " + diff + " different criteria.");
            }
            if (diff == 1) {
                this.warningMessage = this.warningMessage.concat("\nPlease check the file containing the criteria tag:incoherence with the criteria given in the file containing the criteriaComparisons tag. There is one different criterion.");
            }
        } else {
            result = false;
            this.warningMessage = this.warningMessage.concat("\nPlease check the file containing the criteria tag:incoherence with the number of criteria given in the file containing the criteriaComparisons tag.");
            this.warningMessage = this.warningMessage.concat("\nIn order to run correctly, the program has selected the criteria available in both files.");
        }
        return result;
    }

    public ArrayList<String> getIntersectionCriteriaIDs(Criteria criter, CriteriaComparisons criterComp) {
        ArrayList<String> listintersection = new ArrayList<String>();
        for (String t : criterComp.getListCriteriaIDs()) {
            if (!criter.getCriteriaIDs().contains(t)) continue;
            listintersection.add(t);
        }
        listintersection = new ArrayList(new TreeSet(listintersection));
        return listintersection;
    }

    public String convertImage(File image_png, String format) {
        String encodedImage = "";
        try {
            BufferedImage image = ImageIO.read(image_png);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, format, baos);
            encodedImage = Base64.encode(baos.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!image_png.delete()) {
            System.err.println("Warning: " + image_png.getAbsolutePath() + " could not be deleted!");
        }
        return encodedImage;
    }

    public String createGraphiz(ArrayList<String> criterIDs, CriteriaComparisons criterComp, String color, boolean valuedGraph, boolean transitiveReduction, String node_shape) {
        GraphViz gv = new GraphViz();
        gv.addln(gv.start_graph(color, node_shape));
        int i = 0;
        while (i < criterIDs.size()) {
            int index_matrix_line = criterComp.getListCriteriaIDs().indexOf(criterIDs.get(i));
            int j = 0;
            while (j < criterComp.getListCriteriaIDs().size()) {
                if (criterIDs.contains(criterComp.getListCriteriaIDs().get(j)) && criterComp.getMatrix()[index_matrix_line][j] != -2000.0f) {
                    if (!valuedGraph) {
                        gv.addln(String.valueOf(criterIDs.get(i)) + " -> " + criterComp.getListCriteriaIDs().get(j) + ";");
                    } else {
                        String label = Float.toString(criterComp.getMatrix()[index_matrix_line][j]);
                        gv.addln(String.valueOf(criterIDs.get(i)) + " -> " + criterComp.getListCriteriaIDs().get(j) + " [label=" + label + ", fontcolor=" + color + "];");
                    }
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < criterIDs.size()) {
            gv.addln(String.valueOf(criterIDs.get(i)) + "[fontcolor=" + color + "]");
            ++i;
        }
        gv.addln(gv.end_graph());
        String type2 = "png";
        File png_image = null;
        try {
            png_image = File.createTempFile("MyImage_", "." + type2, new File(System.getProperty("java.io.tmpdir")));
        }
        catch (IOException j) {
            // empty catch block
        }
        gv.writeGraphToFile(gv.getGraph(gv.getDotSource(), type2, transitiveReduction), png_image);
        String encodedImage = this.convertImage(png_image, type2);
        return encodedImage;
    }

    protected static String getColorFromOptions(boolean black_and_white, String colorToUse) {
        String color = "";
        color = black_and_white ? "black" : colorToUse.toLowerCase();
        return color;
    }

    public static void main(String[] argv) {
        String pathMethodParameters = argv[0];
        String pathCriteria = argv[1];
        String pathCriteriaComparisons = argv[2];
        boolean stopRunning = false;
        String errorMessage = "";
        if (!(argv[0] != null && argv[1] != null && argv[2] != null && argv.length == 5 && new File(argv[0]).exists() && new File(argv[1]).exists() && new File(argv[2]).exists())) {
            stopRunning = true;
            errorMessage = "Error: unable to run the algorithm. Reason: missing one (or more) entry file(s). Please check your entry files.";
        }
        if (!stopRunning) {
            String errCriteriaComparisons;
            String errCriteria;
            Main mainFunction = new Main();
            String errMethodParameters = mainFunction.checkEntryFile(pathMethodParameters);
            if (errMethodParameters != "") {
                errorMessage = errorMessage.concat("\nFatal Error: the file containing the methodParameters tag is not a valid XMCDA document.");
            }
            if ((errCriteria = mainFunction.checkEntryFile(pathCriteria)) != "") {
                errorMessage = errorMessage.concat("\nFatal Error: the file containing the criteria tag is not a valid XMCDA document.");
            }
            if ((errCriteriaComparisons = mainFunction.checkEntryFile(pathCriteriaComparisons)) != "") {
                errorMessage = errorMessage.concat("\nFatal Error: the file containing the criteriaComparisons tag is not a valid XMCDA document.");
            }
            if (errMethodParameters != "" || errCriteria != "" || errCriteriaComparisons != "") {
                XmcdaMessage xmcdaMess = new XmcdaMessage();
                xmcdaMess.createErrorMessage(errorMessage);
                String pathOutputMessage = argv[4];
                xmcdaMess.enregistre(pathOutputMessage);
            } else {
                plotCriteriaComp plot = new plotCriteriaComp();
                if (mainFunction.getWarningMessage() != "") {
                    plot.warningMessage = plot.warningMessage.concat(mainFunction.getWarningMessage());
                }
                mainFunction.PrepareParsing(pathCriteria);
                Criteria criteriaToUse = new Criteria();
                JDOM_Criteria jdomCriter = new JDOM_Criteria();
                boolean parseCriteriaNull = false;
                criteriaToUse = jdomCriter.parseCriteriaXML(mainFunction.getRacine());
                if (criteriaToUse == null) {
                    parseCriteriaNull = true;
                    errorMessage = errorMessage.equals("") ? "\nFatal Error: the file containing the criteria tag is erroneous or empty." : errorMessage.concat("\nFatal Error: the file containing the criteria tag is erroneous or empty.");
                }
                if (jdomCriter.getWarning() != "") {
                    plot.warningMessage = plot.warningMessage.concat("\n" + jdomCriter.getWarning());
                }
                mainFunction.PrepareParsing(pathCriteriaComparisons);
                CriteriaComparisons criterCompaToUse = new CriteriaComparisons();
                JDOM_Criteria_Comparisons jdomCriterComp = new JDOM_Criteria_Comparisons();
                boolean parseCriterCompNull = false;
                criterCompaToUse = jdomCriterComp.exploreCriteriaComparisonsXML(mainFunction.getRacine());
                if (criterCompaToUse == null) {
                    parseCriterCompNull = true;
                    errorMessage = errorMessage.equals("") ? "\nFatal Error: the file containing the criteriaComparisons tag is erroneous or empty." : errorMessage.concat("\nFatal Error: the file containing the criteriaComparisons tag is erroneous or empty.");
                }
                if (jdomCriterComp.getWarningMessage() != "") {
                    plot.warningMessage = plot.warningMessage.concat("\n" + jdomCriter.getWarning());
                }
                MethodParamCriterComp parseMethodParam = new MethodParamCriterComp();
                mainFunction.PrepareParsing(pathMethodParameters);
                boolean statusParseMethod = parseMethodParam.parse(mainFunction.getRacine());
                if (parseMethodParam.getWarning() != "") {
                    plot.warningMessage = plot.warningMessage.concat(parseMethodParam.getWarning());
                }
                if (!statusParseMethod) {
                    errorMessage = errorMessage.equals("") ? "\nFatal Error: the file containing the methodParameters tag is erroneous or empty." : errorMessage.concat("\nFatal Error: the file containing the methodParameters tag is erroneous or empty.");
                }
                if (!parseCriterCompNull && !parseCriteriaNull && statusParseMethod) {
                    plot.checkFiles(criteriaToUse, criterCompaToUse);
                    ArrayList<String> listintersectionCriterIDs = plot.getIntersectionCriteriaIDs(criteriaToUse, criterCompaToUse);
                    if (listintersectionCriterIDs.isEmpty()) {
                        plot.warningMessage = plot.warningMessage.concat("\nOnly the criteria IDs in the file containing the criteriaComparisons tag will be considered. Please check your input file containing the criteria tag.");
                        int i = 0;
                        while (i < criterCompaToUse.getListCriteriaIDs().size()) {
                            listintersectionCriterIDs.add(criterCompaToUse.getListCriteriaIDs().get(i));
                            ++i;
                        }
                    }
                    if (listintersectionCriterIDs.isEmpty()) {
                        XmcdaMessage xmcdaMess = new XmcdaMessage();
                        errorMessage = errorMessage.concat("Failure to run the algorithm because it seems that the file containing the criteriaComparisons tag is empty or erroneous.");
                        xmcdaMess.createLogMessagePlotCriteriaComparisons(errCriteria, errCriteriaComparisons, plot.warningMessage, errorMessage);
                        String pathOutputMessage = argv[4];
                        xmcdaMess.enregistre(pathOutputMessage);
                    } else {
                        boolean color = parseMethodParam.getColor();
                        String colorToUse = parseMethodParam.getColorToUse();
                        colorToUse = plotCriteriaComp.getColorFromOptions(!color, colorToUse);
                        boolean valuedGraph = parseMethodParam.getValuedGraph();
                        boolean transitiveReduction = parseMethodParam.getTransitiveReduction();
                        if (valuedGraph) {
                            transitiveReduction = false;
                        }
                        String node_shape = parseMethodParam.getShape();
                        String encodedImage = plot.createGraphiz(listintersectionCriterIDs, criterCompaToUse, colorToUse, valuedGraph, transitiveReduction, node_shape);
                        XmcdaMessage xmcdaMess = new XmcdaMessage();
                        xmcdaMess.createLogMessagePlotCriteriaComparisons(errCriteria, errCriteriaComparisons, plot.warningMessage, errorMessage);
                        String pathOutputMessage = argv[4];
                        xmcdaMess.enregistre(pathOutputMessage);
                        String pathOutputFile = argv[3];
                        String commentToPut = "Criteria comparisons plot";
                        OutputCriterCompar outputFile = new OutputCriterCompar();
                        outputFile.createFile(listintersectionCriterIDs, encodedImage, commentToPut);
                        outputFile.saveFile(pathOutputFile);
                    }
                } else {
                    XmcdaMessage xmcdaMess = new XmcdaMessage();
                    xmcdaMess.createErrorMessage(errorMessage);
                    String pathOutputMessage = argv[4];
                    xmcdaMess.enregistre(pathOutputMessage);
                }
            }
        } else {
            XmcdaMessage xmcdaMess = new XmcdaMessage();
            xmcdaMess.createErrorMessage(errorMessage);
            String pathOutputMessage = argv[4];
            xmcdaMess.enregistre(pathOutputMessage);
        }
    }
}

