/*
 * Decompiled with CFR 0.152.
 */
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import eu.telecom_bretagne.utils.GraphViz;
import eu.telecom_bretagne.xmcda.Criteria;
import eu.telecom_bretagne.xmcda.CriteriaComparisons;
import eu.telecom_bretagne.xmcda.JDOM_Criteria;
import eu.telecom_bretagne.xmcda.JDOM_Criteria_Comparisons;
import eu.telecom_bretagne.xmcda.Main;
import eu.telecom_bretagne.xmcda.XmcdaMessage;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeSet;
import javax.imageio.ImageIO;

public class plotCriteriaComp {
    private String warningMessage = "";

    public boolean checkFiles(Criteria criter, CriteriaComparisons criterComp) {
        int size2;
        boolean result = true;
        int diff = 0;
        int size1 = criter.getCriteriaIDs().size();
        if (size1 == (size2 = criterComp.getListCriteriaIDs().size())) {
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (i < size2) {
                list.add(criterComp.getListCriteriaIDs().get(i));
                ++i;
            }
            for (String s : criter.getCriteriaIDs()) {
                if (list.contains(s)) continue;
                result = false;
                ++diff;
            }
            if (diff > 1) {
                this.warningMessage = this.warningMessage.concat("\nPlease check the file containing the criteria tag:incoherence with the criteria given in the file containing the criteriaComparisons tag. There are " + diff + " different criteria.");
            }
            if (diff == 1) {
                this.warningMessage = this.warningMessage.concat("\nPlease check the file containing the criteria tag:incoherence with the criteria given in the file containing the criteriaComparisons tag. There is one different criterion.");
            }
        } else {
            result = false;
            this.warningMessage = this.warningMessage.concat("\nPlease check the file containing the criteria tag:incoherence with the number of criteria given in the file containing the criteriaComparisons tag.");
            this.warningMessage = this.warningMessage.concat("\nIn order to run correctly, the program has selected the criteria available in both files.");
        }
        return result;
    }

    public ArrayList<String> getIntersectionCriteriaIDs(Criteria criter, CriteriaComparisons criterComp) {
        ArrayList<String> listintersection = new ArrayList<String>();
        for (String t : criterComp.getListCriteriaIDs()) {
            if (!criter.getCriteriaIDs().contains(t)) continue;
            listintersection.add(t);
        }
        listintersection = new ArrayList(new TreeSet(listintersection));
        return listintersection;
    }

    public String convertImage(File image_png, String format) {
        String encodedImage = "";
        try {
            BufferedImage image = ImageIO.read(image_png);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, format, baos);
            encodedImage = Base64.encode(baos.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!image_png.delete()) {
            System.err.println("Warning: " + image_png.getAbsolutePath() + " could not be deleted!");
        }
        return encodedImage;
    }

    public void createGraphiz(ArrayList<String> criterIDs, CriteriaComparisons criterComp, String color, boolean valuedGraph, boolean transitiveReduction, String node_shape, File dotFile, File pngFile) {
        GraphViz gv = new GraphViz();
        gv.addln(gv.start_graph(color, node_shape));
        int i = 0;
        while (i < criterIDs.size()) {
            int index_matrix_line = criterComp.getListCriteriaIDs().indexOf(criterIDs.get(i));
            int j = 0;
            while (j < criterComp.getListCriteriaIDs().size()) {
                if (criterIDs.contains(criterComp.getListCriteriaIDs().get(j)) && criterComp.getMatrix()[index_matrix_line][j] != -2000.0f) {
                    if (!valuedGraph) {
                        gv.addln(String.valueOf(criterIDs.get(i)) + " -> " + criterComp.getListCriteriaIDs().get(j) + ";");
                    } else {
                        String label = Float.toString(criterComp.getMatrix()[index_matrix_line][j]);
                        gv.addln(String.valueOf(criterIDs.get(i)) + " -> " + criterComp.getListCriteriaIDs().get(j) + " [label=" + label + ", fontcolor=" + color + "];");
                    }
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < criterIDs.size()) {
            gv.addln(String.valueOf(criterIDs.get(i)) + "[fontcolor=" + color + "]");
            ++i;
        }
        gv.addln(gv.end_graph());
        gv.setTransitiveReduction(transitiveReduction);
        try {
            FileWriter fw = new FileWriter(dotFile);
            fw.write(gv.getDotSource());
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        gv.createImage(dotFile, "png", pngFile);
    }

    protected static String getColorFromOptions(boolean black_and_white, String colorToUse) {
        String color = "";
        color = black_and_white ? "black" : colorToUse.toLowerCase();
        return color;
    }

    public static void main(String[] argv) {
        String errCriteriaComparisons;
        String errCriteria;
        String errorMessage = "";
        if (argv.length != 6) {
            System.err.println("Usage: criteria.xml criteriaMatrix.xml parameters.xml criteriaMatrix.dot criteriaMatrix.png messages.xml");
            System.err.println("       The 3 first files are inputs, the remaining ones are outputs");
            System.exit(-1);
        }
        if (!(new File(argv[0]).exists() && new File(argv[1]).exists() && new File(argv[2]).exists())) {
            errorMessage = "Error: unable to run the algorithm. Reason: missing one (or more) entry file(s). Please check your entry files.";
            XmcdaMessage xmcdaMess = new XmcdaMessage();
            xmcdaMess.createErrorMessage(errorMessage);
            xmcdaMess.enregistre(argv[5]);
        }
        String pathCriteria = argv[0];
        String pathCriteriaComparisons = argv[1];
        String pathMethodParameters = argv[2];
        String pathOutputDot = argv[3];
        String pathOutputPng = argv[4];
        String pathOutputMessage = argv[5];
        Main mainFunction = new Main();
        String errMethodParameters = mainFunction.checkEntryFile(pathMethodParameters);
        if (errMethodParameters != "") {
            errorMessage = errorMessage.concat("\nFatal Error: the file containing the parameters is not a valid XMCDA document.");
        }
        if ((errCriteria = mainFunction.checkEntryFile(pathCriteria)) != "") {
            errorMessage = errorMessage.concat("\nFatal Error: the file containing the criteria tag is not a valid XMCDA document.");
        }
        if ((errCriteriaComparisons = mainFunction.checkEntryFile(pathCriteriaComparisons)) != "") {
            errorMessage = errorMessage.concat("\nFatal Error: the file containing the criteriaComparisons tag is not a valid XMCDA document.");
        }
        if (errMethodParameters != "" || errCriteria != "" || errCriteriaComparisons != "") {
            XmcdaMessage xmcdaMess = new XmcdaMessage();
            xmcdaMess.createErrorMessage(errorMessage);
            xmcdaMess.enregistre(pathOutputMessage);
        } else {
            plotCriteriaComp plot = new plotCriteriaComp();
            if (mainFunction.getWarningMessage() != "") {
                plot.warningMessage = plot.warningMessage.concat(mainFunction.getWarningMessage());
            }
            mainFunction.PrepareParsing(pathCriteria);
            Criteria criteriaToUse = new Criteria();
            JDOM_Criteria jdomCriter = new JDOM_Criteria();
            boolean parseCriteriaNull = false;
            criteriaToUse = jdomCriter.parseCriteriaXML(mainFunction.getRacine());
            if (criteriaToUse == null) {
                parseCriteriaNull = true;
                errorMessage = errorMessage.equals("") ? "\nFatal Error: the file containing the criteria tag is erroneous or empty." : errorMessage.concat("\nFatal Error: the file containing the criteria tag is erroneous or empty.");
            }
            if (jdomCriter.getWarning() != "") {
                plot.warningMessage = plot.warningMessage.concat("\n" + jdomCriter.getWarning());
            }
            mainFunction.PrepareParsing(pathCriteriaComparisons);
            CriteriaComparisons criterCompaToUse = new CriteriaComparisons();
            JDOM_Criteria_Comparisons jdomCriterComp = new JDOM_Criteria_Comparisons();
            boolean parseCriterCompNull = false;
            criterCompaToUse = jdomCriterComp.exploreCriteriaComparisonsXML(mainFunction.getRacine());
            if (criterCompaToUse == null) {
                parseCriterCompNull = true;
                errorMessage = errorMessage.equals("") ? "\nFatal Error: the file containing the criteriaComparisons tag is erroneous or empty." : errorMessage.concat("\nFatal Error: the file containing the criteriaComparisons tag is erroneous or empty.");
            }
            if (jdomCriterComp.getWarningMessage() != "") {
                plot.warningMessage = plot.warningMessage.concat("\n" + jdomCriter.getWarning());
            }
            MethodParamCriterComp parseMethodParam = new MethodParamCriterComp();
            mainFunction.PrepareParsing(pathMethodParameters);
            boolean statusParseMethod = parseMethodParam.parse(mainFunction.getRacine());
            if (parseMethodParam.getWarning() != "") {
                plot.warningMessage = plot.warningMessage.concat(parseMethodParam.getWarning());
            }
            if (!statusParseMethod) {
                errorMessage = errorMessage.equals("") ? "\nFatal Error: the file containing the parameters is erroneous or empty." : errorMessage.concat("\nFatal Error: the file containing the methodParameters tag is erroneous or empty.");
            }
            if (!parseCriterCompNull && !parseCriteriaNull && statusParseMethod) {
                plot.checkFiles(criteriaToUse, criterCompaToUse);
                ArrayList<String> listintersectionCriterIDs = plot.getIntersectionCriteriaIDs(criteriaToUse, criterCompaToUse);
                if (listintersectionCriterIDs.isEmpty()) {
                    plot.warningMessage = plot.warningMessage.concat("\nOnly the criteria IDs in the file containing the criteriaComparisons tag will be considered. Please check your input file containing the criteria tag.");
                    int i = 0;
                    while (i < criterCompaToUse.getListCriteriaIDs().size()) {
                        listintersectionCriterIDs.add(criterCompaToUse.getListCriteriaIDs().get(i));
                        ++i;
                    }
                }
                if (listintersectionCriterIDs.isEmpty()) {
                    XmcdaMessage xmcdaMess = new XmcdaMessage();
                    errorMessage = errorMessage.concat("Failure to run the algorithm because it seems that the file containing the criteriaComparisons tag is empty or erroneous.");
                    xmcdaMess.createLogMessagePlotCriteriaComparisons(errCriteria, errCriteriaComparisons, plot.warningMessage, errorMessage);
                    xmcdaMess.enregistre(pathOutputMessage);
                } else {
                    boolean color = parseMethodParam.getColor();
                    String colorToUse = parseMethodParam.getColorToUse();
                    colorToUse = plotCriteriaComp.getColorFromOptions(!color, colorToUse);
                    boolean valuedGraph = parseMethodParam.getValuedGraph();
                    boolean transitiveReduction = parseMethodParam.getTransitiveReduction();
                    if (valuedGraph) {
                        transitiveReduction = false;
                    }
                    String node_shape = parseMethodParam.getShape();
                    XmcdaMessage xmcdaMess = new XmcdaMessage();
                    xmcdaMess.createLogMessagePlotCriteriaComparisons(errCriteria, errCriteriaComparisons, plot.warningMessage, errorMessage);
                    xmcdaMess.enregistre(pathOutputMessage);
                    plot.createGraphiz(listintersectionCriterIDs, criterCompaToUse, colorToUse, valuedGraph, transitiveReduction, node_shape, new File(pathOutputDot), new File(pathOutputPng));
                }
            } else {
                XmcdaMessage xmcdaMess = new XmcdaMessage();
                xmcdaMess.createErrorMessage(errorMessage);
                xmcdaMess.enregistre(pathOutputMessage);
            }
        }
    }
}

