/*
 * Decompiled with CFR 0.152.
 */
import eu.telecom_bretagne.xmcda.Criterion;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class LineChart {
    private JFreeChart chart;

    public LineChart(String title, String chartTitle, String XaxisLabel, Criterion criter, boolean interpolation, Color colorToUse, boolean addBars) {
        XYDataset dataset = this.createDataset(criter, addBars);
        this.chart = this.createChart(dataset, chartTitle, XaxisLabel, interpolation, colorToUse, criter, addBars);
    }

    public void saveChart(OutputStream outputStream) {
        try {
            ChartUtilities.writeChartAsPNG((OutputStream)outputStream, (JFreeChart)this.chart, (int)500, (int)270);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveChart(String filepath) {
        File file = new File(filepath);
        try {
            ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)this.chart, (int)500, (int)270);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private XYDataset createDataset(Criterion criterion, boolean addBars) {
        XYSeries series1 = new XYSeries((Comparable)((Object)""));
        int numberOfPoints = criterion.getCriterionFunction().getPoints().size();
        XYSeries[] series = new XYSeries[numberOfPoints];
        int j = 0;
        while (j < numberOfPoints) {
            series[j] = new XYSeries((Comparable)Integer.valueOf(j));
            ++j;
        }
        j = 0;
        while (j < numberOfPoints) {
            float x = criterion.getCriterionFunction().getPoints().get(j).getAbscissa();
            float y = criterion.getCriterionFunction().getPoints().get(j).getOrdinate();
            series1.add((double)x, (double)y);
            series[j].add((double)x, 0.0);
            series[j].add((double)x, (double)y);
            ++j;
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series1);
        if (addBars) {
            int j2 = 0;
            while (j2 < numberOfPoints) {
                dataset.addSeries(series[j2]);
                ++j2;
            }
        }
        return dataset;
    }

    private JFreeChart createChart(XYDataset dataset, String chartTitle, String XaxisLabel, boolean interpolation, Color colorToUse, Criterion criter, boolean addBars) {
        JFreeChart chart = ChartFactory.createXYLineChart((String)chartTitle, (String)XaxisLabel, (String)"", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        Font font = new Font("Arial", 1, 12);
        ValueAxis domainAxis = plot.getDomainAxis();
        domainAxis.setTickLabelFont(font);
        domainAxis.setLabelFont(new Font("Arial", 1, 16));
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setTickLabelFont(font);
        rangeAxis.setLabelFont(new Font("Arial", 1, 16));
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesPaint(0, (Paint)colorToUse);
        renderer.setSeriesShape(0, (Shape)new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0));
        if (interpolation) {
            renderer.setSeriesLinesVisible(0, true);
            renderer.setSeriesShapesVisible(0, true);
        } else {
            renderer.setSeriesLinesVisible(0, false);
            renderer.setSeriesShapesVisible(0, true);
        }
        if (addBars) {
            int j = 0;
            while (j < criter.getCriterionFunction().getPoints().size()) {
                renderer.setSeriesLinesVisible(j + 1, true);
                renderer.setSeriesShapesVisible(j + 1, false);
                renderer.setSeriesPaint(j + 1, (Paint)colorToUse);
                ++j;
            }
        }
        plot.setRenderer((XYItemRenderer)renderer);
        return chart;
    }
}

