/*
 * Decompiled with CFR 0.152.
 */
package packagePlotOptions;

import eu.telecom_bretagne.xmcda.Criteria;
import eu.telecom_bretagne.xmcda.CriteriaValues;
import eu.telecom_bretagne.xmcda.JDOM_Criteria;
import eu.telecom_bretagne.xmcda.JDOM_CriteriaValues;
import eu.telecom_bretagne.xmcda.Main;
import eu.telecom_bretagne.xmcda.XmcdaMessage;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import packagePlotOptions.BarChartDemo3;
import packagePlotOptions.ImageToBase64;
import packagePlotOptions.OutputPlotFile;
import packagePlotOptions.ParseMethodParameters;
import packagePlotOptions.PieChartDemo4;

public class Plot {
    private String warningMessage = "";

    public boolean checkFiles(Criteria criter, CriteriaValues criterVal) {
        boolean result = true;
        int diff = 0;
        if (criter.getCriteriaIDs().size() != criterVal.size()) {
            this.warningMessage = this.warningMessage.concat("\nPlease check the file containing the criteria tag:incoherence with the number of criteria given in the file containing the criteriaValues tag.");
            return false;
        }
        for (String s : criterVal.getCriteriaIDs()) {
            if (criter.getCriteriaIDs().contains(s)) continue;
            result = false;
            ++diff;
        }
        if (diff > 1) {
            this.warningMessage = this.warningMessage.concat("\nPlease check the file containing the criteria tag:incoherence with the criteria given in the file containing the criteriaValues tag. There are " + diff + "different criteria.");
        }
        if (diff == 1) {
            this.warningMessage = this.warningMessage.concat("\nPlease check the file containing the criteria tag:incoherence with the criteria given in the file containing the criteriaValues tag. There is one different criterion.");
        }
        return result;
    }

    public ArrayList<String> getIntersectionCriteriaIDs(Criteria criter, CriteriaValues criterVal) {
        HashSet<String> intersection = new HashSet<String>();
        for (String t : criterVal.getCriteriaIDs()) {
            if (!criter.getCriteriaIDs().contains(t)) continue;
            intersection.add(t);
        }
        return new ArrayList<String>(intersection);
    }

    public ArrayList<String> getIntersectionCriteriaNames(Criteria criter, CriteriaValues criterVal, ArrayList<String> listintersectionIds) {
        ArrayList<String> listintersectionNames = new ArrayList<String>();
        int i = 0;
        while (i < listintersectionIds.size()) {
            if (criter.getCriteriaIDs().contains(listintersectionIds.get(i))) {
                int index = criter.getCriteriaIDs().indexOf(listintersectionIds.get(i));
                if (criter.getListCriteriaNames().get(index) != null) {
                    listintersectionNames.add(criter.getListCriteriaNames().get(index));
                } else {
                    listintersectionNames.add(null);
                }
            } else {
                listintersectionNames.add(null);
            }
            ++i;
        }
        return listintersectionNames;
    }

    public String plotCriteriaValuesBarChart(CriteriaValues criteriaValuesToPlot, Criteria criter, ArrayList<String> listintersectionCriteria, int format, String tempErrorMessage, boolean color, Color color1, Color color2, String chartTitle, String XaxisLabel, String YaxisLabel, ArrayList<String> listintersectionNames, String order, String maxMin) {
        double[] ySeriesCriterValues = new double[listintersectionCriteria.size()];
        int i = 0;
        while (i < listintersectionCriteria.size()) {
            if (criteriaValuesToPlot.getCriteriaIDs().contains(listintersectionCriteria.get(i))) {
                ySeriesCriterValues[i] = criteriaValuesToPlot.getListCriteriaValues().get(criteriaValuesToPlot.getCriteriaIDs().indexOf(listintersectionCriteria.get(i))).getRealValue();
            }
            ++i;
        }
        ByteArrayOutputStream chart_png_image = new ByteArrayOutputStream();
        BarChartDemo3 barChartCriterVal = new BarChartDemo3("Bar Chart Demo 3", ySeriesCriterValues, color1, color2, chartTitle, XaxisLabel, YaxisLabel, criter, listintersectionCriteria, listintersectionNames, order, maxMin);
        barChartCriterVal.saveChart(chart_png_image);
        ImageToBase64 imageConvert = new ImageToBase64();
        String encodedImage = imageConvert.convertImage(new ByteArrayInputStream(chart_png_image.toByteArray()), "png");
        if (imageConvert.getImageErrorMessage() != "") {
            tempErrorMessage = tempErrorMessage.concat(imageConvert.getImageErrorMessage());
        }
        return encodedImage;
    }

    public String plotCriteriaValuesPieChart(CriteriaValues criteriaValuesToPlot, Criteria criter, ArrayList<String> listintersectionCriteria, int format, String tempErrorMessage, boolean color, Color color1, Color color2, String chartTitle, ArrayList<String> listintersectionNames, String order, String maxMin) {
        double[] ySeriesCriterValues = new double[listintersectionCriteria.size()];
        int i = 0;
        while (i < listintersectionCriteria.size()) {
            if (criteriaValuesToPlot.getCriteriaIDs().contains(listintersectionCriteria.get(i))) {
                ySeriesCriterValues[i] = criteriaValuesToPlot.getListCriteriaValues().get(criteriaValuesToPlot.getCriteriaIDs().indexOf(listintersectionCriteria.get(i))).getRealValue();
            }
            ++i;
        }
        ByteArrayOutputStream chart_png_image = new ByteArrayOutputStream();
        PieChartDemo4 pieChartCriterVal = new PieChartDemo4("PieChartDemo4", ySeriesCriterValues, criteriaValuesToPlot, criter, color1, color2, chartTitle, listintersectionCriteria, listintersectionNames, order, maxMin);
        pieChartCriterVal.saveChart(chart_png_image);
        ImageToBase64 imageConvert = new ImageToBase64();
        String encodedImage = imageConvert.convertImage(new ByteArrayInputStream(chart_png_image.toByteArray()), "png");
        if (imageConvert.getImageErrorMessage() != "") {
            tempErrorMessage = tempErrorMessage.concat(imageConvert.getImageErrorMessage());
        }
        return encodedImage;
    }

    protected static Color[] getColorsFromOptions(boolean black_and_white, String colors1ToUse, String colors2ToUse) {
        Color[] colors = new Color[]{Color.black, Color.black};
        if (black_and_white) {
            return colors;
        }
        Color c1 = null;
        Color c2 = null;
        try {
            c1 = (Color)Color.class.getField(colors1ToUse.toLowerCase()).get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (c1 == null) {
            return colors;
        }
        try {
            c2 = (Color)Color.class.getField(colors2ToUse.toLowerCase()).get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (c2 == null) {
            return colors;
        }
        colors[0] = c1;
        colors[1] = c2;
        return colors;
    }

    public static void main(String[] argv) {
        String errCriteriaValues;
        String errCriteria;
        String tempErrorMessage = "";
        if (argv.length != 5) {
            System.err.println("Usage: methodPlotOptions.xml criteria.xml criteriaValues.xml criteriaValuesPlot.xml messages.xml");
            System.err.println("       The 3 first files are inputs, the remaining ones are outputs");
            System.exit(-1);
        }
        String pathMethodParameters = argv[0];
        String pathCriteria = argv[1];
        String pathCriteriaValues = argv[2];
        String pathOutputFilePlot = argv[3];
        String pathOutputMessage = argv[4];
        if (!(new File(argv[0]).exists() && new File(argv[1]).exists() && new File(argv[2]).exists())) {
            tempErrorMessage = "Error: unable to run the algorithm. Reason: missing one (or more)entry file(s). Please check your entry files";
            XmcdaMessage.writeErrorMessage(tempErrorMessage, pathOutputMessage);
            return;
        }
        Main mainFunction = new Main();
        String errMethodParameters = mainFunction.checkEntryFile(pathMethodParameters);
        if (errMethodParameters != "") {
            tempErrorMessage = tempErrorMessage.concat("\nFatal Error: the file containing the methodParameters tag is not a valid XMCDA document.");
        }
        if ((errCriteria = mainFunction.checkEntryFile(pathCriteria)) != "") {
            tempErrorMessage = tempErrorMessage.concat("\nFatal Error: the file containing the criteria tag is not a valid XMCDA document.");
        }
        if ((errCriteriaValues = mainFunction.checkEntryFile(pathCriteriaValues)) != "") {
            tempErrorMessage = tempErrorMessage.concat("\nFatal Error: the file containing the criteriaValues tag is not a valid XMCDA document.");
        }
        if (errMethodParameters != "" || errCriteria != "" || errCriteriaValues != "") {
            XmcdaMessage.writeErrorMessage(tempErrorMessage, pathOutputMessage);
            return;
        }
        Plot plot = new Plot();
        if (mainFunction.getWarningMessage() != "") {
            plot.warningMessage = plot.warningMessage.concat(mainFunction.getWarningMessage());
        }
        mainFunction.PrepareParsing(pathCriteria);
        Criteria criteria = new Criteria();
        JDOM_Criteria jdomCriter = new JDOM_Criteria();
        criteria = jdomCriter.parseCriteriaXML(mainFunction.getRacine());
        if (criteria == null) {
            tempErrorMessage = tempErrorMessage.concat("\nFatal Error: the file containing the criteria tag is erroneous or empty.");
        }
        if (jdomCriter.getWarning() != "") {
            plot.warningMessage = plot.warningMessage.concat("\n" + jdomCriter.getWarning());
        }
        mainFunction.PrepareParsing(pathCriteriaValues);
        CriteriaValues criteriaValues = new CriteriaValues();
        JDOM_CriteriaValues jdomCriterVal = new JDOM_CriteriaValues();
        criteriaValues = jdomCriterVal.parseCriteriaValuesXML(mainFunction.getRacine());
        if (criteriaValues == null) {
            tempErrorMessage = tempErrorMessage.concat("\nFatal Error: the file containing the criteriaValues tag is erroneous or empty.");
        }
        if (jdomCriterVal.getWarningMessage() != "") {
            plot.warningMessage = plot.warningMessage.concat("\n" + jdomCriterVal.getWarningMessage());
        }
        ParseMethodParameters parseMethodParam = new ParseMethodParameters();
        mainFunction.PrepareParsing(pathMethodParameters);
        boolean statusParseMethod = parseMethodParam.parse(mainFunction.getRacine());
        if (!statusParseMethod) {
            tempErrorMessage = tempErrorMessage.concat("\nFatal Error: the file containing the methodParameters tag is erroneous or empty.");
        }
        if (criteriaValues == null || criteria == null || !statusParseMethod) {
            XmcdaMessage xmcdaMess = new XmcdaMessage();
            xmcdaMess.createErrorMessage(tempErrorMessage);
            xmcdaMess.enregistre(argv[4]);
            return;
        }
        plot.checkFiles(criteria, criteriaValues);
        ArrayList<String> listintersectionCriteria = plot.getIntersectionCriteriaIDs(criteria, criteriaValues);
        if (listintersectionCriteria.isEmpty()) {
            plot.warningMessage = plot.warningMessage.concat("\nOnly the criteriaIDs in the file containing the criteriaValues tag were considered. Please check your input file containing the criteria tag.");
            listintersectionCriteria = criteriaValues.getCriteriaIDs();
        }
        boolean color = parseMethodParam.getColor();
        String chartType = parseMethodParam.getChartType();
        if (parseMethodParam.getError() != "") {
            plot.warningMessage = plot.warningMessage.concat(parseMethodParam.getError());
        }
        String colors1ToUse = parseMethodParam.getInitialColor();
        String colors2ToUse = parseMethodParam.getFinalColor();
        Color[] colors = Plot.getColorsFromOptions(!color, colors1ToUse, colors2ToUse);
        int format = 5;
        String encodedImage = "";
        String chartTitle = parseMethodParam.getChartTitle();
        String XaxisLabel = parseMethodParam.getDomainAxisLabel();
        String YaxisLabel = parseMethodParam.getRangeAxisLabel();
        String order = parseMethodParam.getOrder();
        String maxMin = parseMethodParam.getMaxMin();
        if (listintersectionCriteria.size() != 0) {
            if (chartType.equals("bc")) {
                encodedImage = plot.plotCriteriaValuesBarChart(criteriaValues, criteria, listintersectionCriteria, format, tempErrorMessage, color, colors[0], colors[1], chartTitle, XaxisLabel, YaxisLabel, plot.getIntersectionCriteriaNames(criteria, criteriaValues, listintersectionCriteria), order, maxMin);
            } else if (chartType.equals("pc")) {
                encodedImage = plot.plotCriteriaValuesPieChart(criteriaValues, criteria, listintersectionCriteria, format, tempErrorMessage, color, colors[0], colors[1], chartTitle, plot.getIntersectionCriteriaNames(criteria, criteriaValues, listintersectionCriteria), order, maxMin);
            } else {
                tempErrorMessage = tempErrorMessage.concat("\nError in chart type. Only Pie chart or Bar chart are available plots.");
            }
        } else {
            tempErrorMessage = tempErrorMessage.concat("\n We cannot run the algorithm since the criteria list  of the PROJECT is empty.\n");
        }
        if (encodedImage.equals("")) {
            tempErrorMessage = tempErrorMessage.concat("\n Error: the chart is empty. Please check your parameters.");
        }
        XmcdaMessage xmcdaMess = new XmcdaMessage();
        xmcdaMess.createLogMessageForCriteriaValPlot(errCriteria, errCriteriaValues, plot.warningMessage, tempErrorMessage);
        xmcdaMess.enregistre(pathOutputMessage);
        String commentToPut = "Criteria values plot";
        if (listintersectionCriteria.size() != 0 && encodedImage != "") {
            OutputPlotFile outputPlotFile = new OutputPlotFile();
            outputPlotFile.createOutputFile(listintersectionCriteria, encodedImage, commentToPut);
            outputPlotFile.saveFile(pathOutputFilePlot);
        }
    }
}

