/*
 * Decompiled with CFR 0.152.
 */
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import eu.telecom_bretagne.utils.GraphViz;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class PreorderOutputFile {
    private static final Namespace xsi = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    private static final Namespace xmcda = Namespace.getNamespace((String)"xmcda", (String)"http://www.decision-deck.org/2009/XMCDA-2.0.0");

    public static void createFiles(ArrayList<String> listIDs, GraphViz gv, String commentToPut, File xmlFile, File dotFile) {
        Element racine = new Element("XMCDA");
        Document document = new Document(racine);
        racine.setNamespace(xmcda);
        racine.addNamespaceDeclaration(xsi);
        racine.addNamespaceDeclaration(xmcda);
        racine.setAttribute("schemaLocation", "http://www.decision-deck.org/2009/XMCDA-2.0.0 http://sma.uni.lu/d2cms/xmcda/_downloads/XMCDA-2.0.0.xsd", xsi);
        List contents = racine.getContent();
        contents.clear();
        Element criterionValue = new Element("criterionValue");
        racine.addContent((Content)criterionValue);
        Attribute name = new Attribute("mcdaConcept", commentToPut);
        criterionValue.setAttribute(name);
        Element criteriaSet = new Element("criteriaSet");
        criterionValue.addContent((Content)criteriaSet);
        int i = 0;
        while (i < listIDs.size()) {
            Element element = new Element("element");
            criteriaSet.addContent((Content)element);
            Element criterionID = new Element("criterionID");
            element.addContent((Content)criterionID);
            criterionID.setText(listIDs.get(i).toString());
            ++i;
        }
        Element value = new Element("value");
        criterionValue.addContent((Content)value);
        Element image = new Element("image");
        value.addContent((Content)image);
        image.setText(Base64.encode(gv.getGraph(gv.getDotSource(), "png")));
        try {
            XMLOutputter sortie = new XMLOutputter(Format.getPrettyFormat());
            FileOutputStream fos = new FileOutputStream(xmlFile);
            sortie.output(document, (OutputStream)fos);
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (dotFile != null) {
            try {
                FileWriter fw = new FileWriter(dotFile);
                fw.write(gv.getDotSource());
                fw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

