/*
 * Decompiled with CFR 0.152.
 */
package eu.telecom_bretagne.xmcda;

import eu.telecom_bretagne.xmcda.Alternative;
import eu.telecom_bretagne.xmcda.AlternativeValue;
import eu.telecom_bretagne.xmcda.AlternativesValues;
import java.util.ArrayList;
import java.util.Iterator;
import org.jdom2.Element;

public class JDOM_AlternativesValues {
    private String warningMessage = "";

    public AlternativesValues parseAlternativesValuesXML(Element racine) {
        if (racine.getChild("alternativesValues") == null) {
            return null;
        }
        Element alternaVal = racine.getChild("alternativesValues");
        if (alternaVal.getChildren("alternativeValue") == null) {
            return null;
        }
        AlternativesValues alternativesValues = new AlternativesValues();
        Iterator i = alternaVal.getChildren("alternativeValue").iterator();
        ArrayList<Element> values = new ArrayList<Element>();
        while (i.hasNext()) {
            Element current_alternativeValue = (Element)i.next();
            String temp = "";
            values.clear();
            boolean alternativeIDOK = true;
            String current_alternativeID = current_alternativeValue.getChild("alternativeID").getValue();
            if (current_alternativeID == null || "".equals(current_alternativeID)) {
                this.warningMessage = this.warningMessage.concat("\nalternativesValues tag: invalid empty alternativeID: ignored.");
                continue;
            }
            if (current_alternativeValue.getChildren("values") != null) {
                for (Element values_elt : current_alternativeValue.getChildren("values")) {
                    for (Element value_elt : values_elt.getChildren("value")) {
                        values.add(value_elt);
                    }
                }
            }
            if (current_alternativeValue.getChildren("value") != null) {
                for (Element value_elt : current_alternativeValue.getChildren("value")) {
                    values.add(value_elt);
                }
            }
            if (values.isEmpty()) {
                this.warningMessage = this.warningMessage.concat("\nalternativesValues: no value has been found for alternative " + current_alternativeID + ": this alternative is not taken into account.");
                continue;
            }
            if (values.size() > 1) {
                this.warningMessage = this.warningMessage.concat("\nalternativesValues has more than one value for alternative " + current_alternativeID + ": only the first real or integer value will be displayed.");
            }
            alternativeIDOK = false;
            for (Element value : values) {
                if (value.getChild("real") != null) {
                    temp = value.getChild("real").getValue();
                    alternativeIDOK = true;
                    break;
                }
                if (value.getChild("integer") == null) continue;
                temp = value.getChild("integer").getValue();
                alternativeIDOK = true;
                break;
            }
            if (alternativeIDOK) {
                if (alternativesValues.getListAlternativesIDs().contains(current_alternativeID)) continue;
                Alternative alternative = new Alternative(current_alternativeID);
                alternativesValues.addAlternative(new AlternativeValue(alternative, Float.parseFloat(temp)));
                continue;
            }
            this.warningMessage = this.warningMessage.concat("\nalternativesValues: no real value nor integer value has been found for alternative " + current_alternativeID + ": this alternative is not taken into account.");
        }
        return alternativesValues;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }
}

