/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class FuzzyPlot {
    private JFreeChart chart;

    public FuzzyPlot(String chartTitle, String XaxisLabel, String YaxisLabel, FuzzySet fuzzySet, boolean color) {
        XYDataset dataset = this.createDataset(fuzzySet);
        this.chart = this.createChart(dataset, chartTitle, XaxisLabel, YaxisLabel, color, fuzzySet);
    }

    public void saveChart(OutputStream outputStream) {
        try {
            ChartUtilities.writeChartAsPNG((OutputStream)outputStream, (JFreeChart)this.chart, (int)500, (int)270);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveChart(String filepath) {
        File file = new File(filepath);
        try {
            ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)this.chart, (int)500, (int)270);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private XYDataset createDataset(FuzzySet fuzzySet) {
        int size = fuzzySet.getIDsList().size();
        XYSeries[] series = new XYSeries[size];
        int j = 0;
        while (j < size) {
            series[j] = new XYSeries((Comparable)((Object)fuzzySet.getIDsList().get(j)));
            ++j;
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        int j2 = 0;
        while (j2 < size) {
            int numberOfPoints = fuzzySet.getFuzzyNumbers().get(j2).getPoints().size();
            int i = 0;
            while (i < numberOfPoints) {
                double x = fuzzySet.getFuzzyNumbers().get(j2).getPoints().get(i).getX();
                double y = fuzzySet.getFuzzyNumbers().get(j2).getPoints().get(i).getY();
                series[j2].add(x, y);
                ++i;
            }
            dataset.addSeries(series[j2]);
            ++j2;
        }
        return dataset;
    }

    private JFreeChart createChart(XYDataset dataset, String chartTitle, String XaxisLabel, String YaxisLabel, boolean color, FuzzySet fuzzySet) {
        JFreeChart chart = ChartFactory.createXYLineChart((String)chartTitle, (String)XaxisLabel, (String)YaxisLabel, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        chart.getLegend().setItemFont(new Font("Arial", 1, 12));
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setDomainGridlinesVisible(true);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.gray);
        plot.setDomainGridlinePaint((Paint)Color.gray);
        Font font = new Font("Arial", 1, 12);
        ValueAxis domainAxis = plot.getDomainAxis();
        domainAxis.setTickLabelFont(font);
        domainAxis.setLabelFont(new Font("Arial", 1, 16));
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setTickLabelFont(font);
        rangeAxis.setLabelFont(new Font("Arial", 1, 16));
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        int maxNumber = 30;
        int i = 0;
        while (i < maxNumber) {
            renderer.setSeriesStroke(i, (Stroke)new BasicStroke(2.0f));
            if (!color) {
                renderer.setSeriesPaint(i, (Paint)Color.black);
            }
            renderer.setSeriesLinesVisible(i, true);
            renderer.setSeriesShapesVisible(i, true);
            ++i;
        }
        plot.setRenderer((XYItemRenderer)renderer);
        return chart;
    }
}

