/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class mainFuzzyPlot {
    private Element racine = new Element("XMCDA");
    private Document document = new Document(this.racine);
    private static final String XMCDA_2_0_0_NAMESPACE = "http://www.decision-deck.org/2009/XMCDA-2.0.0";
    private static final String XMCDA_2_0_0_SCHEMA = "http://www.decision-deck.org/xmcda/_downloads/XMCDA-2.0.0.xsd";
    private static final String XMCDA_2_1_0_NAMESPACE = "http://www.decision-deck.org/2009/XMCDA-2.1.0";
    private static final String XMCDA_2_1_0_SCHEMA = "http://www.decision-deck.org/xmcda/_downloads/XMCDA-2.1.0.xsd";
    private static final String XMCDA_2_2_0_NAMESPACE = "http://www.decision-deck.org/2012/XMCDA-2.2.0";
    private static final String XMCDA_2_2_0_SCHEMA = "http://www.decision-deck.org/xmcda/_downloads/XMCDA-2.2.0.xsd";
    private static final String ACCEPTED_SCHEMA_LOCATIONS = "http://www.decision-deck.org/2009/XMCDA-2.0.0 http://www.decision-deck.org/xmcda/_downloads/XMCDA-2.0.0.xsd http://www.decision-deck.org/2009/XMCDA-2.1.0 http://www.decision-deck.org/xmcda/_downloads/XMCDA-2.1.0.xsd http://www.decision-deck.org/2012/XMCDA-2.2.0 http://www.decision-deck.org/xmcda/_downloads/XMCDA-2.2.0.xsd";

    public void PrepareParsing(String path) {
        try {
            SAXBuilder sxb = new SAXBuilder();
            this.document = sxb.build(new File(path));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.racine = this.document.getRootElement();
    }

    protected static String checkEntryFile(String path) {
        String error = "";
        try {
            mainFuzzyPlot.parseXML(path);
        }
        catch (JDOMException e) {
            error = error.concat("File is not well-formed: " + e.getMessage());
        }
        catch (IOException e) {
            error = error.concat("Could not check file because: " + e.getMessage());
        }
        return error;
    }

    protected static void parseXML(String xml) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser", true);
        builder.setFeature("http://apache.org/xml/features/validation/schema", true);
        builder.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (Object)ACCEPTED_SCHEMA_LOCATIONS);
        Document doc = builder.build(xml);
    }

    protected static Color getColorFromOptions(boolean black_and_white, String colorsToUse) {
        Color color = Color.black;
        if (black_and_white) {
            return color;
        }
        Color c = null;
        try {
            c = (Color)Color.class.getField(colorsToUse.toLowerCase()).get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (c == null) {
            return color;
        }
        color = c;
        return color;
    }

    public String generatedPlot(String title, String XaxisLabel, String YaxisLabel, FuzzySet fuzzySet, boolean color) {
        ByteArrayOutputStream chart_png_image = new ByteArrayOutputStream();
        FuzzyPlot fuzzyPlot = new FuzzyPlot(title, XaxisLabel, YaxisLabel, fuzzySet, color);
        fuzzyPlot.saveChart(chart_png_image);
        ImageGenerated imageConvert = new ImageGenerated();
        String encodedImage = imageConvert.convertImage(new ByteArrayInputStream(chart_png_image.toByteArray()), "png");
        return encodedImage;
    }

    public static void main(String[] argv) {
        mainFuzzyPlot plot = new mainFuzzyPlot();
        String errorMessage = "";
        String warningMessage = "";
        boolean stopRunning = false;
        if (argv[0] == null || argv[1] == null || argv.length != 4 || !new File(argv[0]).exists() || !new File(argv[1]).exists()) {
            stopRunning = true;
            errorMessage = "Error: unable to run the algorithm. Reason: missing one (or more) entry file(s).Please check your entry files.";
        }
        if (!stopRunning) {
            String pathOptions = argv[0];
            String pathFuzzy = argv[1];
            String errParameters = mainFuzzyPlot.checkEntryFile(pathOptions);
            String errFuzzy = mainFuzzyPlot.checkEntryFile(pathFuzzy);
            if (errParameters != "") {
                errorMessage = errorMessage.concat("\nFatal Error: the file containing the 'methodParameters' tag is not a valid XMCDA document: " + errParameters);
            }
            if (errFuzzy != "") {
                errorMessage = errorMessage.concat("\nFatal Error: the file containing the 'categoriesValues' tag (fuzzy numbers) is not a valid XMCDA document: " + errFuzzy);
            }
            if (errParameters != "" || errFuzzy != "") {
                StatusMessage xmcdaMess = new StatusMessage();
                xmcdaMess.createErrorMessage(errorMessage);
                String pathOutputMessage = argv[argv.length - 1];
                xmcdaMess.save(pathOutputMessage);
            } else {
                ParseMethodParameters parseMethodParam = new ParseMethodParameters();
                plot.PrepareParsing(pathOptions);
                boolean statusParseMethod = parseMethodParam.parse(plot.racine);
                if (!statusParseMethod) {
                    errorMessage = errorMessage.concat("\nFatal Error: the file containing the methodParameters tag is erroneous or empty.");
                }
                plot.PrepareParsing(pathFuzzy);
                FuzzySet fuzzySet = new FuzzySet();
                ParseCategoriesValues categVal = new ParseCategoriesValues();
                boolean parseCategValNull = false;
                fuzzySet = categVal.exploreCategoriesValues(plot.racine);
                if (fuzzySet == null) {
                    parseCategValNull = true;
                    errorMessage = errorMessage.concat("\nFatal Error: the file containing the 'categoriesValues' tag (fuzzy numbers) is erroneous or empty.");
                }
                if (categVal.getWarning() != "") {
                    warningMessage = warningMessage.concat("\n" + categVal.getWarning());
                }
                if (!parseCategValNull && statusParseMethod) {
                    String chartTitle = parseMethodParam.getChartTitle();
                    String XaxisLabel = parseMethodParam.getDomainAxisLabel();
                    String YaxisLabel = parseMethodParam.getRangeAxisLabel();
                    boolean color = parseMethodParam.getColor();
                    String encodedImage = "";
                    encodedImage = plot.generatedPlot(chartTitle, XaxisLabel, YaxisLabel, fuzzySet, color);
                    if (chartTitle.isEmpty()) {
                        chartTitle = "Fuzzy categories values plot";
                    }
                    FilePlotFuzzy outputFile = new FilePlotFuzzy();
                    outputFile.createFile(encodedImage, chartTitle);
                    String pathOutputFilePlot = argv[argv.length - 2];
                    outputFile.saveFile(pathOutputFilePlot);
                    StatusMessage xmcdaMess = new StatusMessage();
                    xmcdaMess.createLogMessage(warningMessage, errorMessage);
                    String pathOutputMessage = argv[argv.length - 1];
                    xmcdaMess.save(pathOutputMessage);
                } else {
                    StatusMessage xmcdaMess = new StatusMessage();
                    xmcdaMess.createErrorMessage(errorMessage);
                    String pathOutputMessage = argv[argv.length - 1];
                    xmcdaMess.save(pathOutputMessage);
                }
            }
        } else {
            StatusMessage xmcdaMess = new StatusMessage();
            xmcdaMess.createErrorMessage(errorMessage);
            String pathOutputMessage = argv[argv.length - 1];
            xmcdaMess.save(pathOutputMessage);
        }
    }
}

