/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.IOException;
import java.io.OutputStream;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.util.SortOrder;

public class PieChartPlot {
    private JFreeChart chart;

    public PieChartPlot(double[] ySeries, Color c1, Color c2, String chartTitle, String XaxisLabel, String YaxisLabel, String[] listIds, String[] listNames, String order, String maxMin) {
        int j;
        String[] columnKeys = new String[ySeries.length];
        int i = 0;
        while (i < ySeries.length) {
            columnKeys[i] = "";
            ++i;
        }
        i = 0;
        while (i < ySeries.length) {
            columnKeys[i] = order.equals("by id") ? (listNames[i] != null && listIds[i] != null ? "(" + listIds[i] + ") " + listNames[i] : listIds[i]) : (listNames[i] != null && listIds[i] != null ? String.valueOf(listNames[i]) + " (" + listIds[i] + ")" : listIds[i]);
            ++i;
        }
        if (order.equals("by id")) {
            i = 0;
            while (i < columnKeys.length - 1) {
                j = i + 1;
                while (j < columnKeys.length) {
                    if (maxMin.equals("increasing")) {
                        if (listIds[j].toLowerCase().compareTo(listIds[i].toLowerCase()) < 0) {
                            PieChartPlot.exchange(columnKeys, i, j);
                            PieChartPlot.exchange(ySeries, i, j);
                        }
                    } else if (listIds[j].toLowerCase().compareTo(listIds[i].toLowerCase()) > 0) {
                        PieChartPlot.exchange(columnKeys, i, j);
                        PieChartPlot.exchange(ySeries, i, j);
                    }
                    ++j;
                }
                ++i;
            }
        } else if (order.equals("by name")) {
            i = 0;
            while (i < columnKeys.length - 1) {
                j = i + 1;
                while (j < columnKeys.length) {
                    if (maxMin.equals("increasing")) {
                        if (listNames[j].toLowerCase().compareTo(listNames[i].toLowerCase()) < 0) {
                            PieChartPlot.exchange(columnKeys, i, j);
                            PieChartPlot.exchange(ySeries, i, j);
                        }
                    } else if (listNames[j].toLowerCase().compareTo(listNames[i].toLowerCase()) > 0) {
                        PieChartPlot.exchange(columnKeys, i, j);
                        PieChartPlot.exchange(ySeries, i, j);
                    }
                    ++j;
                }
                ++i;
            }
        } else if (order.equals("by values")) {
            i = 0;
            while (i < ySeries.length - 1) {
                j = i + 1;
                while (j < ySeries.length) {
                    if (maxMin.equals("increasing")) {
                        if (ySeries[j] < ySeries[i]) {
                            PieChartPlot.exchange(columnKeys, i, j);
                            PieChartPlot.exchange(ySeries, i, j);
                        }
                    } else if (ySeries[j] > ySeries[i]) {
                        PieChartPlot.exchange(columnKeys, i, j);
                        PieChartPlot.exchange(ySeries, i, j);
                    }
                    ++j;
                }
                ++i;
            }
        }
        DefaultPieDataset pieDataset = new DefaultPieDataset();
        int i2 = 0;
        while (i2 < ySeries.length) {
            pieDataset.setValue((Comparable)((Object)columnKeys[i2]), ySeries[i2]);
            ++i2;
        }
        if (order.equals("by name") || order.equals("by id")) {
            if (maxMin.equals("increasing")) {
                pieDataset.sortByKeys(SortOrder.ASCENDING);
            } else {
                pieDataset.sortByKeys(SortOrder.DESCENDING);
            }
        } else if (order.equals("by values")) {
            if (maxMin.equals("increasing")) {
                pieDataset.sortByValues(SortOrder.ASCENDING);
            } else {
                pieDataset.sortByValues(SortOrder.DESCENDING);
            }
        }
        this.chart = ChartFactory.createPieChart((String)chartTitle, (PieDataset)pieDataset, (boolean)false, (boolean)true, (boolean)false);
        this.chart.setBackgroundPaint((Paint)Color.white);
        PiePlot plot = (PiePlot)this.chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setCircular(true);
        plot.setLabelFont(new Font("Arial", 1, 12));
        Paint[] paint = new Paint[ySeries.length];
        int red1 = c1.getRed();
        int green1 = c1.getGreen();
        int blue1 = c1.getBlue();
        int red2 = c2.getRed();
        int green2 = c2.getGreen();
        int blue2 = c2.getBlue();
        int LARGEUR = ySeries.length;
        int i3 = 0;
        while (i3 < ySeries.length) {
            paint[i3] = new Color((red1 * (LARGEUR - i3) + red2 * i3) / LARGEUR, (green1 * (LARGEUR - i3) + green2 * i3) / LARGEUR, (blue1 * (LARGEUR - i3) + blue2 * i3) / LARGEUR);
            plot.setSectionPaint(i3, paint[i3]);
            ++i3;
        }
        plot.setLabelOutlinePaint(null);
        plot.setLabelShadowPaint(null);
        plot.setLabelBackgroundPaint((Paint)Color.WHITE);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setNoDataMessage("No data available");
    }

    protected static void exchange(String[] columnKeys, int i, int j) {
        String tempKey = columnKeys[j];
        columnKeys[j] = columnKeys[i];
        columnKeys[i] = tempKey;
    }

    protected static void exchange(double[] ySeries, int i, int j) {
        double tempVal = ySeries[j];
        ySeries[j] = ySeries[i];
        ySeries[i] = tempVal;
    }

    public void saveChart(OutputStream outputStream) {
        try {
            ChartUtilities.writeChartAsPNG((OutputStream)outputStream, (JFreeChart)this.chart, (int)500, (int)270);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

