/*
 * Decompiled with CFR 0.152.
 */
package eu.telecom_bretagne.xmcda;

import eu.telecom_bretagne.xmcda.Criteria;
import eu.telecom_bretagne.xmcda.Criterion;
import eu.telecom_bretagne.xmcda.CriterionValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class CriteriaValues
implements Iterable<CriterionValue> {
    private ArrayList<CriterionValue> criteriaValues = new ArrayList();

    public CriteriaValues add(CriterionValue criterionValue) {
        this.criteriaValues.add(criterionValue);
        return this;
    }

    public boolean remove(CriterionValue criterionValue) {
        return this.criteriaValues.remove(criterionValue);
    }

    public CriteriaValues filterBy(Criteria criteria) {
        CriteriaValues filtered = new CriteriaValues();
        for (CriterionValue criteriaValue : this.criteriaValues) {
            if (!criteria.contains(criteriaValue.getCriterion())) continue;
            filtered.add(criteriaValue);
        }
        return filtered;
    }

    public Criteria getCriteria() {
        Criteria criteria = new Criteria();
        for (CriterionValue criterionValue : this.criteriaValues) {
            criteria.add(criterionValue.getCriterion());
        }
        return criteria;
    }

    public ArrayList<String> getCriteriaIDs() {
        ArrayList<String> criteriaIDs = new ArrayList<String>();
        for (CriterionValue criterionValue : this.criteriaValues) {
            criteriaIDs.add(criterionValue.getCriterion().id());
        }
        return criteriaIDs;
    }

    public CriterionValue getCriterionValue(Criterion criterion) {
        for (CriterionValue criterionValue : this.criteriaValues) {
            if (!criterionValue.getCriterion().equals(criterion)) continue;
            return criterionValue;
        }
        return null;
    }

    public List<CriterionValue> getListCriteriaValues() {
        return Collections.unmodifiableList(this.criteriaValues);
    }

    public void printCriteriaValues() {
        System.out.println("These are the CriteriaValues:");
        int i = 0;
        while (i < this.criteriaValues.size()) {
            System.out.println("CriterionValue" + (i + 1) + ":\t" + "id = " + this.criteriaValues.get(i).getCriterion() + "\t, value = " + this.criteriaValues.get(i).getRealValue());
            ++i;
        }
    }

    public int size() {
        return this.criteriaValues.size();
    }

    @Override
    public Iterator<CriterionValue> iterator() {
        return Collections.unmodifiableList(this.criteriaValues).iterator();
    }
}

