/*
 * Decompiled with CFR 0.152.
 */
import eu.telecom_bretagne.xmcda.Alternative;
import eu.telecom_bretagne.xmcda.Alternatives;
import eu.telecom_bretagne.xmcda.Criteria;
import eu.telecom_bretagne.xmcda.Criterion;
import eu.telecom_bretagne.xmcda.JDOM_Alternatives;
import eu.telecom_bretagne.xmcda.JDOM_Criteria;
import eu.telecom_bretagne.xmcda.JDOM_PerformanceTable;
import eu.telecom_bretagne.xmcda.Main;
import eu.telecom_bretagne.xmcda.PerformanceTable;
import eu.telecom_bretagne.xmcda.XmcdaMessage;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;

public class DrawStarGraph {
    protected static Polygon starGraph(Point p, Dimension size, int numberOfCriter, float translation) {
        int[] abscissa = new int[numberOfCriter];
        int[] ordonates = new int[numberOfCriter];
        double delta = Math.PI * 2 / (double)numberOfCriter;
        double angle = 0.0;
        int i = 0;
        while (i < numberOfCriter) {
            angle = delta * (double)i + 1.5707963267948966;
            abscissa[i] = (int)((double)size.width * Math.cos(angle) + 0.5) + p.x;
            ordonates[i] = p.y - (int)((double)size.height * Math.sin(angle) + 0.5) + (int)translation;
            ++i;
        }
        return new Polygon(abscissa, ordonates, numberOfCriter);
    }

    protected static void drawLines(Graphics2D g, Point p, Dimension size, PerformanceTable perfTable, Color colorToUse, Alternative alternative, ArrayList<String> listTitlesCriteria, float translation, String[] parsePreferenceDirectin) {
        int numberOfCriter = perfTable.nbCriteria();
        int[] abscissa = new int[numberOfCriter];
        int[] ordonates = new int[numberOfCriter];
        double delta = Math.PI * 2 / (double)numberOfCriter;
        double angle = 0.0;
        int i = 0;
        while (i < numberOfCriter) {
            angle = delta * (double)i + 1.5707963267948966;
            abscissa[i] = (int)((double)size.width * Math.cos(angle) + 0.5) + p.x;
            ordonates[i] = p.y - (int)((double)size.height * Math.sin(angle) + 0.5);
            ++i;
        }
        Font fontText = new Font("Arial", 1, 12);
        g.setFont(fontText);
        int i2 = 0;
        while (i2 < numberOfCriter) {
            g.drawLine(p.x, p.y + (int)translation, abscissa[i2], ordonates[i2] + (int)translation);
            if (abscissa[i2] > p.x && ordonates[i2] <= p.y) {
                g.drawString(listTitlesCriteria.get(i2), abscissa[i2], (int)translation + ordonates[i2] - 10);
            } else if (abscissa[i2] > p.x && ordonates[i2] > p.y) {
                g.drawString(listTitlesCriteria.get(i2), abscissa[i2] + 5, (int)translation + ordonates[i2] + 10);
            } else if (abscissa[i2] < p.x && ordonates[i2] <= p.y) {
                g.drawString(listTitlesCriteria.get(i2), abscissa[i2] - 85, (int)translation + ordonates[i2] - 10);
            } else if (abscissa[i2] <= p.x && ordonates[i2] > p.y) {
                g.drawString(listTitlesCriteria.get(i2), abscissa[i2] - 100, (int)translation + ordonates[i2] - 5);
            } else if (abscissa[i2] == p.x && ordonates[i2] == 0) {
                g.drawString(listTitlesCriteria.get(i2), abscissa[i2] + 25, (int)translation + ordonates[i2] + 10);
            }
            ++i2;
        }
        if (numberOfCriter == 2) {
            g.drawLine(p.x - 5, p.y - 5 + (int)translation, p.x + 5, p.y + 5 + (int)translation);
            g.drawLine(p.x - 5, p.y + 5 + (int)translation, p.x + 5, p.y - 5 + (int)translation);
        }
        g.setColor(colorToUse);
        g.setStroke(new BasicStroke(3.0f));
        int[] abscissaPerfTable = new int[numberOfCriter];
        int[] ordonatesPerfTable = new int[numberOfCriter];
        List<Criterion> criteria = perfTable.criteria();
        int i3 = 0;
        while (i3 < numberOfCriter) {
            float min = DrawStarGraph.getMinimum(perfTable, criteria.get(i3));
            float max = DrawStarGraph.getMaximum(perfTable, criteria.get(i3));
            float courant = ((Float)perfTable.getValue(alternative, criteria.get(i3))).floatValue();
            if (abscissa[i3] != p.x) {
                float a = (float)((double)(max - min) / ((double)abscissa[i3] - (double)p.x));
                if (abscissa[i3] < p.x) {
                    a = -a;
                }
                abscissaPerfTable[i3] = abscissa[i3] > p.x ? (int)((double)p.x + (double)((courant - min) / a)) : (int)((double)p.x + (double)((courant - max) / a));
                float pente = (float)(((double)p.y - (double)ordonates[i3]) / ((double)p.x - (double)abscissa[i3]));
                ordonatesPerfTable[i3] = (int)((double)p.y + (double)((float)(abscissaPerfTable[i3] - p.x) * pente));
            } else {
                abscissaPerfTable[i3] = p.x;
                if (ordonates[i3] != p.y) {
                    float a = (float)((double)(max - min) / ((double)ordonates[i3] - (double)p.y));
                    if (ordonates[i3] < p.y) {
                        a = -a;
                    }
                    ordonatesPerfTable[i3] = ordonates[i3] > p.y ? (int)((double)p.y + (double)((courant - min) / a)) : (int)((double)p.y + (double)((courant - max) / a));
                } else {
                    ordonatesPerfTable[i3] = p.y;
                }
            }
            double abscissaMilieu = ((double)p.x + (double)abscissa[i3]) / 2.0;
            double ordonateMilieu = ((double)p.y + (double)ordonates[i3]) / 2.0;
            double symetrieX = 2.0 * abscissaMilieu - (double)abscissaPerfTable[i3];
            double symetrieY = 2.0 * ordonateMilieu - (double)ordonatesPerfTable[i3];
            if (abscissa[i3] < p.x || abscissa[i3] == p.x && ordonatesPerfTable[i3] > ordonates[i3] && ordonatesPerfTable[i3] <= p.y || abscissa[i3] == p.x && ordonatesPerfTable[i3] == ordonates[i3] && ordonatesPerfTable[i3] == 0) {
                abscissaPerfTable[i3] = (int)symetrieX;
                ordonatesPerfTable[i3] = (int)symetrieY;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < numberOfCriter) {
            if (parsePreferenceDirectin[i3].equals("min")) {
                double abscissaMilieu = ((double)p.x + (double)abscissa[i3]) / 2.0;
                double ordonateMilieu = ((double)p.y + (double)ordonates[i3]) / 2.0;
                double symetrieX = 2.0 * abscissaMilieu - (double)abscissaPerfTable[i3];
                double symetrieY = 2.0 * ordonateMilieu - (double)ordonatesPerfTable[i3];
                abscissaPerfTable[i3] = (int)symetrieX;
                ordonatesPerfTable[i3] = (int)symetrieY;
            }
            int n = i3++;
            ordonatesPerfTable[n] = (int)((float)ordonatesPerfTable[n] + translation);
        }
        Polygon testPoly = new Polygon(abscissaPerfTable, ordonatesPerfTable, numberOfCriter);
        g.drawPolygon(testPoly);
        int i4 = 0;
        while (i4 < numberOfCriter) {
            g.fillOval(abscissaPerfTable[i4] - 5, ordonatesPerfTable[i4] - 5, 10, 10);
            ++i4;
        }
    }

    protected static float getMaximum(PerformanceTable performanceTable, Criterion criterion) {
        float max = Float.NEGATIVE_INFINITY;
        for (Alternative alternative : performanceTable.alternatives()) {
            float v = ((Float)performanceTable.getValue(alternative, criterion)).floatValue();
            if (!(v > max)) continue;
            max = v;
        }
        return max;
    }

    protected static float getMinimum(PerformanceTable performanceTable, Criterion criterion) {
        float min = Float.POSITIVE_INFINITY;
        for (Alternative alternative : performanceTable.alternatives()) {
            float v = ((Float)performanceTable.getValue(alternative, criterion)).floatValue();
            if (!(v < min)) continue;
            min = v;
        }
        return min;
    }

    protected static ArrayList<String> getTitlesForMultiplePlots(Alternatives alter, List<String> listintersectionIds) {
        ArrayList<String> listintersectionTitles = new ArrayList<String>();
        int i = 0;
        while (i < listintersectionIds.size()) {
            if (alter.getIDs().contains(listintersectionIds.get(i))) {
                int index = alter.getIDs().indexOf(listintersectionIds.get(i));
                if (alter.getNames().get(index) != null) {
                    listintersectionTitles.add(String.valueOf(alter.getNames().get(index)) + " (" + listintersectionIds.get(i) + ")");
                } else {
                    listintersectionTitles.add(listintersectionIds.get(i));
                }
            }
            ++i;
        }
        return listintersectionTitles;
    }

    protected static ArrayList<String> getTitlesCriteria(Criteria criter, List<String> listintersectionIds) {
        ArrayList<String> listintersectionTitles = new ArrayList<String>();
        int i = 0;
        while (i < listintersectionIds.size()) {
            if (criter.getCriteriaIDs().contains(listintersectionIds.get(i))) {
                int index = criter.getCriteriaIDs().indexOf(listintersectionIds.get(i));
                if (criter.getListCriteriaNames().get(index) != null) {
                    listintersectionTitles.add(String.valueOf(criter.getListCriteriaNames().get(index)) + " (" + listintersectionIds.get(i) + ")");
                } else {
                    listintersectionTitles.add(listintersectionIds.get(i));
                }
            }
            ++i;
        }
        return listintersectionTitles;
    }

    protected static byte[] createStarGraph(PerformanceTable perfTable, Color colorToUse, String plotsOrganisation, ArrayList<String> listTitles, ArrayList<String> listTitlesCriteria, String order, String increaseDecrease, String[] parsePreferenceDirectin) {
        int numberOfCriter = perfTable.nbCriteria();
        int numberOfAlternatives = perfTable.nbAlternatives();
        int width = 450;
        int height = 320;
        float transaltion = 40.0f;
        ByteArrayOutputStream[] chart_png_image = new ByteArrayOutputStream[numberOfAlternatives];
        int indexAlternative = 0;
        while (indexAlternative < numberOfAlternatives) {
            Alternative alternative = perfTable.alternatives().get(indexAlternative);
            BufferedImage bi = new BufferedImage(width, height, 2);
            Graphics2D g = bi.createGraphics();
            g.setColor(Color.black);
            Font font = new Font("TimesRoman", 1, 20);
            g.setFont(font);
            Polygon p1 = DrawStarGraph.starGraph(new Point(width / 2, 130), new Dimension(130, 130), numberOfCriter, transaltion);
            Polygon p2 = DrawStarGraph.starGraph(new Point(width / 2, 130), new Dimension(65, 65), numberOfCriter, transaltion);
            g.drawPolygon(p1);
            g.drawPolygon(p2);
            chart_png_image[indexAlternative] = new ByteArrayOutputStream();
            DrawStarGraph.drawLines(g, new Point(width / 2, 130), new Dimension(130, 130), perfTable, colorToUse, alternative, listTitlesCriteria, transaltion, parsePreferenceDirectin);
            g.setColor(Color.black);
            Font fontText = new Font("Arial", 1, 16);
            g.setFont(fontText);
            String title = listTitles.get(indexAlternative);
            int abscissaTitle = width / 2 - 4 * title.length();
            g.drawString(String.valueOf(title) + ":", (float)abscissaTitle, transaltion / 2.0f);
            g.dispose();
            try {
                File file = File.createTempFile("starGraph_", ".png", new File(System.getProperty("java.io.tmpdir")));
                ImageIO.write((RenderedImage)bi, "PNG", file);
                FileInputStream input = new FileInputStream(file);
                BufferedImage image = ImageIO.read(input);
                ImageIO.write((RenderedImage)image, "png", chart_png_image[indexAlternative]);
                chart_png_image[indexAlternative].close();
                input.close();
                if (!file.delete()) {
                    System.err.println("Warning: " + file.getAbsolutePath() + " could not be deleted!");
                }
            }
            catch (IOException ie) {
                ie.printStackTrace();
            }
            ++indexAlternative;
        }
        DrawStarGraph.orderStarGraphs(order, increaseDecrease, perfTable.alternativesIDs(), listTitles, chart_png_image);
        InputStream[] inputStream = new InputStream[numberOfAlternatives];
        int i = 0;
        while (i < numberOfAlternatives) {
            inputStream[i] = new ByteArrayInputStream(chart_png_image[i].toByteArray());
            ++i;
        }
        String encodedImage = "";
        if (plotsOrganisation.equals("Line")) {
            return DrawStarGraph.convertImageByLine(inputStream, "png", numberOfAlternatives);
        }
        if (plotsOrganisation.equals("Column")) {
            return DrawStarGraph.convertImageByColumn(inputStream, "png", numberOfAlternatives);
        }
        if (plotsOrganisation.equals("Grid")) {
            return DrawStarGraph.convertImageByGrid(inputStream, "png", numberOfAlternatives);
        }
        return null;
    }

    protected static void orderStarGraphs(String order, String increaseDecrease, List<String> listAlternativeIDs, ArrayList<String> listTitles, ByteArrayOutputStream[] chart_png_image) {
        block12: {
            int i;
            String[] listNewTitles;
            int numberOfAlternatives;
            block11: {
                numberOfAlternatives = listAlternativeIDs.size();
                listNewTitles = new String[listTitles.size()];
                if (order.equals("by name")) {
                    i = 0;
                    while (i < listNewTitles.length) {
                        listNewTitles[i] = listTitles.get(i);
                        ++i;
                    }
                } else if (order.equals("by id")) {
                    i = 0;
                    while (i < listNewTitles.length) {
                        listNewTitles[i] = listAlternativeIDs.get(i);
                        ++i;
                    }
                }
                if (!increaseDecrease.equals("increasing")) break block11;
                i = 0;
                while (i < numberOfAlternatives - 1) {
                    int j = i + 1;
                    while (j < numberOfAlternatives) {
                        if (listNewTitles[j].toLowerCase().compareTo(listNewTitles[i].toLowerCase()) < 0) {
                            DrawStarGraph.exchange(chart_png_image, i, j);
                            DrawStarGraph.exchangeTitles(listNewTitles, i, j);
                        }
                        ++j;
                    }
                    ++i;
                }
                break block12;
            }
            if (!increaseDecrease.equals("decreasing")) break block12;
            i = 0;
            while (i < numberOfAlternatives - 1) {
                int j = i + 1;
                while (j < numberOfAlternatives) {
                    if (listNewTitles[j].toLowerCase().compareTo(listNewTitles[i].toLowerCase()) > 0) {
                        DrawStarGraph.exchange(chart_png_image, i, j);
                        DrawStarGraph.exchangeTitles(listNewTitles, i, j);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    protected static void orderMultipleStarGraphs(String order, String increaseDecrease, List<String> listAlternativeIDs, List<String> listTitles, byte[][] chart_png_image) {
        block12: {
            int i;
            String[] listNewTitles;
            int numberOfAlternatives;
            block11: {
                numberOfAlternatives = listAlternativeIDs.size();
                listNewTitles = new String[listTitles.size()];
                if (order.equals("by name")) {
                    i = 0;
                    while (i < listNewTitles.length) {
                        listNewTitles[i] = listTitles.get(i);
                        ++i;
                    }
                } else if (order.equals("by id")) {
                    i = 0;
                    while (i < listNewTitles.length) {
                        listNewTitles[i] = listAlternativeIDs.get(i);
                        ++i;
                    }
                }
                if (!increaseDecrease.equals("increasing")) break block11;
                i = 0;
                while (i < numberOfAlternatives - 1) {
                    int j = i + 1;
                    while (j < numberOfAlternatives) {
                        if (listNewTitles[j].toLowerCase().compareTo(listNewTitles[i].toLowerCase()) < 0) {
                            DrawStarGraph.exchangeImages(chart_png_image, i, j);
                            DrawStarGraph.exchangeTitles(listNewTitles, i, j);
                        }
                        ++j;
                    }
                    ++i;
                }
                break block12;
            }
            if (!increaseDecrease.equals("decreasing")) break block12;
            i = 0;
            while (i < numberOfAlternatives - 1) {
                int j = i + 1;
                while (j < numberOfAlternatives) {
                    if (listNewTitles[j].toLowerCase().compareTo(listNewTitles[i].toLowerCase()) > 0) {
                        DrawStarGraph.exchangeImages(chart_png_image, i, j);
                        DrawStarGraph.exchangeTitles(listNewTitles, i, j);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    protected static void exchange(ByteArrayOutputStream[] chart_png_image, int i, int j) {
        ByteArrayOutputStream temp = chart_png_image[j];
        chart_png_image[j] = chart_png_image[i];
        chart_png_image[i] = temp;
    }

    protected static void exchangeImages(byte[][] images, int i, int j) {
        byte[] temp = images[j];
        images[j] = images[i];
        images[i] = temp;
    }

    protected static void exchangeTitles(String[] titles, int i, int j) {
        String temp = titles[j];
        titles[j] = titles[i];
        titles[i] = temp;
    }

    protected static byte[] convertImageByLine(InputStream[] inputStream, String format, int size) {
        String encodedImage = "";
        BufferedImage[] images = new BufferedImage[size];
        int i = 0;
        while (i < size) {
            try {
                images[i] = ImageIO.read(inputStream[i]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        int w = images[0].getWidth();
        int i2 = 1;
        while (i2 < size) {
            w += images[i2].getWidth();
            ++i2;
        }
        int h = images[0].getHeight();
        int i3 = 1;
        while (i3 < size) {
            if (images[i3].getHeight() > h) {
                h = images[i3].getHeight();
            }
            ++i3;
        }
        BufferedImage combined = new BufferedImage(w, h, 2);
        Graphics g = combined.getGraphics();
        int x = 0;
        int y = 0;
        int i4 = 0;
        while (i4 < size) {
            g.drawImage(images[i4], x, y, null);
            x += images[i4].getWidth();
            ++i4;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)combined, format, baos);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    protected static byte[] convertImageByColumn(InputStream[] inputStream, String format, int size) {
        String encodedImage = "";
        BufferedImage[] images = new BufferedImage[size];
        int i = 0;
        while (i < size) {
            try {
                images[i] = ImageIO.read(inputStream[i]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        int w = images[0].getWidth();
        int i2 = 1;
        while (i2 < size) {
            if (images[i2].getWidth() > w) {
                w = images[i2].getWidth();
            }
            ++i2;
        }
        int h = images[0].getHeight();
        int i3 = 1;
        while (i3 < size) {
            h += images[i3].getHeight();
            ++i3;
        }
        BufferedImage combined = new BufferedImage(w, h, 2);
        Graphics g = combined.getGraphics();
        int x = 0;
        int y = 0;
        int i4 = 0;
        while (i4 < size) {
            g.drawImage(images[i4], x, y, null);
            y += images[i4].getHeight();
            ++i4;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)combined, format, baos);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    protected static byte[] convertImageByGrid(InputStream[] inputStream, String format, int size) {
        BufferedImage[] images = new BufferedImage[size];
        int i = 0;
        while (i < size) {
            try {
                images[i] = ImageIO.read(inputStream[i]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        int maxNumberOfImagesByLine = (int)Math.ceil(Math.sqrt(size));
        int w = images[0].getWidth();
        int i2 = 1;
        while (i2 < size) {
            if (images[i2].getWidth() > w) {
                w = images[i2].getWidth();
            }
            ++i2;
        }
        int maxWidth = w;
        w *= maxNumberOfImagesByLine;
        int h = images[0].getHeight();
        int i3 = 1;
        while (i3 < size) {
            if (images[i3].getHeight() > h) {
                h = images[i3].getHeight();
            }
            ++i3;
        }
        int maxHeight = h;
        BufferedImage combined = new BufferedImage(w, h *= maxNumberOfImagesByLine, 2);
        Graphics g = combined.getGraphics();
        int x = 0;
        int y = 0;
        int i4 = 0;
        while (i4 < size) {
            g.drawImage(images[i4], x, y, null);
            if ((x += maxWidth) >= w) {
                x = 0;
                y += maxHeight;
            }
            ++i4;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)combined, format, baos);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            ImageIO.write((RenderedImage)combined, format, baos);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    protected static byte[] createMultipleStarGraph(PerformanceTable perfTable, Color colorToUse, Alternative alternative, String title, ArrayList<String> listTitlesCriteria, String[] parsePreferenceDirectin) {
        int numberOfCriter = perfTable.nbCriteria();
        int width = 450;
        int height = 320;
        BufferedImage bi = new BufferedImage(width, height, 2);
        Graphics2D g = bi.createGraphics();
        g.setColor(Color.black);
        Font font = new Font("TimesRoman", 1, 20);
        g.setFont(font);
        int transaltion = 40;
        Polygon p1 = DrawStarGraph.starGraph(new Point(width / 2, 130), new Dimension(130, 130), numberOfCriter, transaltion);
        Polygon p2 = DrawStarGraph.starGraph(new Point(width / 2, 130), new Dimension(65, 65), numberOfCriter, transaltion);
        g.drawPolygon(p1);
        g.drawPolygon(p2);
        DrawStarGraph.drawLines(g, new Point(width / 2, 130), new Dimension(130, 130), perfTable, colorToUse, alternative, listTitlesCriteria, transaltion, parsePreferenceDirectin);
        g.setColor(Color.black);
        Font fontText = new Font("Arial", 1, 16);
        g.setFont(fontText);
        int abscissaTitle = width / 2 - 4 * title.length();
        g.drawString(String.valueOf(title) + ":", abscissaTitle, transaltion / 2);
        g.dispose();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bi, "PNG", baos);
            baos.close();
            return baos.toByteArray();
        }
        catch (IOException ie) {
            ie.printStackTrace();
            return null;
        }
    }

    protected static Color getColorFromOptions(boolean black_and_white, String colorToUse) {
        Color color = Color.black;
        if (black_and_white) {
            return color;
        }
        Color c = null;
        try {
            c = (Color)Color.class.getField(colorToUse.toLowerCase()).get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (c == null) {
            return color;
        }
        color = c;
        return color;
    }

    public static void main(String[] argv) {
        boolean stopRunning = false;
        String tempErrorMessage = "";
        String warningMessage = "";
        if (argv.length != 6) {
            System.err.println("Usage: alternatives.xml criteria.xml performanceTable.xml parameters.xml performanceTable.png messages.xml");
            System.err.println("       The 4 first files are inputs, the remaining ones are outputs");
            System.exit(-1);
        }
        if (!(new File(argv[0]).exists() && new File(argv[1]).exists() && new File(argv[2]).exists() && new File(argv[3]).exists())) {
            stopRunning = true;
        }
        if (stopRunning) {
            tempErrorMessage = "Error: unable to run the algorithm. Reason: missing one (or more) entry file(s). Please check your entry files.";
        }
        if (!stopRunning) {
            Main mainFunction = new Main();
            PerformanceTable test = new PerformanceTable();
            String pathAlternatives = argv[0];
            String pathCriteria = argv[1];
            String pathPerfTable = argv[2];
            String pathOptions = argv[3];
            String errParam = mainFunction.checkEntryFile(pathOptions);
            String errAltern = mainFunction.checkEntryFile(pathAlternatives);
            String errCriter = mainFunction.checkEntryFile(pathCriteria);
            String errPerfTable = mainFunction.checkEntryFile(pathPerfTable);
            if (errParam != "") {
                tempErrorMessage = tempErrorMessage.concat("\nFatal Error: the file containing the methodParameters tag is not a valid XMCDA document.");
            }
            if (errAltern != "") {
                tempErrorMessage = tempErrorMessage.concat("\nFatal Error: the file containing the alternatives tag is not a valid XMCDA document.");
            }
            if (errCriter != "") {
                tempErrorMessage = tempErrorMessage.concat("\nFatal Error: the file containing the criteria tag is not a valid XMCDA document.");
            }
            if (errPerfTable != "") {
                tempErrorMessage = tempErrorMessage.concat("\nFatal Error: the file containing the performanceTable tag is not a valid XMCDA document.");
            }
            if (errParam != "" || errAltern != "" || errCriter != "" || errPerfTable != "") {
                XmcdaMessage xmcdaMess = new XmcdaMessage();
                xmcdaMess.createErrorMessage(tempErrorMessage);
                String pathOutputMessage = argv[argv.length - 1];
                xmcdaMess.enregistre(pathOutputMessage);
            } else {
                OptionsParameters parseMethodParam = new OptionsParameters();
                mainFunction.PrepareParsing(pathOptions);
                boolean statusParseMethod = parseMethodParam.parse(mainFunction.getRacine());
                if (parseMethodParam.getWarning() != "") {
                    warningMessage = warningMessage.concat(parseMethodParam.getWarning());
                }
                if (!statusParseMethod) {
                    tempErrorMessage = tempErrorMessage.equals("") ? "\nFatal error: the file containing the methodParameters tag is erroneous or empty." : tempErrorMessage.concat("\nFatal Error: the file containing the methodParameters tag is erroneous or empty.");
                }
                boolean uniquePlot = parseMethodParam.getUniquePlot();
                String plotsOrganisation = parseMethodParam.getPlotsOrganisation();
                boolean colorBoolean = parseMethodParam.getColor();
                String colorFromOptions = parseMethodParam.getColorToUse();
                Color colorToUse = DrawStarGraph.getColorFromOptions(!colorBoolean, colorFromOptions);
                String order = parseMethodParam.getOrder();
                String maxMin = parseMethodParam.getIncreaseDecreaseOrder();
                boolean prefDirec = parseMethodParam.getPrefDirection();
                JDOM_Criteria jdomCriter = new JDOM_Criteria();
                mainFunction.PrepareParsing(pathCriteria);
                boolean parseCriterNull = false;
                Criteria criter = jdomCriter.parseCriteriaXML(mainFunction.getRacine());
                String[] parsePreferenceDirectin = null;
                if (criter != null) {
                    parsePreferenceDirectin = new String[criter.getCriteriaIDs().size()];
                    int i = 0;
                    while (i < criter.getCriteriaIDs().size()) {
                        parsePreferenceDirectin[i] = "max";
                        ++i;
                    }
                }
                if (prefDirec && criter != null) {
                    parsePreferenceDirectin = new String[criter.getCriteriaIDs().size()];
                    int idx = 0;
                    LinkedHashMap<Criterion, String> m = jdomCriter.exploreCriteriaXML(mainFunction.getRacine(), criter);
                    Set<Criterion> s = m.keySet();
                    for (Criterion c : s) {
                        parsePreferenceDirectin[idx++] = m.get(c);
                    }
                }
                if (jdomCriter.getWarning() != "") {
                    warningMessage = warningMessage.equals("") ? "\n" + jdomCriter.getWarning() : warningMessage.concat("\n" + jdomCriter.getWarning());
                }
                if (criter == null) {
                    parseCriterNull = true;
                    tempErrorMessage = tempErrorMessage.equals("") ? "\nFatal Error: the file containing the criteria tag is erroneous or empty." : tempErrorMessage.concat("\nFatal Error: the file containing the criteria tag is erroneous or empty.");
                }
                mainFunction.PrepareParsing(pathAlternatives);
                JDOM_Alternatives jdomAlter = new JDOM_Alternatives();
                boolean parseAlternativesNull = false;
                Alternatives alter = jdomAlter.exploreAlternativesXML(mainFunction.getRacine());
                if (jdomAlter.getWarning() != "") {
                    warningMessage = warningMessage.equals("") ? "\n" + jdomAlter.getWarning() : warningMessage.concat("\n" + jdomAlter.getWarning());
                }
                if (alter == null) {
                    parseAlternativesNull = true;
                    tempErrorMessage = tempErrorMessage.equals("") ? "\nFatal Error: the file containing the alternatives tag is erroneous or empty." : tempErrorMessage.concat("\nFatal Error: the file containing the alternatives tag is erroneous or empty.");
                }
                mainFunction.PrepareParsing(pathPerfTable);
                JDOM_PerformanceTable jdomPerfTable = new JDOM_PerformanceTable();
                boolean parsePerfTableNull = false;
                PerformanceTable perfTable = jdomPerfTable.explorePerformanceTable(mainFunction.getRacine());
                if (jdomPerfTable.getErrorMessage() != "") {
                    warningMessage = warningMessage.concat("\n" + jdomPerfTable.getErrorMessage());
                }
                if (jdomPerfTable.getWarningMessage() != "") {
                    warningMessage = warningMessage.concat(jdomPerfTable.getWarningMessage());
                }
                if (perfTable == null) {
                    parsePerfTableNull = true;
                    tempErrorMessage = tempErrorMessage.equals("") ? "\nFatal Error: the file containing the performanceTable tag is erroneous or empty." : tempErrorMessage.concat("\nFatal Error: the file containing the performanceTable tag is erroneous or empty.");
                }
                if (!parseCriterNull && !parseAlternativesNull && !parsePerfTableNull && statusParseMethod) {
                    test = mainFunction.run(perfTable, criter, alter);
                    warningMessage = warningMessage.concat(mainFunction.getWarningMessage());
                    tempErrorMessage = mainFunction.getErrorMessage();
                    byte[][] encodedImage = new byte[perfTable.alternativesIDs().size()][];
                    if (test.nbAlternatives() != 0 && test.nbCriteria() != 0) {
                        String pathOutputFile = argv[4];
                        FileStarGraph outputFile = new FileStarGraph();
                        ArrayList<String> listTitlesCriteria = DrawStarGraph.getTitlesCriteria(criter, test.criteriaIDs());
                        ArrayList<String> listTitles = DrawStarGraph.getTitlesForMultiplePlots(alter, test.alternativesIDs());
                        if (!uniquePlot) {
                            int i = 0;
                            while (i < perfTable.alternativesIDs().size()) {
                                Alternative alternative = perfTable.alternatives().get(i);
                                encodedImage[i] = DrawStarGraph.createMultipleStarGraph(test, colorToUse, alternative, listTitles.get(i), listTitlesCriteria, parsePreferenceDirectin);
                                ++i;
                            }
                            String template = String.valueOf(pathOutputFile.substring(0, pathOutputFile.indexOf(46))) + "-%02d.png";
                            DrawStarGraph.orderMultipleStarGraphs(order, maxMin, perfTable.alternativesIDs(), listTitles, encodedImage);
                            outputFile.createFileMultiplePlots(test.alternativesIDs(), encodedImage, template);
                        } else {
                            byte[] image = DrawStarGraph.createStarGraph(test, colorToUse, plotsOrganisation, listTitles, listTitlesCriteria, order, maxMin, parsePreferenceDirectin);
                            outputFile.createFile(test.alternativesIDs(), image, new File(pathOutputFile));
                        }
                        StatusMessage xmcdaMess = new StatusMessage();
                        xmcdaMess.createLogMessage(warningMessage, tempErrorMessage);
                        String pathOutputMessage = argv[argv.length - 1];
                        xmcdaMess.save(pathOutputMessage);
                    } else {
                        tempErrorMessage = tempErrorMessage.concat("\n We cannot run the algorithm since the criteria list or the alternatives list of the PROJECT is empty.\n");
                        StatusMessage xmcdaMess = new StatusMessage();
                        xmcdaMess.createErrorMessage(tempErrorMessage);
                        String pathOutputMessage = argv[argv.length - 1];
                        xmcdaMess.save(pathOutputMessage);
                    }
                } else {
                    StatusMessage xmcdaMess = new StatusMessage();
                    xmcdaMess.createErrorMessage(tempErrorMessage);
                    String pathOutputMessage = argv[argv.length - 1];
                    xmcdaMess.save(pathOutputMessage);
                }
            }
        } else {
            StatusMessage xmcdaMess = new StatusMessage();
            xmcdaMess.createErrorMessage(tempErrorMessage);
            String pathOutputMessage = argv[argv.length - 1];
            xmcdaMess.save(pathOutputMessage);
        }
    }
}

