/*
 * Decompiled with CFR 0.152.
 */
package eu.telecom_bretagne.xmcda;

import eu.telecom_bretagne.xmcda.Alternative;
import eu.telecom_bretagne.xmcda.Criterion;
import eu.telecom_bretagne.xmcda.PerformanceTable;
import java.io.File;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class JDOM_PerformanceTable {
    static Document document;
    PerformanceTable perfTable = new PerformanceTable();
    private String errorMessage = "";
    private String warningMessage = "";

    public Element getRacine(String path) {
        try {
            SAXBuilder sxb = new SAXBuilder();
            document = sxb.build(new File(path));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return document.getRootElement();
    }

    public PerformanceTable explorePerformanceTable(Element racine) {
        if (racine.getChild("performanceTable") == null) {
            return null;
        }
        Element perfTable_xml = racine.getChild("performanceTable");
        if (perfTable_xml.getChildren("alternativePerformances") == null) {
            return null;
        }
        for (Element courant : perfTable_xml.getChildren("alternativePerformances")) {
            Alternative alternative = new Alternative(courant.getChild("alternativeID").getValue());
            this.perfTable.addAlternative(alternative, true);
            boolean alternativeIDOK = true;
            for (Element performance : courant.getChildren("performance")) {
                String value = "";
                if (performance.getChild("value").getChild("real") != null) {
                    value = performance.getChild("value").getChild("real").getValue();
                } else if (performance.getChild("value").getChild("integer") != null) {
                    value = performance.getChild("value").getChild("integer").getValue();
                } else {
                    alternativeIDOK = false;
                }
                Criterion criterion = new Criterion(performance.getChild("criterionID").getValue());
                this.perfTable.addCriterion(criterion, true);
                value = value.trim();
                if (value.length() == 0) continue;
                this.perfTable.setValue(alternative, criterion, Float.valueOf(Float.parseFloat(value)));
            }
            if (alternativeIDOK) continue;
            this.perfTable.removeAlternative(alternative);
            this.errorMessage = this.errorMessage.concat("Error in the file containing the performance table tag. The value is neither real nor integer.We have eliminated the corresponding alternative:" + alternative.id() + ".");
        }
        for (Alternative alternative : this.perfTable.alternatives()) {
            for (Criterion criterion : this.perfTable.criteria()) {
                if (this.perfTable.isSet(alternative, criterion)) continue;
                this.perfTable.removeAlternative(alternative);
                this.warningMessage = this.warningMessage.concat("\nThe alternativeID " + alternative.id() + " was removed because there are missing values");
            }
        }
        return this.perfTable;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }
}

