/*
 * Decompiled with CFR 0.152.
 */
package jrmp.srmp.base;

import com.google.common.io.Files;
import com.google.common.io.OutputSupplier;
import java.io.File;
import java.io.IOException;
import java.util.List;
import jrmp.srmp.base.XSRMPmodeler;
import jrmp.srmp.settings.Config;
import jrmp.srmp.utils.OutputUtils;
import jrmp.srmp.utils.PreDef;
import jrmp.srmp.utils.RankingUtils;
import org.apache.xmlbeans.XmlObject;
import org.decision_deck.jmcda.structure.Alternative;
import org.decision_deck.jmcda.structure.Criterion;
import org.decision_deck.jmcda.structure.matrix.EvaluationsRead;
import org.decision_deck.utils.relation.graph.Preorder;
import org.decisiondeck.jmcda.persist.xmcda2.XMCDAAlternatives;
import org.decisiondeck.jmcda.persist.xmcda2.XMCDAAlternativesMatrix;
import org.decisiondeck.jmcda.persist.xmcda2.XMCDACriteria;
import org.decisiondeck.jmcda.persist.xmcda2.XMCDAEvaluations;
import org.decisiondeck.jmcda.persist.xmcda2.generated.XAlternativeOnCriteriaPerformances;
import org.decisiondeck.jmcda.persist.xmcda2.generated.XAlternativeValue;
import org.decisiondeck.jmcda.persist.xmcda2.generated.XAlternatives;
import org.decisiondeck.jmcda.persist.xmcda2.generated.XAlternativesComparisons;
import org.decisiondeck.jmcda.persist.xmcda2.generated.XAlternativesValues;
import org.decisiondeck.jmcda.persist.xmcda2.generated.XCriteria;
import org.decisiondeck.jmcda.persist.xmcda2.generated.XCriteriaValues;
import org.decisiondeck.jmcda.persist.xmcda2.generated.XCriterionValue;
import org.decisiondeck.jmcda.persist.xmcda2.generated.XMCDADoc;
import org.decisiondeck.jmcda.persist.xmcda2.generated.XPerformanceTable;
import org.decisiondeck.jmcda.persist.xmcda2.generated.XValue;
import org.decisiondeck.jmcda.persist.xmcda2.utils.XMCDAWriteUtils;

public class XSRMPwriter
extends XSRMPmodeler {
    private String filePath;

    public XSRMPwriter() {
        this.setStatus(XSRMPmodeler.Status.initialized);
        this.setOutputPath(Config.OUTPUT_FOLDER);
    }

    public XSRMPwriter(XSRMPmodeler model) {
        super(model);
        this.setStatus(XSRMPmodeler.Status.overwritten);
        this.setOutputPath(Config.OUTPUT_FOLDER);
    }

    public Integer write() throws IOException {
        OutputUtils.consoleln("\n[Exporting Process]");
        OutputUtils.lsln("\n *** Files Exporting *** \n");
        int re = 0;
        re += this.exportAlternatives(false).intValue();
        re += this.exportCriteria(false).intValue();
        re += this.exportEvaluations(false).intValue();
        re += this.exportPairComps(false).intValue();
        re += this.exportWeights(false).intValue();
        re += this.exportRefPts(false).intValue();
        OutputUtils.lscln("[i] " + (re += this.exportRanking(false).intValue()) + "/7 files have been exported.");
        OutputUtils.lsln("[i] Exporting completed!");
        return re;
    }

    public Integer write(boolean display) throws IOException {
        OutputUtils.consoleln("\n[Exporting Process]");
        OutputUtils.lsln("\n *** Files Exporting *** \n");
        int re = 0;
        re += this.exportAlternatives(display).intValue();
        re += this.exportCriteria(display).intValue();
        re += this.exportEvaluations(display).intValue();
        re += this.exportPairComps(display).intValue();
        re += this.exportWeights(display).intValue();
        re += this.exportRefPts(display).intValue();
        OutputUtils.lscln("[i] " + (re += this.exportRanking(display).intValue()) + "/7 files have been exported.");
        OutputUtils.lsln("[i] Exporting completed!");
        return re;
    }

    public Integer write(String path) throws IOException {
        this.setOutputPath(path);
        OutputUtils.consoleln("\n[Exporting Process]");
        OutputUtils.lsln("\n *** Files Exporting *** \n");
        int re = 0;
        re += this.exportAlternatives(false).intValue();
        re += this.exportCriteria(false).intValue();
        re += this.exportEvaluations(false).intValue();
        re += this.exportPairComps(false).intValue();
        re += this.exportWeights(false).intValue();
        re += this.exportRefPts(false).intValue();
        OutputUtils.lscln("[i] " + (re += this.exportRanking(false).intValue()) + "/7 files have been exported.");
        OutputUtils.lsln("[i] Exporting completed!");
        return re;
    }

    public void writeModel(boolean display) throws IOException {
        OutputUtils.consoleln("\n[Exporting Process]");
        OutputUtils.lsln("\n *** Files Exporting *** \n");
        int re = 0;
        re += this.exportRefPts(display).intValue();
        OutputUtils.lscln("[i] " + (re += this.exportWeights(display).intValue()) + "/2 files have been exported.");
        OutputUtils.lscln("[i] Exporting completed!");
    }

    public void writeRanking(boolean display) throws IOException {
        OutputUtils.consoleln("\n[Exporting Process]");
        OutputUtils.lsln("\n *** Files Exporting *** \n");
        this.exportRanking(display);
        OutputUtils.lscln("[i] Only ranking.xml has been exported.");
        OutputUtils.lscln("[i] Exporting completed!");
    }

    public void writePreorder(boolean display) throws IOException {
        OutputUtils.consoleln("\n[Exporting Process]");
        OutputUtils.lsln("\n *** Files Exporting *** \n");
        this.exportPreorder(display);
        OutputUtils.lscln("[i] Only preorder.xml has been exported.");
        OutputUtils.lscln("[i] Exporting completed!");
    }

    public Integer writeAsInputs(boolean displayRanking) throws IOException {
        String ini = this.getFilePath();
        this.setFilePath("/" + Config.DEFAULT_EXP_NAME + "/inputs");
        OutputUtils.consoleln("\n[Exporting Process]");
        OutputUtils.lsln("\n *** Files Exporting *** \n");
        int re = 0;
        re += this.exportAlternatives(false).intValue();
        re += this.exportCriteria(false).intValue();
        re += this.exportEvaluations(false).intValue();
        re += this.exportPairComps(false).intValue();
        re += this.exportWeights(false).intValue();
        re += this.exportRefPts(false).intValue();
        OutputUtils.lscln("[i] " + (re += this.exportRanking(displayRanking).intValue()) + "/7 files have been exported.");
        OutputUtils.lsln("[i] Exporting completed!");
        this.setFilePath(ini);
        return re;
    }

    public Integer exportAlternatives(boolean display) throws IOException {
        String fileName = "/" + PreDef.FileName.alternatives.toString() + ".xml";
        File file = new File(String.valueOf(Config.RESOURCES_FOLDER) + this.filePath + fileName);
        OutputUtils.lc("[i] Exporting " + this.filePath + fileName + "...");
        if (Config.OVERWRITE_INTERACT_OPTION && file.exists()) {
            System.in.skip(System.in.available());
            OutputUtils.lc("File exists. Overwrite? (y/n):");
            char re = (char)System.in.read();
            OutputUtils.logln(Character.valueOf(re));
            if (re == 'y') {
                OutputUtils.lc("[i] Overwriting " + this.filePath + fileName + "...");
            } else {
                if (re == 'n') {
                    OutputUtils.lcln("[i] Exporting " + this.filePath + fileName + "... Aborted.");
                    return 0;
                }
                this.exportAlternatives(display);
                return 0;
            }
        }
        if (this.getAlteSet() != null) {
            OutputSupplier outputStream = Files.newOutputStreamSupplier((File)file);
            XMCDAAlternatives writerAlternative = new XMCDAAlternatives();
            writerAlternative.setNames(this.getAlteNames());
            XAlternatives xAlternatives = writerAlternative.writeAlternatives(this.getAlteSet(), null);
            XMCDAWriteUtils.write((XmlObject)xAlternatives, (OutputSupplier)outputStream, (boolean)true);
            OutputUtils.lcln("OK!");
            OutputUtils.logln("[i] " + fileName.substring(1) + " has been successfully exported!");
            if (display) {
                this.displayAlternatives();
            } else {
                this.outputAlternatives();
            }
            return 1;
        }
        OutputUtils.lcln("Nothing to export.");
        return 0;
    }

    public Integer exportCriteria(boolean display) throws IOException {
        String fileName = "/" + PreDef.FileName.criteria.toString() + ".xml";
        File file = new File(String.valueOf(Config.RESOURCES_FOLDER) + this.filePath + fileName);
        OutputUtils.lc("[i] Exporting " + this.filePath + fileName + "...");
        if (Config.OVERWRITE_INTERACT_OPTION && file.exists()) {
            System.in.skip(System.in.available());
            OutputUtils.lc("File exists. Overwrite? (y/n):");
            char re = (char)System.in.read();
            OutputUtils.logln(Character.valueOf(re));
            if (re == 'y') {
                OutputUtils.lc("[i] Overwriting " + this.filePath + fileName + "...");
            } else {
                if (re == 'n') {
                    OutputUtils.lcln("[i] Exporting " + this.filePath + fileName + "... Aborted.");
                    return 0;
                }
                this.exportCriteria(display);
                return 0;
            }
        }
        if (this.getCritSet() != null) {
            OutputSupplier outputStream = Files.newOutputStreamSupplier((File)file);
            XMCDACriteria writerCriteria = new XMCDACriteria();
            writerCriteria.setScales(this.getCritScales());
            writerCriteria.setNames(this.getCritNames());
            XCriteria xCriteria = writerCriteria.write(this.getCritSet());
            XMCDAWriteUtils.write((XmlObject)xCriteria, (OutputSupplier)outputStream, (boolean)true);
            OutputUtils.lcln("OK!");
            OutputUtils.logln("[i] " + fileName.substring(1) + " has been successfully exported!");
            if (display) {
                this.displayCriteria();
            } else {
                this.outputCriteria();
            }
            return 1;
        }
        OutputUtils.lcln("Nothing to export.");
        return 0;
    }

    public Integer exportWeights(boolean display) throws IOException {
        String fileName = "/" + PreDef.FileName.weights.toString() + ".xml";
        File file = new File(String.valueOf(Config.RESOURCES_FOLDER) + this.filePath + fileName);
        OutputUtils.lc("[i] Exporting " + this.filePath + fileName + "...");
        if (Config.OVERWRITE_INTERACT_OPTION && file.exists()) {
            System.in.skip(System.in.available());
            OutputUtils.lc("File exists. Overwrite? (y/n):");
            char re = (char)System.in.read();
            OutputUtils.logln(Character.valueOf(re));
            if (re == 'y') {
                OutputUtils.lc("[i] Overwriting " + this.filePath + fileName + "...");
            } else {
                if (re == 'n') {
                    OutputUtils.lcln("[i] Exporting " + this.filePath + fileName + "... Aborted.");
                    return 0;
                }
                this.exportWeights(display);
                return 0;
            }
        }
        if (this.getWeights() != null) {
            OutputSupplier outputStream = Files.newOutputStreamSupplier((File)file);
            XCriteriaValues xCriteriaVals = XMCDADoc.XMCDA.Factory.newInstance().addNewCriteriaValues();
            for (Criterion crit : this.getWeights().keySet()) {
                XCriterionValue xCritVal = xCriteriaVals.addNewCriterionValue();
                xCritVal.setCriterionID(crit.getId());
                XValue xVal = xCritVal.addNewValue();
                xVal.setReal(new Float(this.getWeights().get(crit)).floatValue());
            }
            XMCDAWriteUtils.write((XmlObject)xCriteriaVals, (OutputSupplier)outputStream, (boolean)true);
            OutputUtils.lcln("OK!");
            OutputUtils.logln("[i] " + fileName.substring(1) + " has been successfully exported!");
            if (display) {
                this.displayWeights();
            } else {
                this.outputWeights();
            }
            return 1;
        }
        OutputUtils.lcln("Nothing to export.");
        return 0;
    }

    public Integer exportEvaluations(boolean display) throws IOException {
        String fileName = "/" + PreDef.FileName.performanceTable.toString() + ".xml";
        File file = new File(String.valueOf(Config.RESOURCES_FOLDER) + this.filePath + fileName);
        OutputUtils.lc("[i] Exporting " + this.filePath + fileName + "...");
        if (Config.OVERWRITE_INTERACT_OPTION && file.exists()) {
            System.in.skip(System.in.available());
            OutputUtils.lc("File exists. Overwrite? (y/n):");
            char re = (char)System.in.read();
            OutputUtils.logln(Character.valueOf(re));
            if (re == 'y') {
                OutputUtils.lc("[i] Overwriting " + this.filePath + fileName + "...");
            } else {
                if (re == 'n') {
                    OutputUtils.lcln("[i] Exporting " + this.filePath + fileName + "... Aborted.");
                    return 0;
                }
                this.exportEvaluations(display);
                return 0;
            }
        }
        if (this.getAlteValues() != null) {
            OutputSupplier outputStream = Files.newOutputStreamSupplier((File)file);
            XMCDAEvaluations writerEva = new XMCDAEvaluations();
            XPerformanceTable xEva = writerEva.write((EvaluationsRead)this.getAlteValues());
            XMCDAWriteUtils.write((XmlObject)xEva, (OutputSupplier)outputStream, (boolean)true);
            OutputUtils.lcln("OK!");
            OutputUtils.logln("[i] " + fileName.substring(1) + " has been successfully exported!");
            if (display) {
                this.displayEvaluations();
            } else {
                this.outputEvaluations();
            }
            return 1;
        }
        OutputUtils.lcln("Nothing to export.");
        return 0;
    }

    public Integer exportRefPts(boolean display) throws IOException {
        String fileName = "/" + PreDef.FileName.profileConfigs.toString() + ".xml";
        File file = new File(String.valueOf(Config.RESOURCES_FOLDER) + this.filePath + fileName);
        OutputUtils.lc("[i] Exporting " + this.filePath + fileName + "...");
        if (Config.OVERWRITE_INTERACT_OPTION && file.exists()) {
            System.in.skip(System.in.available());
            OutputUtils.lc("File exists. Overwrite? (y/n):");
            char re = (char)System.in.read();
            OutputUtils.logln(Character.valueOf(re));
            if (re == 'y') {
                OutputUtils.lc("[i] Overwriting " + this.filePath + fileName + "...");
            } else {
                if (re == 'n') {
                    OutputUtils.lcln("[i] Exporting " + this.filePath + fileName + "... Aborted.");
                    return 0;
                }
                this.exportRefPts(display);
                return 0;
            }
        }
        if (this.getRefPtsValues() != null) {
            OutputSupplier outputStream = Files.newOutputStreamSupplier((File)file);
            XMCDAEvaluations writerPConfigs = new XMCDAEvaluations();
            XPerformanceTable xPConfigs = writerPConfigs.write((EvaluationsRead)this.getRefPtsValues());
            List xPList = xPConfigs.getAlternativePerformancesList();
            int i = 0;
            while (i < xPList.size()) {
                XAlternativeOnCriteriaPerformances xProfile = (XAlternativeOnCriteriaPerformances)xPList.get(i);
                xProfile.setMcdaConcept("Ref. profile");
                xProfile.setId(this.getLexico().get(i).toString());
                ++i;
            }
            XMCDAWriteUtils.write((XmlObject)xPConfigs, (OutputSupplier)outputStream, (boolean)true);
            OutputUtils.lcln("OK!");
            OutputUtils.logln("[i] " + fileName.substring(1) + " has been successfully exported!");
            if (display) {
                this.displayRefPts();
                this.displayLexico();
            } else {
                this.outputRefPts();
                this.outputLexico();
            }
            return 1;
        }
        OutputUtils.lcln("Nothing to export.");
        return 0;
    }

    public Integer exportPairComps(boolean display) throws IOException {
        String fileName = "/" + PreDef.FileName.alternativesComparisons.toString() + ".xml";
        File file = new File(String.valueOf(Config.RESOURCES_FOLDER) + this.filePath + fileName);
        OutputUtils.lc("[i] Exporting " + this.filePath + fileName + "...");
        if (Config.OVERWRITE_INTERACT_OPTION && file.exists()) {
            System.in.skip(System.in.available());
            OutputUtils.lc("File exists. Overwrite? (y/n):");
            char re = (char)System.in.read();
            OutputUtils.logln(Character.valueOf(re));
            if (re == 'y') {
                OutputUtils.lc("[i] Overwriting " + this.filePath + fileName + "...");
            } else {
                if (re == 'n') {
                    OutputUtils.lcln("[i] Exporting " + this.filePath + fileName + "... Aborted.");
                    return 0;
                }
                this.exportPairComps(display);
                return 0;
            }
        }
        if (this.getPairComps() != null) {
            OutputSupplier outputStream = Files.newOutputStreamSupplier((File)file);
            XMCDAAlternativesMatrix writerAltesMatrix = new XMCDAAlternativesMatrix();
            XAlternativesComparisons xAltesComps = writerAltesMatrix.write(this.getPairComps());
            xAltesComps.setComparisonType("Preference");
            XMCDAWriteUtils.write((XmlObject)xAltesComps, (OutputSupplier)outputStream, (boolean)true);
            OutputUtils.lcln("OK!");
            OutputUtils.logln("[i] " + fileName.substring(1) + " has been successfully exported!");
            if (display) {
                this.displayPairComps();
            } else {
                this.outputPairComps();
            }
            return 1;
        }
        OutputUtils.lcln("Nothing to export.");
        return 0;
    }

    public Integer exportRanking(boolean display) throws IOException {
        String fileName = "/" + PreDef.FileName.ranking.toString() + ".xml";
        File file = new File(String.valueOf(Config.RESOURCES_FOLDER) + this.filePath + fileName);
        OutputUtils.lc("[i] Exporting " + this.filePath + fileName + "...");
        if (Config.OVERWRITE_INTERACT_OPTION && file.exists()) {
            System.in.skip(System.in.available());
            OutputUtils.lc("File exists. Overwrite? (y/n):");
            char re = (char)System.in.read();
            OutputUtils.logln(Character.valueOf(re));
            if (re == 'y') {
                OutputUtils.lc("[i] Overwriting " + this.filePath + fileName + "...");
            } else {
                if (re == 'n') {
                    OutputUtils.lcln("[i] Exporting " + this.filePath + fileName + "... Aborted.");
                    return 0;
                }
                this.exportRanking(display);
                return 0;
            }
        }
        if (this.getBinComps() != null) {
            OutputSupplier outputStream = Files.newOutputStreamSupplier((File)file);
            XMCDAAlternativesMatrix writerAltesMatrix = new XMCDAAlternativesMatrix();
            XAlternativesComparisons xAltesComps = writerAltesMatrix.write(this.getBinComps());
            xAltesComps.setComparisonType("Preference");
            XMCDAWriteUtils.write((XmlObject)xAltesComps, (OutputSupplier)outputStream, (boolean)true);
            OutputUtils.lcln("OK!");
            OutputUtils.logln("[i] " + fileName.substring(1) + " has been successfully exported!");
            if (display) {
                this.displayGlobalRanking();
            } else {
                this.outputGlobalRanking();
            }
            return 1;
        }
        OutputUtils.lcln("Nothing to export.");
        return 0;
    }

    public Integer exportPreorder(boolean display) throws IOException {
        String fileName = "/" + PreDef.FileName.preorder.toString() + ".xml";
        File file = new File(String.valueOf(Config.RESOURCES_FOLDER) + this.filePath + fileName);
        OutputUtils.lc("[i] Exporting " + this.filePath + fileName + "...");
        if (Config.OVERWRITE_INTERACT_OPTION && file.exists()) {
            System.in.skip(System.in.available());
            OutputUtils.lc("File exists. Overwrite? (y/n):");
            char re = (char)System.in.read();
            OutputUtils.logln(Character.valueOf(re));
            if (re == 'y') {
                OutputUtils.lc("[i] Overwriting " + this.filePath + fileName + "...");
            } else {
                if (re == 'n') {
                    OutputUtils.lcln("[i] Exporting " + this.filePath + fileName + "... Aborted.");
                    return 0;
                }
                this.exportPreorder(display);
                return 0;
            }
        }
        if (this.getBinComps() != null) {
            Preorder<Alternative> preorder = RankingUtils.getPreorder(this.getBinComps());
            OutputSupplier outputStream = Files.newOutputStreamSupplier((File)file);
            XAlternativesValues xAlternativesVals = XMCDADoc.XMCDA.Factory.newInstance().addNewAlternativesValues();
            for (Alternative alte : preorder) {
                XAlternativeValue xAlteVal = xAlternativesVals.addNewAlternativeValue();
                xAlteVal.setAlternativeID(alte.getId());
                XValue xVal = xAlteVal.addNewValue();
                xVal.setInteger(preorder.getRank((Object)alte).intValue());
            }
            XMCDAWriteUtils.write((XmlObject)xAlternativesVals, (OutputSupplier)outputStream, (boolean)true);
            OutputUtils.lcln("OK!");
            OutputUtils.logln("[i] " + fileName.substring(1) + " has been successfully exported!");
            if (display) {
                this.displayGlobalRanking();
            } else {
                this.outputGlobalRanking();
            }
            return 1;
        }
        OutputUtils.lcln("Nothing to export.");
        return 0;
    }

    public String getOutputPath() {
        return Config.OUTPUT_FOLDER;
    }

    public void setOutputPath(String filePath) {
        Config.OUTPUT_FOLDER = filePath;
        Config.MODEL_FOLDER = String.valueOf(Config.OUTPUT_FOLDER) + "/models";
        Config.SOL_FOLDER = String.valueOf(Config.OUTPUT_FOLDER) + "/sols";
        Config.XML_FOLDER = String.valueOf(Config.OUTPUT_FOLDER);
        this.setFilePath(Config.XML_FOLDER);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }
}

