/*
 * Decompiled with CFR 0.152.
 */
package jrmp.srmp.access;

import ilog.concert.IloException;
import java.io.IOException;
import jrmp.srmp.access.Accessible;
import jrmp.srmp.base.SRMPaggregator;
import jrmp.srmp.base.XSRMPgenerator;
import jrmp.srmp.solver.CplSolverJun;

public class TCmip
extends Accessible {
    public static void main(String[] args) throws IOException, IloException {
        TCmip.prepare(args);
        XSRMPgenerator gene = new XSRMPgenerator();
        gene.generate();
        CplSolverJun jun = new CplSolverJun(gene);
        if (jun.getInput().isReadyForDisag()) {
            jun.solve(true);
        } else {
            System.out.println("Disaggrgation Wrong!");
        }
        SRMPaggregator aggr = new SRMPaggregator(jun.getOutput());
        if (aggr.getInput().isReadyForAggr()) {
            aggr.execute(false);
        } else {
            System.out.println("Aggrgation Wrong!");
        }
        System.out.println("[i] The ratio of representables is " + aggr.getRatioOfRepresentables() * 100.0 + "%.");
        TCmip.end();
    }
}

