/*
 * Decompiled with CFR 0.152.
 */
package jrmp.srmp.base;

import com.google.common.collect.Table;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import jrmp.srmp.base.SRMPaggregator;
import jrmp.srmp.base.XSRMPmodeler;
import jrmp.srmp.settings.Config;
import jrmp.srmp.settings.Para;
import jrmp.srmp.utils.Factorial;
import jrmp.srmp.utils.OutputUtils;
import jrmp.srmp.utils.Permutations;
import jrmp.srmp.utils.RankingUtils;
import org.decision_deck.jmcda.structure.Alternative;
import org.decision_deck.jmcda.structure.Criterion;
import org.decision_deck.jmcda.structure.interval.Interval;
import org.decision_deck.jmcda.structure.interval.Intervals;
import org.decision_deck.jmcda.structure.interval.PreferenceDirection;
import org.decision_deck.jmcda.structure.matrix.Evaluations;
import org.decision_deck.jmcda.structure.matrix.EvaluationsUtils;
import org.decision_deck.utils.collection.CollectionUtils;
import org.decision_deck.utils.matrix.Matrixes;
import org.decision_deck.utils.matrix.SparseMatrixD;

public class XSRMPgenerator
extends XSRMPmodeler {
    private Integer numOfPcomps = Para.GENE_NUM_PAIR_COMPS;
    private Integer numOfIndiff = Para.GENE_NUM_INDIFFS;

    public XSRMPgenerator() {
        this.setStatus(XSRMPmodeler.Status.initialized);
    }

    public Integer generate() {
        this.setStatus(XSRMPmodeler.Status.overwritten);
        OutputUtils.lsln("\n[Generation Process]");
        this.setStatus(XSRMPmodeler.Status.generated);
        int re = 0;
        re += this.prepareAlternatives(false).intValue();
        re += this.prepareCriteria(false).intValue();
        re += this.prepareEvaluations(false).intValue();
        re += this.prepareWeights(false).intValue();
        re += this.prepareRefPts(false).intValue();
        if ((re += this.preparePairComps(false).intValue()) == 9) {
            OutputUtils.lsln("[i] The generated model is ready.");
        } else {
            OutputUtils.lscln("[i] Something is missing.");
        }
        return re;
    }

    public Integer generate(boolean display) {
        this.setStatus(XSRMPmodeler.Status.overwritten);
        OutputUtils.lscln("\n[Generation Process]");
        this.setStatus(XSRMPmodeler.Status.generated);
        int re = 0;
        re += this.prepareAlternatives(display).intValue();
        re += this.prepareCriteria(display).intValue();
        re += this.prepareEvaluations(display).intValue();
        re += this.prepareWeights(display).intValue();
        re += this.prepareRefPts(display).intValue();
        if ((re += this.preparePairComps(display).intValue()) == 9) {
            OutputUtils.lscln("[i] The generated model is ready.");
        } else {
            OutputUtils.lscln("[i] Something is missing.");
        }
        return re;
    }

    private Integer prepareAlternatives(boolean display) {
        if (display) {
            OutputUtils.lc("[i] Generating the alternatives (1/9)... ");
        } else {
            OutputUtils.log("[i] Generating the alternatives (1/9)... ");
        }
        this.setAlteSet(this.constructAlteSet());
        this.setAlteNames(this.constructAlteNames());
        if (this.getAlteSet() != null) {
            if (display) {
                OutputUtils.lcln("OK!");
            } else {
                OutputUtils.logln("OK!");
            }
            OutputUtils.lsln("[i] " + this.getNumOfAlternatives() + " alternatives have been generated.");
            if (display) {
                this.displayAlternatives();
            } else {
                this.outputAlternatives();
            }
            return 1;
        }
        OutputUtils.lcln("Error!");
        return 0;
    }

    private Integer prepareCriteria(boolean display) {
        if (display) {
            OutputUtils.lc("[i] Generating the criteria (2/9)... ");
        } else {
            OutputUtils.log("[i] Generating the criteria (2/9)... ");
        }
        this.setCritSet(this.constructCritSet());
        this.setCritNames(this.constructCritNames());
        this.setCritScales(this.constructCritScales());
        if (this.getCritSet() != null) {
            if (display) {
                OutputUtils.lcln("OK!");
            } else {
                OutputUtils.logln("OK!");
            }
            OutputUtils.lsln("[i] " + this.getNumOfCriteria() + " criteria have been generated.");
            if (display) {
                this.displayCriteria();
            } else {
                this.outputCriteria();
            }
            return 1;
        }
        OutputUtils.lcln("Error!");
        return 0;
    }

    private Integer prepareEvaluations(boolean display) {
        if (display) {
            OutputUtils.lc("[i] Generating the evaluations of alternatives (3/9)... ");
        } else {
            OutputUtils.log("[i] Generating the evaluations of alternatives (3/9)... ");
        }
        this.setAlteValues(this.constructAlteValues());
        if (this.getAlteValues() != null) {
            if (display) {
                OutputUtils.lcln("OK!");
            } else {
                OutputUtils.logln("OK!");
            }
            if (Config.CONTINUOUS_SCALE_MODE_ON) {
                OutputUtils.lsln("[i] The alternatives are evaluated on continuous scale and the values are randomized between [" + Para.RATING_SCALE_MIN + "," + Para.RATING_SCALE_MAX + "].");
            } else {
                OutputUtils.lsln("[i] The alternatives are evaluated on discrete scale and the values are randomized between [" + Para.RATING_SCALE_MIN + "," + Para.RATING_SCALE_MAX + "] and " + "the rating scale increment is " + Para.RATING_SCALE_INCREMENT + ".");
            }
            if (display) {
                this.displayEvaluations();
            } else {
                this.outputEvaluations();
            }
            return 1;
        }
        OutputUtils.lcln("Error!");
        return 0;
    }

    private Integer prepareWeights(boolean display) {
        if (display) {
            OutputUtils.lc("[i] Generating the weights of criteria (4/9)... ");
        } else {
            OutputUtils.log("[i] Generating the weights of criteria (4/9)... ");
        }
        this.setWeights(this.constructCritWeights());
        if (this.getWeights() != null) {
            if (display) {
                OutputUtils.lcln("OK!");
            } else {
                OutputUtils.logln("OK!");
            }
            OutputUtils.lsln("[i] The weights of criteria have been randomized between [" + Para.WEIGHT_LOWER_BOUND + "," + Para.WEIGHT_UPPER_BOUND + "] " + "and normalized to 1.");
            if (display) {
                this.displayWeights();
            } else {
                this.outputWeights();
            }
            return 1;
        }
        OutputUtils.lcln("Error!");
        return 0;
    }

    private Integer prepareRefPts(boolean display) {
        if (display) {
            OutputUtils.lc("[i] Generating the reference points (5/9)... ");
        } else {
            OutputUtils.log("[i] Generating the reference points (5/9)... ");
        }
        this.setRefPtsSet(this.constructRefPtsSet());
        this.setRefPtsValues(this.constructRefPtsValues());
        int re = 0;
        if (this.getRefPtsSet() != null) {
            ++re;
            if (display) {
                OutputUtils.lcln("OK!");
            } else {
                OutputUtils.logln("OK!");
            }
            if (Config.NUM_REF_PTS_DETERMINED) {
                OutputUtils.lsln("[i] The number of reference points is determined. " + Para.GENE_NUM_REF_PTS + " reference point(s) have/has been generated.");
            } else {
                OutputUtils.lsln("[i] The number of reference points is randomized between [1," + Para.MAX_NUM_REF_PTS + "]. " + this.getNumOfRefPts() + " reference point(s) have/has been generated.");
            }
            if (display) {
                this.displayRefPts();
            } else {
                this.outputRefPts();
            }
        } else {
            OutputUtils.lcln("Error!");
        }
        if (display) {
            OutputUtils.lc("[i] Generating the lexicographic order for reference points (6/9)... ");
        } else {
            OutputUtils.log("[i] Generating the lexicographic order for reference points (6/9)... ");
        }
        this.setLexico(this.constructLexico());
        if (this.getLexico() != null) {
            ++re;
            if (display) {
                OutputUtils.lcln("OK!");
            } else {
                OutputUtils.logln("OK!");
            }
            OutputUtils.lsln("[i] The lexicographic order of reference points is randomly selected.");
            if (display) {
                this.displayLexico();
            } else {
                this.outputLexico();
            }
        } else {
            OutputUtils.lcln("Error!");
        }
        return re;
    }

    private Integer preparePairComps(boolean display) {
        int re = 0;
        if (display) {
            OutputUtils.lc("[i] Aggregating the complete ranking with the generated S-RMP model (7/9)... ");
        } else {
            OutputUtils.log("[i] Aggregating the complete ranking with the generated S-RMP model (7/9)... ");
        }
        this.setBinComps(this.constructBinComps());
        if (this.getBinComps() != null) {
            if (display) {
                OutputUtils.lcln("OK!");
            } else {
                OutputUtils.logln("OK!");
            }
            ++re;
        } else {
            OutputUtils.lcln("Error!");
        }
        if (display) {
            OutputUtils.lc("[i] Selecting the pairwise comparisons (8/9)... ");
        } else {
            OutputUtils.log("[i] Selecting the pairwise comparisons (8/9)... ");
        }
        this.setPairComps(this.constructPairComps());
        if (this.getNumOfPairComps() > 0) {
            if (display) {
                OutputUtils.lcln("OK!");
            } else {
                OutputUtils.logln("OK!");
            }
            ++re;
            OutputUtils.lsln("[i] " + this.getNumOfPairComps() + " pairs of alternatives have been randomly selected.");
        } else {
            OutputUtils.lcln("Error!");
        }
        if (display) {
            OutputUtils.lc("[i] Generating the pairwise comparisons (9/9)... ");
        } else {
            OutputUtils.log("[i] Generating the pairwise comparisons (9/9)... ");
        }
        this.setAlteInPCs(this.constructAlteInPCsSet());
        if (this.getNumOfAltesInPCs() > 0) {
            if (display) {
                OutputUtils.lcln("OK!");
            } else {
                OutputUtils.logln("OK!");
            }
            ++re;
            OutputUtils.lsln("[i] " + this.getNumOfAltesInPCs() + " different alternatives are involved in the pairwise comparisons.");
        } else {
            OutputUtils.lcln("Error!");
        }
        if (display) {
            this.displayPairComps();
        } else {
            this.outputPairComps();
        }
        return re;
    }

    private Set<Criterion> constructCritSet() {
        LinkedHashSet<Criterion> re = new LinkedHashSet<Criterion>(Para.GENE_NUM_CRITERIA);
        int i = 0;
        while (i < Para.GENE_NUM_CRITERIA) {
            re.add(new Criterion("c" + (i + 1)));
            ++i;
        }
        return re;
    }

    private Map<Criterion, String> constructCritNames() {
        LinkedHashMap<Criterion, String> re = new LinkedHashMap<Criterion, String>(Para.GENE_NUM_CRITERIA);
        if (!this.getCritSet().isEmpty()) {
            for (Criterion crit : this.getCritSet()) {
                re.put(crit, "Unknown");
            }
        }
        return re;
    }

    private Map<Criterion, Interval> constructCritScales() {
        Random random = new Random(System.currentTimeMillis());
        LinkedHashMap<Criterion, Interval> re = new LinkedHashMap<Criterion, Interval>(Para.GENE_NUM_CRITERIA);
        if (!this.getCritSet().isEmpty()) {
            for (Criterion crit : this.getCritSet()) {
                Interval interval = random.nextBoolean() ? Intervals.newUnrestrictedInterval((PreferenceDirection)PreferenceDirection.MAXIMIZE, (double)Para.RATING_SCALE_MIN, (double)Para.RATING_SCALE_MAX) : (Config.ALWAYS_MAXIMIZE ? Intervals.newUnrestrictedInterval((PreferenceDirection)PreferenceDirection.MAXIMIZE, (double)Para.RATING_SCALE_MIN, (double)Para.RATING_SCALE_MAX) : Intervals.newUnrestrictedInterval((PreferenceDirection)PreferenceDirection.MINIMIZE, (double)Para.RATING_SCALE_MIN, (double)Para.RATING_SCALE_MAX));
                re.put(crit, interval);
            }
        }
        return re;
    }

    private Map<Criterion, Double> constructCritWeights() {
        Random random = new Random(System.currentTimeMillis());
        HashMap<Criterion, Double> re = new HashMap<Criterion, Double>(Para.GENE_NUM_CRITERIA);
        if (!this.getCritSet().isEmpty()) {
            float sum = 0.0f;
            ArrayList<Double> tempoList = new ArrayList<Double>();
            int i = 0;
            while (i < this.getCritSet().size()) {
                double max = Para.WEIGHT_UPPER_BOUND;
                double min = Para.WEIGHT_LOWER_BOUND;
                double range = max - min;
                double weight = max - range * (double)random.nextFloat();
                sum = (float)((double)sum + weight);
                tempoList.add(weight);
                ++i;
            }
            Iterator<Criterion> it = this.getCritSet().iterator();
            int i2 = 0;
            while (i2 < this.getCritSet().size()) {
                Criterion crit = it.next();
                double normalizedWeight = (Double)tempoList.get(i2) / (double)sum;
                re.put(crit, normalizedWeight);
                ++i2;
            }
        }
        return re;
    }

    private Set<Alternative> constructAlteSet() {
        DecimalFormat df = new DecimalFormat("000");
        LinkedHashSet<Alternative> re = new LinkedHashSet<Alternative>(Para.GENE_NUM_ALTERNATIVES);
        int i = 0;
        while (i < Para.GENE_NUM_ALTERNATIVES) {
            String alteId = "a" + df.format(i + 1);
            re.add(new Alternative(alteId));
            ++i;
        }
        return re;
    }

    private Map<Alternative, String> constructAlteNames() {
        LinkedHashMap<Alternative, String> re = new LinkedHashMap<Alternative, String>(Para.GENE_NUM_ALTERNATIVES);
        if (!this.getAlteSet().isEmpty()) {
            for (Alternative alte : this.getAlteSet()) {
                re.put(alte, "Unknown");
            }
        }
        return re;
    }

    private Evaluations constructAlteValues() {
        Random random = new Random(System.currentTimeMillis());
        Evaluations re = EvaluationsUtils.newEvaluationMatrix();
        if (!this.getAlteSet().isEmpty() && !this.getCritSet().isEmpty()) {
            for (Alternative alternative : this.getAlteSet()) {
                for (Criterion criterion : this.getCritSet()) {
                    if (Config.CONTINUOUS_SCALE_MODE_ON) {
                        double max = Para.RATING_SCALE_MAX;
                        double min = Para.RATING_SCALE_MIN;
                        double range = max - min;
                        double value = max - range * random.nextDouble();
                        re.put((Object)alternative, (Object)criterion, value);
                        continue;
                    }
                    int max = Para.RATING_SCALE_MAX / Para.RATING_SCALE_INCREMENT;
                    int min = Para.RATING_SCALE_MIN / Para.RATING_SCALE_INCREMENT;
                    int range = max - min;
                    double value = (double)Para.RATING_SCALE_INCREMENT * (double)(max - random.nextInt(range + 1));
                    re.put((Object)alternative, (Object)criterion, value);
                }
            }
        }
        return re;
    }

    private Set<Alternative> constructRefPtsSet() {
        LinkedHashSet<Alternative> re = new LinkedHashSet<Alternative>();
        if (Config.NUM_REF_PTS_DETERMINED) {
            int i = 0;
            while (i < Para.GENE_NUM_REF_PTS) {
                String id = "p" + (i + 1);
                re.add(new Alternative(id));
                ++i;
            }
        } else {
            Random random = new Random(System.currentTimeMillis());
            int num = Para.MAX_NUM_REF_PTS - random.nextInt(Para.MAX_NUM_REF_PTS);
            int i = 0;
            while (i < num) {
                String id = "p" + (i + 1);
                re.add(new Alternative(id));
                ++i;
            }
        }
        return re;
    }

    private Evaluations constructRefPtsValues() {
        Random random = new Random(System.currentTimeMillis());
        Evaluations re = EvaluationsUtils.newEvaluationMatrix();
        if (!this.getRefPtsSet().isEmpty() && !this.getCritSet().isEmpty()) {
            for (Criterion criterion : this.getCritSet()) {
                ArrayList<Double> list = new ArrayList<Double>(this.getRefPtsSet().size());
                int p = 0;
                while (p < this.getRefPtsSet().size()) {
                    double range;
                    double min;
                    double max;
                    double value = -1.0;
                    if (Config.CONTINUOUS_SCALE_MODE_ON) {
                        max = Para.RATING_SCALE_MAX;
                        min = Para.RATING_SCALE_MIN;
                        range = max - min;
                        value = max - range * random.nextDouble();
                    } else {
                        max = Para.RATING_SCALE_MAX / Para.RATING_SCALE_INCREMENT;
                        min = Para.RATING_SCALE_MIN / Para.RATING_SCALE_INCREMENT;
                        range = max - min;
                        double tempo = max - range * random.nextDouble();
                        value = (double)Para.RATING_SCALE_INCREMENT * Math.rint(tempo);
                    }
                    list.add(value);
                    ++p;
                }
                Collections.sort(list);
                int index = 0;
                for (Alternative profile : this.getRefPtsSet()) {
                    if (this.getCritScales().get(criterion).getPreferenceDirection() == PreferenceDirection.MAXIMIZE) {
                        re.put((Object)profile, (Object)criterion, ((Double)list.get(index)).doubleValue());
                    }
                    if (this.getCritScales().get(criterion).getPreferenceDirection() == PreferenceDirection.MINIMIZE) {
                        re.put((Object)profile, (Object)criterion, ((Double)list.get(this.getRefPtsSet().size() - 1 - index)).doubleValue());
                    }
                    ++index;
                }
            }
        }
        return re;
    }

    private ArrayList<Integer> constructLexico() {
        ArrayList<ArrayList<Integer>> list = Permutations.getAll(this.getRefPtsSet().size());
        Random random = new Random(System.currentTimeMillis());
        int index = random.nextInt(Factorial.fac(this.getRefPtsSet().size()));
        return list.get(index);
    }

    protected SparseMatrixD<Alternative, Alternative> constructBinComps() {
        SRMPaggregator aggr = new SRMPaggregator(this);
        aggr.execute();
        return aggr.getGlobalPrefMatrix();
    }

    protected SparseMatrixD<Alternative, Alternative> constructPairComps() {
        int col;
        int row;
        int pair;
        Double val;
        Random random = new Random(System.currentTimeMillis());
        SparseMatrixD re = Matrixes.newSparseD();
        ArrayList cellList = new ArrayList(this.getBinComps().asTable().cellSet());
        ArrayList<Alternative> altList = this.getListOfAlternatives();
        if (RankingUtils.getIndifferenceCount(this.getBinComps()) >= this.numOfIndiff) {
            do {
                if ((val = (Double)((Table.Cell)cellList.get(pair = random.nextInt(cellList.size()))).getValue()).equals(0.0) || (row = altList.indexOf(((Table.Cell)cellList.get(pair)).getRowKey())) == (col = altList.indexOf(((Table.Cell)cellList.get(pair)).getColumnKey())) || re.asTable().contains((Object)altList.get(col), (Object)altList.get(row))) continue;
                re.put((Object)altList.get(row), (Object)altList.get(col), val.doubleValue());
            } while (re.getValueCount() < this.numOfIndiff);
        }
        if (this.numOfIndiff < this.numOfPcomps) {
            do {
                pair = random.nextInt(cellList.size());
                val = (Double)((Table.Cell)cellList.get(pair)).getValue();
                row = altList.indexOf(((Table.Cell)cellList.get(pair)).getRowKey());
                col = altList.indexOf(((Table.Cell)cellList.get(pair)).getColumnKey());
                if (val.equals(0.0) || val == null) continue;
                re.put((Object)altList.get(row), (Object)altList.get(col), val.doubleValue());
            } while (re.getValueCount() < this.numOfPcomps);
        }
        return re;
    }

    protected Set<Alternative> constructAlteInPCsSet() {
        Set re = CollectionUtils.newHashSetNoNull();
        re.addAll(this.getPairComps().getRows());
        re.addAll(this.getPairComps().getColumns());
        return re;
    }

    public Integer getNumOfpcomps() {
        return this.numOfPcomps;
    }

    public void setNumOfpcomps(Integer numOfpcomps) {
        this.numOfPcomps = numOfpcomps;
    }

    public Integer getNumOfIndiff() {
        return this.numOfIndiff;
    }

    public void setNumOfIndiff(Integer numOfIndiff) {
        this.numOfIndiff = numOfIndiff;
    }
}

