/*
 * Decompiled with CFR 0.152.
 */
package jrmp.srmp.base;

import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import jrmp.srmp.base.XSRMPmodeler;
import jrmp.srmp.settings.Config;
import jrmp.srmp.utils.OutputUtils;
import jrmp.srmp.utils.PreDef;
import org.apache.xmlbeans.XmlException;
import org.decision_deck.jmcda.structure.Alternative;
import org.decision_deck.jmcda.structure.Criterion;
import org.decision_deck.utils.collection.CollectionUtils;
import org.decision_deck.utils.matrix.SparseMatrixD;
import org.decisiondeck.jmcda.exc.InvalidInputException;
import org.decisiondeck.jmcda.persist.xmcda2.XMCDAAlternatives;
import org.decisiondeck.jmcda.persist.xmcda2.XMCDAAlternativesMatrix;
import org.decisiondeck.jmcda.persist.xmcda2.XMCDACriteria;
import org.decisiondeck.jmcda.persist.xmcda2.XMCDAEvaluations;
import org.decisiondeck.jmcda.persist.xmcda2.generated.XAlternativeOnCriteriaPerformances;
import org.decisiondeck.jmcda.persist.xmcda2.generated.XAlternativesComparisons;
import org.decisiondeck.jmcda.persist.xmcda2.generated.XCriteriaValues;
import org.decisiondeck.jmcda.persist.xmcda2.generated.XCriterionValue;
import org.decisiondeck.jmcda.persist.xmcda2.generated.XMCDADoc;
import org.decisiondeck.jmcda.persist.xmcda2.generated.XPerformanceTable;
import org.decisiondeck.jmcda.persist.xmcda2.utils.XMCDAReadUtils;

public class XSRMPreader
extends XSRMPmodeler {
    private String filePath;
    private XMCDAReadUtils reader = new XMCDAReadUtils();

    public XSRMPreader() {
        this.setStatus(XSRMPmodeler.Status.initialized);
        this.setInputPath(Config.INPUT_FOLDER);
    }

    public XSRMPreader(XSRMPmodeler model) {
        super(model);
        this.setStatus(XSRMPmodeler.Status.overwritten);
        this.setInputPath(Config.INPUT_FOLDER);
    }

    public Integer read() throws IOException, XmlException, InvalidInputException {
        OutputUtils.consoleln("\n[Loading Process]");
        OutputUtils.lsln("\n *** Files Loading *** \n");
        this.setStatus(XSRMPmodeler.Status.loaded);
        int re = 0;
        re += this.loadAlternatives(false).intValue();
        re += this.loadCriteria(false).intValue();
        re += this.loadEvaluations(false).intValue();
        re += this.loadPairComps(false).intValue();
        re += this.loadWeights(false).intValue();
        re += this.loadRefPts(false).intValue();
        OutputUtils.lscln("[i] " + (re += this.loadRanking(false).intValue()) + "/7 files have been loaded.");
        OutputUtils.lsln("[i] Loading completed!");
        return re;
    }

    public Integer read(boolean display) throws IOException, XmlException, InvalidInputException {
        OutputUtils.consoleln("\n[Loading Process]");
        OutputUtils.lsln("\n *** Files Loading *** \n");
        this.setStatus(XSRMPmodeler.Status.loaded);
        int re = 0;
        re += this.loadAlternatives(display).intValue();
        re += this.loadCriteria(display).intValue();
        re += this.loadEvaluations(display).intValue();
        re += this.loadPairComps(display).intValue();
        re += this.loadWeights(display).intValue();
        re += this.loadRefPts(display).intValue();
        OutputUtils.lscln("[i] " + (re += this.loadRanking(display).intValue()) + "/7 files have been loaded.");
        OutputUtils.lsln("[i] Loading completed!");
        return re;
    }

    public Integer read(boolean display, int mode) throws IOException, XmlException, InvalidInputException {
        OutputUtils.consoleln("\n[Loading Process]");
        OutputUtils.lsln("\n *** Files Loading *** \n");
        this.setStatus(XSRMPmodeler.Status.loaded);
        int re = 0;
        re += this.loadAlternatives(display).intValue();
        re += this.loadCriteria(display).intValue();
        re += this.loadEvaluations(display).intValue();
        switch (mode) {
            case 1: {
                re += this.loadWeights(display).intValue();
                OutputUtils.lscln("[i] " + (re += this.loadRefPts(display).intValue()) + "/5 files have been loaded.");
                break;
            }
            case 2: {
                OutputUtils.lscln("[i] " + (re += this.loadPairComps(display).intValue()) + "/4 files have been loaded.");
                break;
            }
            case 3: {
                OutputUtils.lscln("[i] " + (re += this.loadRanking(display).intValue()) + "/4 files have been loaded.");
                break;
            }
            default: {
                re += this.loadWeights(display).intValue();
                re += this.loadRefPts(display).intValue();
                re += this.loadPairComps(display).intValue();
                OutputUtils.lscln("[i] " + (re += this.loadRanking(display).intValue()) + "/7 files have been loaded.");
            }
        }
        OutputUtils.lsln("[i] Loading completed!");
        return re;
    }

    public Integer read(String path) throws IOException, XmlException, InvalidInputException {
        this.setInputPath(path);
        OutputUtils.consoleln("\n[Loading Process]");
        OutputUtils.lsln("\n *** Files Loading *** \n");
        this.setStatus(XSRMPmodeler.Status.loaded);
        int re = 0;
        re += this.loadAlternatives(false).intValue();
        re += this.loadCriteria(false).intValue();
        re += this.loadEvaluations(false).intValue();
        re += this.loadPairComps(false).intValue();
        re += this.loadWeights(false).intValue();
        re += this.loadRefPts(false).intValue();
        OutputUtils.lscln("[i] " + (re += this.loadRanking(false).intValue()) + "/7 files have been loaded.");
        OutputUtils.lsln("[i] Loading completed!");
        return re;
    }

    public ArrayList<Integer> perturb(int number) {
        Random random;
        this.setStatus(XSRMPmodeler.Status.overwritten);
        int num = number;
        if (number > this.getNumOfPairComps()) {
            num = this.getNumOfPairComps();
        }
        if (number < 0) {
            random = new Random(System.currentTimeMillis());
            num = 1 + random.nextInt(-number);
        }
        random = new Random(System.currentTimeMillis());
        ArrayList<Integer> aimList = new ArrayList<Integer>();
        int count = 0;
        while (count < num) {
            Integer aim = random.nextInt(this.getListOfPairComps().size());
            if (aimList.contains(aim)) continue;
            aimList.add(aim + 1);
            Alternative row = (Alternative)this.getListOfPairComps().get(aim).getRowKey();
            Alternative col = (Alternative)this.getListOfPairComps().get(aim).getColumnKey();
            double init = (Double)this.getListOfPairComps().get(aim).getValue();
            this.getPairComps().put((Object)row, (Object)col, -init);
            ++count;
        }
        OutputUtils.lsc("[i] The comparison number ");
        for (Integer i : aimList) {
            OutputUtils.lsc(i);
            if (aimList.indexOf(i) == aimList.size() - 1) continue;
            OutputUtils.lsc(",");
        }
        OutputUtils.lscln("\b has/have been perturbed.");
        return aimList;
    }

    public ArrayList<Integer> perturb(Integer[] index) {
        this.setStatus(XSRMPmodeler.Status.overwritten);
        ArrayList<Integer> indList = new ArrayList<Integer>();
        int num = this.getNumOfPairComps();
        int i = 0;
        while (i < index.length) {
            Integer ind = index[i];
            if (ind < num && ind > -1) {
                indList.add(ind);
                Alternative row = (Alternative)this.getListOfPairComps().get(ind).getRowKey();
                Alternative col = (Alternative)this.getListOfPairComps().get(ind).getColumnKey();
                double init = (Double)this.getListOfPairComps().get(ind).getValue();
                this.getPairComps().put((Object)row, (Object)col, -init);
            }
            ++i;
        }
        OutputUtils.lsc("[i] The comparison number ");
        for (Integer i2 : indList) {
            OutputUtils.lsc(i2);
            if (indList.indexOf(i2) == indList.size() - 1) continue;
            OutputUtils.lsc(",");
        }
        OutputUtils.lscln("\b has/have been perturbed.");
        return indList;
    }

    private Integer loadAlternatives(boolean display) throws IOException, XmlException, InvalidInputException {
        String fileName = "/" + PreDef.FileName.alternatives.toString() + ".xml";
        File file = new File(String.valueOf(Config.RESOURCES_FOLDER) + this.filePath + fileName);
        OutputUtils.lc("[i] Loading " + this.filePath + fileName + "...");
        if (!file.exists()) {
            OutputUtils.lcln(" File not found (or not given).");
            return 0;
        }
        InputSupplier input = Files.newInputStreamSupplier((File)file);
        XMCDADoc.XMCDA xmcda = this.reader.getXMCDA(input);
        List listAlternatives = xmcda.getAlternativesList();
        XMCDAAlternatives xmcdaAlternatives = new XMCDAAlternatives();
        this.setAlteSet(xmcdaAlternatives.readAll((Collection)listAlternatives));
        this.setAlteNames(xmcdaAlternatives.getNames());
        OutputUtils.lcln("OK!");
        OutputUtils.logln("[i] " + fileName.substring(1) + " has been successfully loaded!");
        OutputUtils.lsln("[i] There are " + this.getAlteSet().size() + " alternatives loaded in total.");
        if (display) {
            this.displayAlternatives();
        } else {
            this.outputAlternatives();
        }
        return 1;
    }

    private Integer loadCriteria(boolean display) throws IOException, XmlException, InvalidInputException {
        String fileName = "/" + PreDef.FileName.criteria.toString() + ".xml";
        File file = new File(String.valueOf(Config.RESOURCES_FOLDER) + this.filePath + fileName);
        OutputUtils.lc("[i] Loading " + this.filePath + fileName + "...");
        if (!file.exists()) {
            OutputUtils.lcln(" File not found (or not given).");
            return 0;
        }
        InputSupplier input = Files.newInputStreamSupplier((File)file);
        XMCDADoc.XMCDA xmcda = this.reader.getXMCDA(input);
        List listCriteria = xmcda.getCriteriaList();
        XMCDACriteria xmcdaCriteria = new XMCDACriteria();
        this.setCritSet(xmcdaCriteria.readAll((Collection)listCriteria));
        this.setCritNames(xmcdaCriteria.getNames());
        this.setCritScales(xmcdaCriteria.getScales());
        xmcdaCriteria.getIndifferenceThresholds();
        OutputUtils.lcln("OK!");
        OutputUtils.logln("[i] " + fileName.substring(1) + " has been successfully loaded!");
        OutputUtils.lsln("[i] The alternatives are evaluated on " + this.getCritSet().size() + " criteria.");
        if (display) {
            this.displayCriteria();
        } else {
            this.outputCriteria();
        }
        return 1;
    }

    private Integer loadWeights(boolean display) throws IOException, XmlException {
        String fileName = "/" + PreDef.FileName.weights.toString() + ".xml";
        File file = new File(String.valueOf(Config.RESOURCES_FOLDER) + this.filePath + fileName);
        OutputUtils.lc("[i] Loading " + this.filePath + fileName + "...");
        if (!file.exists()) {
            OutputUtils.lcln(" File not found (or not given).");
            return 0;
        }
        InputSupplier input = Files.newInputStreamSupplier((File)file);
        XMCDADoc.XMCDA xmcda = this.reader.getXMCDA(input);
        List listCritVals = xmcda.getCriteriaValuesList();
        List listWeights = ((XCriteriaValues)listCritVals.get(0)).getCriterionValueList();
        Map tempMap = CollectionUtils.newMapNoNull();
        int i = 0;
        while (i < listWeights.size()) {
            tempMap.put(new Criterion(((XCriterionValue)listWeights.get(i)).getCriterionID()), Float.valueOf(((XCriterionValue)listWeights.get(i)).getValueArray(0).getReal()));
            ++i;
        }
        this.setWeights(new LinkedHashMap<Criterion, Double>());
        for (Criterion crit : this.getCritSet()) {
            this.getWeights().put(crit, new Double(((Float)tempMap.get(crit)).floatValue()));
        }
        OutputUtils.lcln("OK!");
        OutputUtils.logln("[i] " + fileName.substring(1) + " has been successfully loaded!");
        OutputUtils.lsln("[i] The weights of criteria have been normalized.");
        if (display) {
            this.displayWeights();
        } else {
            this.outputWeights();
        }
        return 1;
    }

    private Integer loadEvaluations(boolean display) throws IOException, XmlException, InvalidInputException {
        String fileName = "/" + PreDef.FileName.performanceTable.toString() + ".xml";
        File file = new File(String.valueOf(Config.RESOURCES_FOLDER) + this.filePath + fileName);
        OutputUtils.lc("[i] Loading " + this.filePath + fileName + "...");
        if (!file.exists()) {
            OutputUtils.lcln(" File not found (or not given).");
            return 0;
        }
        InputSupplier input = Files.newInputStreamSupplier((File)file);
        XMCDADoc.XMCDA xmcda = this.reader.getXMCDA(input);
        List listPerfTables = xmcda.getPerformanceTableList();
        XMCDAEvaluations xmcdaEvas = new XMCDAEvaluations();
        this.setAlteValues(xmcdaEvas.read((Collection)listPerfTables));
        OutputUtils.lcln("OK!");
        OutputUtils.logln("[i] " + fileName.substring(1) + " has been successfully loaded!");
        OutputUtils.lsln("[i] There are " + this.getAlteValues().getValueCount() + " values in the performance matrix.");
        if (display) {
            this.displayEvaluations();
        } else {
            this.outputEvaluations();
        }
        return 1;
    }

    private Integer loadRefPts(boolean display) throws IOException, XmlException, InvalidInputException {
        String fileName = "/" + PreDef.FileName.profileConfigs.toString() + ".xml";
        File file = new File(String.valueOf(Config.RESOURCES_FOLDER) + this.filePath + fileName);
        OutputUtils.lc("[i] Loading " + this.filePath + fileName + "...");
        if (!file.exists()) {
            OutputUtils.lcln(" File not found (or not given).");
            return 0;
        }
        InputSupplier input = Files.newInputStreamSupplier((File)file);
        XMCDADoc.XMCDA xmcda = this.reader.getXMCDA(input);
        List listProfileConfigs = xmcda.getPerformanceTableList();
        XMCDAEvaluations xmcdaEvas = new XMCDAEvaluations();
        this.setRefPtsValues(xmcdaEvas.read((Collection)listProfileConfigs));
        this.setRefPtsSet(this.getRefPtsValues().getRows());
        List listProfiles = ((XPerformanceTable)listProfileConfigs.get(0)).getAlternativePerformancesList();
        this.setLexico(new ArrayList<Integer>());
        int i = 0;
        while (i < listProfiles.size()) {
            this.getLexico().add(new Integer(((XAlternativeOnCriteriaPerformances)listProfiles.get(i)).getId()));
            ++i;
        }
        OutputUtils.lcln("OK!");
        OutputUtils.logln("[i] " + fileName.substring(1) + " has been successfully loaded!");
        OutputUtils.lsln("[i] There are " + this.getRefPtsSet().size() + " reference points involved in this model.");
        if (display) {
            this.displayRefPts();
            this.displayLexico();
        } else {
            this.outputRefPts();
            this.outputLexico();
        }
        return 1;
    }

    private Integer loadPairComps(boolean display) throws IOException, XmlException, InvalidInputException {
        String fileName = "/" + PreDef.FileName.alternativesComparisons.toString() + ".xml";
        File file = new File(String.valueOf(Config.RESOURCES_FOLDER) + this.filePath + fileName);
        OutputUtils.lc("[i] Loading " + this.filePath + fileName + "...");
        if (!file.exists()) {
            OutputUtils.lcln(" File not found (or not given).");
            return 0;
        }
        InputSupplier input = Files.newInputStreamSupplier((File)file);
        XMCDADoc.XMCDA xmcda = this.reader.getXMCDA(input);
        List listAlteComp = xmcda.getAlternativesComparisonsList();
        XMCDAAlternativesMatrix xmcdaAlteMatrix = new XMCDAAlternativesMatrix();
        this.setPairComps((SparseMatrixD<Alternative, Alternative>)xmcdaAlteMatrix.readAlternativesFloatMatrix((XAlternativesComparisons)listAlteComp.get(0)));
        Set columnSet = this.getPairComps().getColumns();
        Set rowSet = this.getPairComps().getRows();
        this.setAlteInPCs(new LinkedHashSet<Alternative>());
        this.getAlteInPCs().addAll(columnSet);
        this.getAlteInPCs().addAll(rowSet);
        OutputUtils.lcln("OK!");
        OutputUtils.logln("[i] " + fileName.substring(1) + " has been successfully loaded!");
        OutputUtils.lsln("[i] The reference set consist of " + this.getPairComps().getValueCount() + " pairwise comparisons and " + this.getAlteInPCs().size() + " different alternatives.");
        if (display) {
            this.displayPairComps();
        } else {
            this.outputPairComps();
        }
        return 1;
    }

    private Integer loadRanking(boolean display) throws IOException, XmlException, InvalidInputException {
        String fileName = "/" + PreDef.FileName.ranking.toString() + ".xml";
        File file = new File(String.valueOf(Config.RESOURCES_FOLDER) + this.filePath + fileName);
        OutputUtils.lc("[i] Loading " + this.filePath + fileName + "...");
        if (!file.exists()) {
            OutputUtils.lcln(" File not found (or not given).");
            return 0;
        }
        InputSupplier input = Files.newInputStreamSupplier((File)file);
        XMCDADoc.XMCDA xmcda = this.reader.getXMCDA(input);
        List listAlteComp = xmcda.getAlternativesComparisonsList();
        XMCDAAlternativesMatrix xmcdaAlteMatrix = new XMCDAAlternativesMatrix();
        this.setBinComps((SparseMatrixD<Alternative, Alternative>)xmcdaAlteMatrix.readAlternativesFloatMatrix((XAlternativesComparisons)listAlteComp.get(0)));
        OutputUtils.lcln("OK!");
        OutputUtils.logln("[i] " + fileName.substring(1) + " has been successfully loaded!");
        if (display) {
            this.displayGlobalRanking();
        } else {
            this.outputGlobalRanking();
        }
        return 1;
    }

    public String getInputPath() {
        return Config.INPUT_FOLDER;
    }

    public void setInputPath(String filePath) {
        Config.INPUT_FOLDER = filePath;
        this.setFilePath(filePath);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }
}

