/*
 * Decompiled with CFR 0.152.
 */
package jrmp.srmp.solver;

import com.google.common.collect.Table;
import ilog.concert.IloAddable;
import ilog.concert.IloAnd;
import ilog.concert.IloConstraint;
import ilog.concert.IloException;
import ilog.concert.IloIntExpr;
import ilog.concert.IloNumExpr;
import ilog.concert.IloObjective;
import ilog.concert.IloOr;
import ilog.concert.IloRange;
import java.io.IOException;
import java.util.Set;
import jrmp.srmp.base.XSRMPmodeler;
import jrmp.srmp.settings.Para;
import jrmp.srmp.solver.XCplSRMPsolver;
import jrmp.srmp.utils.OutputUtils;
import org.decision_deck.jmcda.structure.Alternative;
import org.decision_deck.jmcda.structure.Criterion;

public abstract class CplSRMPsolver
extends XCplSRMPsolver {
    public CplSRMPsolver(XSRMPmodeler input) throws IOException, IloException {
        super(input);
    }

    protected void addWeights(boolean display) throws IloException {
        if (display) {
            OutputUtils.lc("[i] Add " + this.nCrit + " weight variables... ");
        } else {
            OutputUtils.log("[i] Add " + this.nCrit + " weight variables... ");
        }
        int n = 0;
        while (n < this.nCrit) {
            this.w[n] = this.cplex.numVar(Para.WEIGHT_LOWER_BOUND, Para.WEIGHT_UPPER_BOUND, "w" + n);
            ++n;
        }
        this.cplex.addEq(this.cplex.sum((IloNumExpr[])this.w), 1.0, "w.norm");
        if (display) {
            OutputUtils.lcln("Done!");
        } else {
            OutputUtils.logln("Done!");
        }
    }

    protected void addNewReferenceProfile(int h, boolean display) throws IloException {
        if (display) {
            OutputUtils.lc("[i] Add a new reference profile \"p" + (h + 1) + "\"... ");
        } else {
            OutputUtils.log("[i] Add a new reference profile \"p" + (h + 1) + "\"... ");
        }
        int n = 0;
        while (n < this.nCrit) {
            this.p[h][n] = this.cplex.intVar(Para.RATING_SCALE_MIN, Para.RATING_SCALE_MAX, "p" + (h + 1) + "_" + (n + 1));
            ++n;
        }
        if (display) {
            OutputUtils.lcln("Done!");
        } else {
            OutputUtils.logln("Done!");
        }
    }

    protected void addNewRelatedVariables(int h, boolean display) throws IloException {
        if (display) {
            OutputUtils.lc("[i] Add \"p" + (h + 1) + "\"-related variables \"delta\", \"c\" and \"cw\" for each alternative in the reference set... ");
        } else {
            OutputUtils.log("[i] Add \"p" + (h + 1) + "\"-related variables \"delta\", \"c\" and \"cw\" for each alternative in the reference set... ");
        }
        int r = 0;
        while (r < this.mElte) {
            int n = 0;
            while (n < this.nCrit) {
                this.delta[h][r][n] = this.cplex.boolVar("delta" + (h + 1) + "_" + (r + 1) + "_" + (n + 1));
                int dir = this.getInput().getPrefDirValue((Criterion)this.criList.get(n));
                double g = this.getInput().getEvaluationValue((Alternative)this.eltList.get(r), (Criterion)this.criList.get(n));
                this.cplex.addLe(this.cplex.prod(Para.L, (IloNumExpr)this.cplex.diff((IloIntExpr)this.delta[h][r][n], 1)), this.cplex.prod((double)dir, this.cplex.diff(g, (IloNumExpr)this.p[h][n])), "delta_L" + (h + 1) + "_" + (r + 1) + "_" + (n + 1));
                this.cplex.addLe(this.cplex.prod((double)dir, this.cplex.diff(g, (IloNumExpr)this.p[h][n])), this.cplex.diff(this.cplex.prod(Para.L, (IloNumExpr)this.delta[h][r][n]), Para.EPSILON), "delta_e" + (h + 1) + "_" + (r + 1) + "_" + (n + 1));
                this.c[h][r][n] = this.cplex.numVar(0.0, 1.0, "c" + (h + 1) + "_" + (r + 1) + "_" + (n + 1));
                this.cplex.addLe((IloNumExpr)this.c[h][r][n], (IloNumExpr)this.w[n], "c_w" + (h + 1) + "_" + (r + 1) + "_" + (n + 1));
                this.cplex.addGe((IloNumExpr)this.c[h][r][n], 0.0, "c_zero" + (h + 1) + "_" + (r + 1) + "_" + (n + 1));
                this.cplex.addLe((IloNumExpr)this.c[h][r][n], (IloNumExpr)this.delta[h][r][n], "c_d" + (h + 1) + "_" + (r + 1) + "_" + (n + 1));
                this.cplex.addGe(this.cplex.sum((IloNumExpr)this.c[h][r][n], 1.0), this.cplex.sum((IloNumExpr)this.delta[h][r][n], (IloNumExpr)this.w[n]), "c_dwo" + (h + 1) + "_" + (r + 1) + "_" + (n + 1));
                ++n;
            }
            this.cw[h][r] = this.cplex.numVar(0.0, 1.0, "cw" + (h + 1) + "_" + (r + 1));
            this.cplex.addEq((IloNumExpr)this.cw[h][r], this.cplex.sum((IloNumExpr[])this.c[h][r]), "cw_sum" + (h + 1) + "_" + (r + 1));
            ++r;
        }
        if (display) {
            OutputUtils.lcln("Done!");
        } else {
            OutputUtils.logln("Done!");
        }
    }

    protected void addNewSlackVariable(int h, boolean display) throws IloException {
        if (display) {
            OutputUtils.lc("[i] Add \"p" + (h + 1) + "\"-related slack variables for each pairwise comparison in the reference set... ");
        } else {
            OutputUtils.log("[i] Add \"p" + (h + 1) + "\"-related slack variables for each pairwise comparison in the reference set... ");
        }
        Set compSet = this.getInput().getPairComps().asTable().cellSet();
        for (Table.Cell comp : compSet) {
            int row = this.eltList.indexOf(comp.getRowKey());
            int col = this.eltList.indexOf(comp.getColumnKey());
            this.s[row][col][h] = this.cplex.numVar(-1.0, 1.0, "s" + (h + 1) + "(" + row + "," + col + ")");
            double dir = (Double)comp.getValue();
            IloConstraint def = this.cplex.eq(this.cplex.prod(dir, this.cplex.diff((IloNumExpr)this.cw[h][row], (IloNumExpr)this.cw[h][col])), (IloNumExpr)this.s[row][col][h], "s_def" + (h + 1) + "(" + row + "," + col + ")");
            this.cplex.add((IloAddable)def);
        }
        if (display) {
            OutputUtils.lcln("Done!");
        } else {
            OutputUtils.logln("Done!");
        }
    }

    protected void setConstToSlackVars(boolean display) throws IloException {
        if (display) {
            OutputUtils.lc("[i] Transform the pairwise comparisons to linear constraints... ");
        } else {
            OutputUtils.log("[i] Transform the pairwise comparisons to linear constraints... ");
        }
        Set compSet = this.getInput().getPairComps().asTable().cellSet();
        for (Table.Cell comp : compSet) {
            IloAnd zero;
            int row = this.eltList.indexOf(comp.getRowKey());
            int col = this.eltList.indexOf(comp.getColumnKey());
            double dir = (Double)comp.getValue();
            if (dir != 0.0) {
                zero = this.cplex.and();
                IloOr positive = this.cplex.or();
                int h = 0;
                while (h < this.k) {
                    if (h == 0) {
                        IloRange frist = this.cplex.ge((IloNumExpr)this.s[row][col][(Integer)this.sigma.get(h) - 1], 0.0, "s_(6.15)" + this.sigma.get(h) + "(" + row + "," + col + ")");
                        this.cplex.add((IloAddable)frist);
                    }
                    positive.add((IloConstraint)this.cplex.ge((IloNumExpr)this.s[row][col][(Integer)this.sigma.get(h) - 1], Para.EPSILON));
                    if (h != this.k - 1) {
                        zero.add((IloConstraint)this.cplex.eq((IloNumExpr)this.s[row][col][(Integer)this.sigma.get(h) - 1], 0.0));
                    }
                    if (this.k >= 2) {
                        IloConstraint ifThen = this.cplex.ifThen((IloConstraint)zero, (IloConstraint)this.cplex.ge((IloNumExpr)this.s[row][col][(Integer)this.sigma.get(h) - 1], 0.0));
                        this.cplex.add((IloAddable)ifThen);
                    }
                    ++h;
                }
                this.cplex.add((IloAddable)positive);
                continue;
            }
            zero = this.cplex.and();
            int h = 0;
            while (h < this.k) {
                zero.add((IloConstraint)this.cplex.eq((IloNumExpr)this.s[row][col][(Integer)this.sigma.get(h) - 1], 0.0));
                ++h;
            }
            this.cplex.add((IloAddable)zero);
        }
        if (display) {
            OutputUtils.lcln("Done!");
        } else {
            OutputUtils.logln("Done!");
        }
    }

    protected void setDominanceToRefPts(boolean display) throws IloException {
        if (display) {
            OutputUtils.lc("[i] Setting dominance constraints to the reference points... ");
        } else {
            OutputUtils.log("[i] Setting dominance constraints to the reference points... ");
        }
        int h = 1;
        while (h < this.k) {
            int n = 0;
            while (n < this.nCrit) {
                int dir = this.getInput().getPrefDirValue((Criterion)this.criList.get(n));
                this.cplex.addGe((IloNumExpr)this.cplex.prod(dir, this.cplex.diff((IloIntExpr)this.p[h][n], (IloIntExpr)this.p[h - 1][n])), 0.0, "dom(" + (h + 1) + "," + h + ")_" + n);
                ++n;
            }
            ++h;
        }
        if (display) {
            OutputUtils.lcln("Done!");
        } else {
            OutputUtils.logln("Done!");
        }
    }

    @Override
    public abstract void solve(boolean var1);

    protected abstract IloObjective addObjective(boolean var1) throws IloException;
}

