/*
 * Decompiled with CFR 0.152.
 */
package jrmp.srmp.solver;

import com.google.common.collect.Table;
import ilog.concert.IloAddable;
import ilog.concert.IloAnd;
import ilog.concert.IloConstraint;
import ilog.concert.IloException;
import ilog.concert.IloNumExpr;
import ilog.concert.IloNumVar;
import ilog.concert.IloObjective;
import ilog.concert.IloRange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import jrmp.srmp.base.XSRMPmodeler;
import jrmp.srmp.settings.Config;
import jrmp.srmp.settings.Para;
import jrmp.srmp.solver.CplSRMPsolver;
import jrmp.srmp.utils.Factorial;
import jrmp.srmp.utils.OutputUtils;
import jrmp.srmp.utils.Permutations;

public class CplSolverJinyan
extends CplSRMPsolver {
    private Integer representableInt = -1;
    private Double phi = new Double(-1.0);

    public CplSolverJinyan(XSRMPmodeler input) throws IOException, IloException {
        super(input);
        this.cs = new IloNumVar[this.numPC];
        this.gamma = new IloNumVar[this.numPC];
        OutputUtils.lscln("\n[S-RMP Solver Ver.JINYAN,2013]");
    }

    @Override
    public void solve(boolean display) {
        try {
            while (!this.isSolved() && this.k <= Para.MAX_NUM_REF_PTS) {
                int num_lexico = Factorial.fac(this.k);
                this.lexicoList = Permutations.getAll(this.k);
                OutputUtils.lcln("[i] Try with " + this.k + " reference point(s). " + num_lexico + " possible lexicographic order(s) exist(s).");
                int t = 0;
                while (t < this.lexicoList.size()) {
                    this.sigma = (ArrayList)this.lexicoList.get(t);
                    this.addWeights(display);
                    int h = 0;
                    while (h < this.k) {
                        this.addNewReferenceProfile(h, display);
                        this.addNewRelatedVariables(h, display);
                        this.addNewSlackVariable(h, display);
                        ++h;
                    }
                    this.setConstToSlackVars(display);
                    this.addCsAndGamma(display);
                    if (this.k >= 2) {
                        this.setDominanceToRefPts(display);
                    }
                    this.obj = this.addObjective(display);
                    OutputUtils.lcln("[i] " + (t + 1) + "/" + num_lexico + " Try with the order " + this.sigma + " ...");
                    this.exportModel(this.sigma);
                    boolean bool = this.cplexSolve();
                    if (Config.CHECK_ALL_LEXICOS) {
                        if (bool) {
                            if (this.isAcceptable()) {
                                this.doIfCplexSolved(this.sigma);
                                if (t + 1 != num_lexico) {
                                    this.cplexClear(this.obj);
                                    OutputUtils.lcln("[i] Check other lexico-orders...");
                                } else {
                                    OutputUtils.lcln("[i] All lexico-orders have been checked.");
                                    this.setOutput(this.getSolution(this.findTheBestSolution("max")));
                                }
                            } else {
                                this.ifNotCompatible();
                            }
                        } else {
                            OutputUtils.lcln("[i] Solution not found!");
                            if (t + 1 != num_lexico) {
                                this.cplexClear(this.obj);
                                OutputUtils.lcln("[i] Check other lexico-orders...");
                            } else {
                                OutputUtils.lcln("[i] All lexico-orders have been checked.");
                                if (this.isSolved()) {
                                    this.setOutput(this.getSolution(this.findTheBestSolution("max")));
                                } else {
                                    this.cplexClear(this.obj);
                                    OutputUtils.lcln("[i] Restart solving the problem...");
                                }
                            }
                        }
                    } else if (bool) {
                        if (this.isAcceptable()) {
                            this.doIfCplexSolved(this.sigma);
                            this.setOutput(this.getSolution(this.findTheBestSolution("max")));
                            break;
                        }
                        this.ifNotCompatible();
                    } else {
                        OutputUtils.lcln("[i] Solution not found!");
                        this.cplexClear(this.obj);
                        OutputUtils.logln("[i] Restart solving the problem...");
                    }
                    ++t;
                }
                if (this.isSolved()) {
                    this.cplexEnd();
                    break;
                }
                ++this.k;
            }
            this.cplexUnsolvedStop();
        }
        catch (IloException e) {
            System.err.println("Concert exception '" + (Object)((Object)e) + "' caught");
        }
    }

    protected void addCsAndGamma(boolean display) throws IloException {
        if (display) {
            OutputUtils.lc("[i] Add binary variables gamma... ");
        } else {
            OutputUtils.log("[i] Add binary variables gamma... ");
        }
        int i = 0;
        while (i < this.numPC) {
            this.cs[i] = this.cplex.numVar(-100.0, 100.0, "cs_" + (i + 1));
            this.gamma[i] = this.cplex.boolVar("gamma_" + (i + 1));
            int row = this.eltList.indexOf(((Table.Cell)this.pCoList.get(i)).getRowKey());
            int col = this.eltList.indexOf(((Table.Cell)this.pCoList.get(i)).getColumnKey());
            IloNumVar sum = this.s[row][col][0];
            int h = 1;
            while (this.k > 1 && h < this.k) {
                sum = this.cplex.sum((IloNumExpr)sum, (IloNumExpr)this.s[row][col][h]);
                ++h;
            }
            this.cplex.addEq((IloNumExpr)this.cs[i], (IloNumExpr)sum, "cs_" + (i + 1) + "def" + "(" + row + "," + col + ")");
            this.cplex.addGe((IloNumExpr)this.cs[i], this.cplex.prod(Para.EPSILON, (IloNumExpr)this.gamma[i]), "gamma_e_" + i);
            this.cplex.addLe((IloNumExpr)this.cs[i], this.cplex.prod(Para.L, (IloNumExpr)this.gamma[i]), "gamma_L_" + i);
            ++i;
        }
        if (display) {
            OutputUtils.lcln("Done!");
        } else {
            OutputUtils.logln("Done!");
        }
    }

    @Override
    protected void setConstToSlackVars(boolean display) throws IloException {
        if (display) {
            OutputUtils.lc("[i] Transform the pairwise comparisons to linear constraints... ");
        } else {
            OutputUtils.log("[i] Transform the pairwise comparisons to linear constraints... ");
        }
        Set compSet = this.getInput().getPairComps().asTable().cellSet();
        for (Table.Cell comp : compSet) {
            int h;
            IloAnd zero;
            int row = this.eltList.indexOf(comp.getRowKey());
            int col = this.eltList.indexOf(comp.getColumnKey());
            double dir = (Double)comp.getValue();
            if (dir != 0.0) {
                zero = this.cplex.and();
                h = 0;
                while (h < this.k) {
                    if (h == 0) {
                        IloRange frist = this.cplex.ge((IloNumExpr)this.s[row][col][(Integer)this.sigma.get(h) - 1], 0.0, "s_(6.15)" + this.sigma.get(h) + "(" + row + "," + col + ")");
                        this.cplex.add((IloAddable)frist);
                    }
                    if (h != this.k - 1) {
                        zero.add((IloConstraint)this.cplex.eq((IloNumExpr)this.s[row][col][(Integer)this.sigma.get(h) - 1], 0.0));
                    }
                    if (this.k >= 2) {
                        IloConstraint ifThen = this.cplex.ifThen((IloConstraint)zero, (IloConstraint)this.cplex.ge((IloNumExpr)this.s[row][col][(Integer)this.sigma.get(h) - 1], 0.0));
                        this.cplex.add((IloAddable)ifThen);
                    }
                    ++h;
                }
                continue;
            }
            zero = this.cplex.and();
            h = 0;
            while (h < this.k) {
                zero.add((IloConstraint)this.cplex.eq((IloNumExpr)this.s[row][col][(Integer)this.sigma.get(h) - 1], 0.0));
                ++h;
            }
            this.cplex.add((IloAddable)zero);
        }
        if (display) {
            OutputUtils.lcln("Done!");
        } else {
            OutputUtils.logln("Done!");
        }
    }

    @Override
    protected IloObjective addObjective(boolean display) throws IloException {
        if (display) {
            OutputUtils.lc("[i] Add objective function... ");
        } else {
            OutputUtils.log("[i] Add objective function... ");
        }
        IloObjective re = this.cplex.addMaximize();
        this.representable = this.cplex.numVar(0.0, (double)this.numPC, "representable");
        this.cplex.addEq((IloNumExpr)this.representable, this.cplex.sum((IloNumExpr[])this.gamma), "representable_def");
        re.setExpr((IloNumExpr)this.representable);
        if (display) {
            OutputUtils.lcln("Done!");
        } else {
            OutputUtils.logln("Done!");
        }
        return re;
    }

    @Override
    protected void doIfCplexSolved(ArrayList<Integer> sigma) throws IloException {
        super.doIfCplexSolved(sigma);
        this.setSumOfSlacks(this.getResultOfSumOfSlacks());
        this.setGamma(this.getResultOfGamma());
    }

    protected boolean isAcceptable() throws IloException {
        this.setRepresentableInt(new Double(Math.rint(this.cplex.getValue(this.representable))).intValue());
        if (this.getCompatibility() < 0.0) {
            this.setCompatibility(this.calculateCompatibility());
        }
        OutputUtils.lscln("[i] The inferred model is " + OutputUtils.centi.format(this.getCompatibility() * 100.0) + "% compatible with the input." + "(Estimated >=" + (1.0 - Para.ESTIMATED_INCONS_LEVEL) * 100.0 + "%)");
        if (this.getCompatibility() >= 1.0 - Para.ESTIMATED_INCONS_LEVEL) {
            return true;
        }
        this.setRepresentableInt(-1);
        this.setCompatibility(-1.0);
        return false;
    }

    protected Double calculateCompatibility() throws IloException {
        if (this.cplex != null && this.numPC != 0) {
            Double re = (double)this.getRepresentableInt().intValue() / (double)this.numPC;
            return re;
        }
        return -1.0;
    }

    public Double getCompatibility() {
        return this.phi;
    }

    protected void setCompatibility(double value) throws IloException {
        this.phi = value;
    }

    protected void ifNotCompatible() throws IloException {
        OutputUtils.lcln("[i] Solution not acceptable!");
        this.cplexClear(this.obj);
        OutputUtils.logln("[i] Restart solving the problem...");
    }

    public String getGammaStatus() {
        String re = "[i] Gamma status: ";
        Double[] gamma = this.getGamma();
        int i = 0;
        while (i < gamma.length) {
            if (i % 5 == 0) {
                re = String.valueOf(re) + "\n";
            }
            re = String.valueOf(re) + "\t(" + (i + 1) + "," + gamma[i].intValue() + ")";
            ++i;
        }
        return re;
    }

    public String getSlackStatus() {
        String re = "[i] Slack status: ";
        Double[] slack = this.getSumOfSlacks();
        int i = 0;
        while (i < slack.length) {
            if (i % 5 == 0) {
                re = String.valueOf(re) + "\n";
            }
            re = String.valueOf(re) + "\t(" + (i + 1) + "," + OutputUtils.tenmi.format(slack[i]) + ")";
            ++i;
        }
        return re;
    }

    public Integer getRepresentableInt() {
        return this.representableInt;
    }

    protected void setRepresentableInt(Integer representableInt) {
        this.representableInt = representableInt;
    }
}

