/*
 * Decompiled with CFR 0.152.
 */
package jrmp.srmp.solver;

import com.google.common.collect.Table;
import ilog.concert.IloException;
import ilog.concert.IloNumExpr;
import ilog.concert.IloObjective;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import jrmp.srmp.base.XSRMPmodeler;
import jrmp.srmp.settings.Config;
import jrmp.srmp.settings.Para;
import jrmp.srmp.solver.CplSRMPsolver;
import jrmp.srmp.utils.Factorial;
import jrmp.srmp.utils.OutputUtils;
import jrmp.srmp.utils.Permutations;

public class CplSolverJun
extends CplSRMPsolver {
    public CplSolverJun(XSRMPmodeler input) throws IloException, IOException {
        super(input);
        OutputUtils.lscln("\n[S-RMP Solver Ver.JUN,2012]");
    }

    @Override
    public void solve(boolean display) {
        try {
            while (!this.isSolved() && this.k <= Para.MAX_NUM_REF_PTS) {
                int num_lexico = Factorial.fac(this.k);
                this.lexicoList = Permutations.getAll(this.k);
                OutputUtils.lcln("[i] Try with " + this.k + " reference point(s). " + num_lexico + " possible lexicographic order(s) exist(s).");
                int t = 0;
                while (t < this.lexicoList.size()) {
                    this.sigma = (ArrayList)this.lexicoList.get(t);
                    this.addWeights(display);
                    int h = 0;
                    while (h < this.k) {
                        this.addNewReferenceProfile(h, display);
                        this.addNewRelatedVariables(h, display);
                        this.addNewSlackVariable(h, display);
                        ++h;
                    }
                    this.setConstToSlackVars(display);
                    if (this.k >= 2) {
                        this.setDominanceToRefPts(display);
                    }
                    IloObjective obj = this.addObjective(display);
                    OutputUtils.lcln("[i] " + (t + 1) + "/" + num_lexico + " Try with the order " + this.sigma + " ...");
                    this.exportModel(this.sigma);
                    boolean bool = this.cplexSolve();
                    if (Config.CHECK_ALL_LEXICOS) {
                        if (bool) {
                            this.doIfCplexSolved(this.sigma);
                            if (t + 1 != num_lexico) {
                                this.cplexClear(obj);
                                OutputUtils.lcln("[i] Check other lexico-orders...");
                            } else {
                                OutputUtils.lcln("[i] All lexico-orders have been checked.");
                                this.setOutput(this.getSolution(this.findTheBestSolution("max")));
                            }
                        } else {
                            OutputUtils.lcln("[i] Solution not found!");
                            if (t + 1 != num_lexico) {
                                this.cplexClear(obj);
                                OutputUtils.lcln("[i] Check other lexico-orders...");
                            } else {
                                OutputUtils.lcln("[i] All lexico-orders have been checked.");
                                if (this.isSolved()) {
                                    this.setOutput(this.getSolution(this.findTheBestSolution("max")));
                                } else {
                                    this.cplexClear(obj);
                                    OutputUtils.lcln("[i] Restart solving the problem...");
                                }
                            }
                        }
                    } else {
                        if (bool) {
                            this.doIfCplexSolved(this.sigma);
                            this.setOutput(this.getSolution(this.findTheBestSolution("max")));
                            break;
                        }
                        OutputUtils.lcln("[i] Solution not found!");
                        this.cplexClear(obj);
                        OutputUtils.logln("[i] Restart solving the problem...");
                    }
                    ++t;
                }
                if (this.isSolved()) {
                    this.cplexEnd();
                    break;
                }
                ++this.k;
            }
            this.cplexUnsolvedStop();
        }
        catch (IloException e) {
            System.err.println("Concert exception '" + (Object)((Object)e) + "' caught");
        }
    }

    @Override
    protected IloObjective addObjective(boolean display) throws IloException {
        if (display) {
            OutputUtils.lc("[i] Add objective function... ");
        } else {
            OutputUtils.log("[i] Add objective function... ");
        }
        IloObjective re = this.cplex.addMaximize();
        this.s_min = this.cplex.numVar(0.0, 1.0, "s_min");
        Set compSet = this.getInput().getPairComps().asTable().cellSet();
        for (Table.Cell comp : compSet) {
            int row = this.eltList.indexOf(comp.getRowKey());
            int col = this.eltList.indexOf(comp.getColumnKey());
            int h = 0;
            while (h < this.k) {
                if (h == 0) {
                    this.cplex.addLe(this.cplex.diff((IloNumExpr)this.s_min, this.cplex.abs((IloNumExpr)this.s[row][col][h])), 0.0);
                }
                ++h;
            }
        }
        if (display) {
            OutputUtils.lcln("Done!");
        } else {
            OutputUtils.logln("Done!");
        }
        re.setExpr((IloNumExpr)this.s_min);
        return re;
    }
}

