/*
 * Decompiled with CFR 0.152.
 */
package jrmp.srmp.utils;

import com.google.common.io.Files;
import com.google.common.io.OutputSupplier;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import jrmp.srmp.settings.Config;
import jrmp.srmp.utils.MsgUtils;

public class OutputUtils {
    public static DecimalFormat tenmi = new DecimalFormat("0.0000");
    public static DecimalFormat milli = new DecimalFormat("0.000");
    public static DecimalFormat centi = new DecimalFormat("0.00");
    public static DecimalFormat deci = new DecimalFormat("0.0");
    public static DecimalFormat integ = new DecimalFormat("0");
    public static SimpleDateFormat date = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss");
    static final String summaryPath = Config.OUTPUT_FOLDER;
    static final String logFilePath = Config.OUTPUT_FOLDER;
    static final String summaryName = "/summary_" + Config.DEFAULT_EXP_NAME + ".txt";
    static final String logFileName = "/log_" + Config.DEFAULT_EXP_NAME + ".log";
    private File summary;
    private File logFile;
    private static OutputSupplier<FileOutputStream> summaryStream;
    private static OutputSupplier<FileOutputStream> logFileStream;
    private static PrintWriter summaryPrinter;
    private static PrintWriter logFilePrinter;

    public OutputUtils() throws IOException {
        this.prepare();
        this.summary = new File(String.valueOf(Config.RESOURCES_FOLDER) + summaryPath + summaryName);
        this.logFile = new File(String.valueOf(Config.RESOURCES_FOLDER) + logFilePath + logFileName);
        summaryStream = Files.newOutputStreamSupplier((File)this.summary, (boolean)true);
        logFileStream = Files.newOutputStreamSupplier((File)this.logFile, (boolean)true);
        summaryPrinter = new PrintWriter((OutputStream)summaryStream.getOutput());
        logFilePrinter = new PrintWriter((OutputStream)logFileStream.getOutput());
        OutputUtils.consoleln("\n[START]\n");
        this.writeSummaryHeader();
        this.writeLogFileHeader();
    }

    private void prepare() {
        File expFolder;
        OutputUtils.console("[i] Preparing...");
        File resourceFolder = new File(Config.RESOURCES_FOLDER);
        if (!resourceFolder.exists()) {
            resourceFolder.mkdir();
            OutputUtils.console(".");
        }
        if (!(expFolder = new File(String.valueOf(Config.RESOURCES_FOLDER) + "/" + Config.DEFAULT_EXP_NAME)).exists()) {
            expFolder.mkdir();
            OutputUtils.console(".");
        }
        File inputFolder = new File(String.valueOf(Config.RESOURCES_FOLDER) + Config.INPUT_FOLDER);
        File outputFolder = new File(String.valueOf(Config.RESOURCES_FOLDER) + Config.OUTPUT_FOLDER);
        File modelsFolder = new File(String.valueOf(Config.RESOURCES_FOLDER) + Config.MODEL_FOLDER);
        File solsFolder = new File(String.valueOf(Config.RESOURCES_FOLDER) + Config.SOL_FOLDER);
        File xmlsFolder = new File(String.valueOf(Config.RESOURCES_FOLDER) + Config.XML_FOLDER);
        if (!inputFolder.exists()) {
            inputFolder.mkdir();
            OutputUtils.console(".");
        }
        if (!outputFolder.exists()) {
            outputFolder.mkdir();
            OutputUtils.console(".");
        }
        if (!modelsFolder.exists()) {
            modelsFolder.mkdir();
            OutputUtils.console(".");
        }
        if (!solsFolder.exists()) {
            solsFolder.mkdir();
            OutputUtils.console(".");
        }
        if (!xmlsFolder.exists()) {
            xmlsFolder.mkdir();
            OutputUtils.console(".");
        }
        OutputUtils.consoleln(" Completed!");
    }

    private void writeSummaryHeader() throws IOException {
        OutputSupplier tempSupplier = Files.newOutputStreamSupplier((File)this.summary, (boolean)false);
        PrintWriter headWriter = new PrintWriter((OutputStream)tempSupplier.getOutput());
        headWriter.println("\n---------- General informations ----------");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        headWriter.println("Date\t:" + df.format(new Date()));
        Properties prop = new Properties(System.getProperties());
        headWriter.println("Owner\t:" + prop.getProperty("user.name").toUpperCase());
        headWriter.print("O.S.\t:" + prop.getProperty("os.arch") + " " + prop.getProperty("os.name").toUpperCase() + " platform");
        headWriter.println(" (version " + prop.getProperty("os.version") + ")");
        headWriter.println("Ref\t:" + Config.DEFAULT_EXP_NAME);
        headWriter.println("Exp.ID\t:" + Config.DEFAULT_EXP_ID);
        headWriter.println("\n---------- SUMMARY REPORT ----------\n");
        headWriter.close();
    }

    private void writeLogFileHeader() throws IOException {
        OutputSupplier tempSupplier = Files.newOutputStreamSupplier((File)this.logFile, (boolean)false);
        PrintWriter headWriter = new PrintWriter((OutputStream)tempSupplier.getOutput());
        headWriter.println("\n---------- General informations ----------");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        headWriter.println("Date\t:" + df.format(new Date()));
        Properties prop = new Properties(System.getProperties());
        headWriter.println("Owner\t:" + prop.getProperty("user.name").toUpperCase());
        headWriter.print("O.S.\t:" + prop.getProperty("os.arch") + " " + prop.getProperty("os.name").toUpperCase() + " platform");
        headWriter.println(" (version " + prop.getProperty("os.version") + ")");
        headWriter.println("Ref\t:" + Config.DEFAULT_EXP_NAME);
        headWriter.println("Exp.ID\t:" + Config.DEFAULT_EXP_ID);
        headWriter.println("\n---------- LOG INFORMATION ----------\n");
        headWriter.close();
    }

    public void end() throws IOException {
        OutputUtils.lsln("\n---------- END OF OUTPUTS ----------");
        summaryPrinter.close();
        logFilePrinter.close();
        System.in.close();
        OutputUtils.consoleln("\n[END]\n");
    }

    public static void summary(Object content) {
        if (content != null) {
            summaryPrinter.print(content);
            summaryPrinter.flush();
        } else {
            summaryPrinter.print("-");
            summaryPrinter.flush();
        }
    }

    public static void summaryln(Object content) {
        if (content != null) {
            summaryPrinter.println(content);
            summaryPrinter.flush();
        } else {
            summaryPrinter.println("-");
            summaryPrinter.flush();
        }
    }

    public static void log(Object content) {
        if (content != null) {
            logFilePrinter.print(content);
            logFilePrinter.flush();
        } else {
            logFilePrinter.print("-");
            logFilePrinter.flush();
        }
    }

    public static void logln(Object content) {
        if (content != null) {
            logFilePrinter.println(content);
            logFilePrinter.flush();
        } else {
            logFilePrinter.println("-");
            logFilePrinter.flush();
        }
    }

    public static void console(Object content) {
        if (content != null) {
            System.out.print(content);
        } else {
            System.out.print("null");
        }
    }

    public static void consoleln(Object content) {
        if (content != null) {
            System.out.println(content);
        } else {
            System.out.println("null");
        }
    }

    public static void ls(Object content) {
        OutputUtils.log(content);
        OutputUtils.summary(content);
    }

    public static void lsln(Object content) {
        OutputUtils.logln(content);
        OutputUtils.summaryln(content);
    }

    public static void lc(Object content) {
        OutputUtils.log(content);
        OutputUtils.console(content);
        MsgUtils.addMethodMessage(content.toString());
    }

    public static void lcln(Object content) {
        OutputUtils.logln(content);
        OutputUtils.consoleln(content);
        MsgUtils.addMethodMessage(content.toString());
    }

    public static void lsc(Object content) {
        OutputUtils.log(content);
        OutputUtils.summary(content);
        OutputUtils.console(content);
    }

    public static void lscln(Object content) {
        OutputUtils.logln(content);
        OutputUtils.summaryln(content);
        OutputUtils.consoleln(content);
    }

    public static String getSummaryPath() {
        return summaryPath;
    }

    public static String getLogFilePath() {
        return logFilePath;
    }

    public static String getSummaryName() {
        return summaryName;
    }

    public static String getLogFileName() {
        return logFileName;
    }

    public static OutputSupplier<FileOutputStream> getSummaryStream() {
        return summaryStream;
    }

    public static OutputSupplier<FileOutputStream> getLogFileStream() {
        return logFileStream;
    }
}

