/*
 * Decompiled with CFR 0.152.
 */
package jrmp.srmp.utils;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import jrmp.srmp.utils.OutputUtils;
import jrmp.srmp.utils.Ranking;
import org.decision_deck.jmcda.structure.Alternative;
import org.decision_deck.utils.matrix.Matrixes;
import org.decision_deck.utils.matrix.SparseMatrixD;
import org.decision_deck.utils.relation.graph.Preorder;

public class RankingUtils {
    public static Ranking<Alternative> getRanking(SparseMatrixD<Alternative, Alternative> matrix) {
        if (matrix != null) {
            int mAlte = RankingUtils.countAlternatives(matrix);
            Ranking<Alternative> re = new Ranking<Alternative>(mAlte);
            for (Alternative alteR : matrix.getRows()) {
                int neg1 = mAlte;
                int zero = -1;
                for (Alternative alteC : matrix.getColumns()) {
                    if (matrix.getValue((Object)alteR, (Object)alteC) == 1.0) {
                        --neg1;
                    }
                    if (matrix.getValue((Object)alteR, (Object)alteC) != 0.0) continue;
                    ++zero;
                }
                int rank = neg1 - zero;
                re.put(alteR, rank);
            }
            re.removeEmptyRanks();
            return re;
        }
        OutputUtils.lcln("[i] Building the ranking list... Failed!");
        return null;
    }

    public static Preorder<Alternative> getPreorder(SparseMatrixD<Alternative, Alternative> matrix) {
        Preorder re = new Preorder();
        Ranking<Alternative> ranking = RankingUtils.getRanking(matrix);
        int i = 0;
        while (i < ranking.sizeOf()) {
            re.put(ranking.getElementsSet(i), i + 1);
            ++i;
        }
        return re;
    }

    public static SparseMatrixD<Alternative, Alternative> toSparseMatrixD(Preorder<Alternative> preorder) {
        SparseMatrixD re = Matrixes.newSparseD();
        int i = 1;
        while (i < preorder.getRanksCount()) {
            ArrayList list1 = new ArrayList(preorder.get(i));
            ArrayList list2 = new ArrayList(preorder.get(i + 1));
            int j = 0;
            while (j < list1.size() - 1) {
                re.put((Object)((Alternative)list1.get(j)), (Object)((Alternative)list1.get(j + 1)), 1.0);
                re.put((Object)((Alternative)list1.get(j + 1)), (Object)((Alternative)list1.get(j)), 1.0);
                int k = 0;
                while (k < list2.size()) {
                    re.put((Object)((Alternative)list1.get(j)), (Object)((Alternative)list2.get(k)), 1.0);
                    ++k;
                }
                ++j;
            }
            int k = 0;
            while (k < list2.size()) {
                re.put((Object)((Alternative)list1.get(list1.size() - 1)), (Object)((Alternative)list2.get(k)), 1.0);
                ++k;
            }
            ++i;
        }
        return re;
    }

    public static Integer getIndifferenceCount(SparseMatrixD<Alternative, Alternative> matrix) {
        if (matrix != null) {
            int re = -RankingUtils.countAlternatives(matrix).intValue();
            for (Alternative alteR : matrix.getRows()) {
                for (Alternative alteC : matrix.getColumns()) {
                    if (matrix.getValue((Object)alteR, (Object)alteC) != 0.0) continue;
                    ++re;
                }
            }
            return re / 2;
        }
        return 0;
    }

    private static Integer countAlternatives(SparseMatrixD<Alternative, Alternative> matrix) {
        Set columnSet = matrix.getColumns();
        Set rowSet = matrix.getRows();
        LinkedHashSet tempo = new LinkedHashSet();
        tempo.addAll(columnSet);
        tempo.addAll(rowSet);
        return tempo.size();
    }
}

