/*
 * Decompiled with CFR 0.152.
 */
package main;

import componentes.Alternativa;
import componentes.Alternativas;
import componentes.Criterio;
import componentes.Criterios;
import componentes.Matrix;
import componentes.Par;
import componentes.Peso;
import componentes.Pesos;
import componentes.Situation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.values.XmlValueOutOfRangeException;
import org.decisionDeck.x2012.xmcda220.Alternative;
import org.decisionDeck.x2012.xmcda220.AlternativeOnCriteriaPerformances;
import org.decisionDeck.x2012.xmcda220.AlternativeValue;
import org.decisionDeck.x2012.xmcda220.Alternatives;
import org.decisionDeck.x2012.xmcda220.AlternativesValues;
import org.decisionDeck.x2012.xmcda220.Criteria;
import org.decisionDeck.x2012.xmcda220.Criterion;
import org.decisionDeck.x2012.xmcda220.PerformanceTable;
import org.decisionDeck.x2012.xmcda220.Value;
import org.decisionDeck.x2012.xmcda220.Values;
import org.decisionDeck.x2012.xmcda220.XMCDADocument;

public class ReadXMCDA {
    public static Criterios readCriteria(XMCDADocument.XMCDA xmcda) {
        Criteria crit = xmcda.getCriteriaArray(0);
        Criterion[] criterion = crit.getCriterionArray();
        Criterios Cri = new Criterios();
        int i = 0;
        while (i < criterion.length) {
            boolean[] active = criterion[i].getActiveArray();
            Criterio criton = active.length > 0 ? new Criterio(criterion[i].getId(), criterion[i].getName(), active[0]) : new Criterio(criterion[i].getId(), criterion[i].getName(), true);
            Cri.addCriterion(criton);
            ++i;
        }
        return Cri;
    }

    public static Alternativas readAlternatives(XMCDADocument.XMCDA xmcda) {
        Alternatives alts = xmcda.getAlternativesArray(0);
        Alternative[] alt = alts.getAlternativeArray();
        Alternativas alters = new Alternativas();
        int i = 0;
        while (i < alt.length) {
            boolean[] active = alt[i].getActiveArray();
            Alternativa alter = active.length > 0 ? new Alternativa(alt[i].getId(), alt[i].getName(), active[0]) : new Alternativa(alt[i].getId(), alt[i].getName(), true);
            alters.addAlternative(alter);
            ++i;
        }
        return alters;
    }

    public static Pesos readWeights(XMCDADocument.XMCDA xmcda) {
        AlternativesValues AltersValues = xmcda.getAlternativesValuesArray(0);
        AlternativeValue AlterValue = AltersValues.getAlternativeValueArray(0);
        Pesos weights = new Pesos();
        Values values = AlterValue.getValuesArray(0);
        Value[] value = values.getValueArray();
        int x = 0;
        while (x < value.length) {
            float a = 0.0f;
            a = value[x].isSetInteger() ? (float)value[x].getInteger() : (value[x].isSetReal() ? value[x].getReal() : 0.0f);
            Peso weight = new Peso(a);
            weights.putWeight(weight);
            ++x;
        }
        return weights;
    }

    public static Matrix<Par<Alternativa, Criterio>, Double> readPreference(XMCDADocument.XMCDA xmcda) {
        PerformanceTable alterCritValues = xmcda.getPerformanceTableArray(0);
        AlternativeOnCriteriaPerformances[] alterCritValue = alterCritValues.getAlternativePerformancesArray();
        Matrix<Par<Alternativa, Criterio>, Double> matrix = new Matrix<Par<Alternativa, Criterio>, Double>();
        int i = 0;
        while (i < alterCritValue.length) {
            String Id = alterCritValue[i].getAlternativeID();
            AlternativeOnCriteriaPerformances.Performance[] valuesCriterion = alterCritValue[i].getPerformanceArray();
            Alternativa alter = new Alternativa(Id, true);
            int x = 0;
            while (x < valuesCriterion.length) {
                String Id2 = valuesCriterion[x].getCriterionID();
                Criterio criton = new Criterio(Id2, true);
                Par<Alternativa, Criterio> pair = new Par<Alternativa, Criterio>(alter, criton);
                Value value = valuesCriterion[x].getValue();
                if (value.isSetInteger()) {
                    try {
                        matrix.setValue(pair, Double.valueOf(value.getInteger()));
                    }
                    catch (XmlValueOutOfRangeException ex) {
                        matrix.setValue(pair, null);
                    }
                } else if (value.isSetReal()) {
                    matrix.setValue(pair, Double.valueOf(value.getReal()));
                } else {
                    matrix.setValue(pair, null);
                }
                ++x;
            }
            ++i;
        }
        return matrix;
    }

    public static boolean validateXml(XmlObject xml, ArrayList<XmlError> errorList) {
        XmlOptions validateOptions = new XmlOptions();
        validateOptions.setErrorListener(errorList);
        boolean isValid = xml.validate(validateOptions);
        return isValid;
    }

    public static Situation readData(File[] listFile, ArrayList<XmlError> errorList) throws XmlException, IOException {
        Situation situation = new Situation();
        int x = 0;
        while (x < listFile.length) {
            File f = listFile[x];
            XMCDADocument xd = XMCDADocument.Factory.parse((File)f);
            if (ReadXMCDA.validateXml((XmlObject)xd, errorList)) {
                AlternativesValues[] xmlCritsValsList;
                XMCDADocument.XMCDA xmcda = xd.getXMCDA();
                Criteria[] xmlCritsList = xmcda.getCriteriaArray();
                if (xmlCritsList.length > 0) {
                    Criterios crits = ReadXMCDA.readCriteria(xmcda);
                    situation.setCriteria(crits);
                }
                if ((xmlCritsValsList = xmcda.getAlternativesValuesArray()).length > 0) {
                    Pesos pesos = ReadXMCDA.readWeights(xmcda);
                    situation.setWeights(pesos);
                }
            }
            ++x;
        }
        return situation;
    }
}

