/*
 * Decompiled with CFR 0.152.
 */
package componentes;

public class Peso
implements Comparable<Peso> {
    private final double weight;

    public Peso(double weight) {
        if (weight < 0.0) {
            throw new IllegalArgumentException("Invalid weight: " + weight + ".");
        }
        this.weight = weight;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Peso other = (Peso)obj;
        return Double.doubleToLongBits(this.weight) == Double.doubleToLongBits(other.weight);
    }

    public double getValue() {
        return this.weight;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.weight);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "Weight [" + this.weight + "]";
    }

    @Override
    public int compareTo(Peso w2) {
        return Double.compare(this.weight, w2.weight);
    }
}

