/*
 * Decompiled with CFR 0.152.
 */
package componentes;

import componentes.Weight;
import java.util.ArrayList;

public class Weights {
    public static final double IMPRECISION = (double)1.0E-6f;
    private ArrayList<Weight> map = new ArrayList();

    public int size() {
        return this.map.size();
    }

    public void addWeights(float[] weights) {
        float[] fArray = weights;
        int n = weights.length;
        int n2 = 0;
        while (n2 < n) {
            float weight = fArray[n2];
            this.map.add(new Weight(weight));
            ++n2;
        }
    }

    public void addWeight(Weight weight) {
        this.map.add(weight);
    }

    public Weight[] getWeights() {
        Weight[] weight = new Weight[this.map.size()];
        int i = 0;
        i = 0;
        while (i < this.map.size()) {
            weight[i] = this.map.get(i);
            ++i;
        }
        return weight;
    }

    public float[] getWeightsValues() {
        float[] weight = new float[this.map.size()];
        int i = 0;
        i = 0;
        while (i < this.map.size()) {
            weight[i] = (float)this.map.get(i).getValue();
            ++i;
        }
        return weight;
    }

    public double getSum() {
        double sum = this.recompute();
        return sum;
    }

    public boolean isNormalized() {
        double sum = this.recompute();
        boolean sumToOne = Math.abs(sum - 1.0) < (double)1.0E-6f;
        return sumToOne;
    }

    private double recompute() {
        double sum = 0.0;
        Weight[] weightArray = this.getWeights();
        int n = weightArray.length;
        int n2 = 0;
        while (n2 < n) {
            Weight weight = weightArray[n2];
            double value = weight.getValue();
            sum += value;
            ++n2;
        }
        return sum;
    }

    public void generateWeightVector(int n, String policy) {
        float[] w = new float[n];
        float a = 0.0f;
        float b = 1.0f;
        if (policy.equals("MOST")) {
            a = 0.0f;
            b = 0.8f;
        } else if (policy.equals("AT_LEAST_HALF")) {
            a = 0.0f;
            b = 0.5f;
        } else if (policy.equals("AS_MANY_AS_POSSIBLE")) {
            a = 0.5f;
            b = 1.0f;
        } else if (policy.equals("AVERAGE")) {
            a = 0.0f;
            b = 1.0f;
        } else if (policy.equals("WORST")) {
            a = 0.7f;
            b = 0.9f;
        }
        int i = 1;
        while (i <= n) {
            w[i - 1] = Weights.Q(a, b, (float)i / (float)n) - Weights.Q(a, b, (float)(i - 1) / (float)n);
            ++i;
        }
        float[] fArray = w;
        int n2 = w.length;
        int n3 = 0;
        while (n3 < n2) {
            float weight = fArray[n3];
            this.map.add(new Weight(weight));
            ++n3;
        }
    }

    public static float Q(float a, float b, float r) {
        if (r < a) {
            return 0.0f;
        }
        if (r > b) {
            return 1.0f;
        }
        return (r - a) / (b - a);
    }
}

