/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import componentes.Alternativa;
import componentes.Criterio;
import componentes.Label;
import componentes.Situation;
import componentes.Weights;
import java.util.Arrays;
import java.util.HashMap;

public class ULOWA {
    Situation situation;
    private HashMap<Alternativa, Label> res = new HashMap();
    Label[] labels;
    Weights weights;

    public ULOWA(Situation situation) {
        this.labels = situation.getFuzzyVariable().getAllLabel();
        this.situation = situation;
        this.weights = situation.getWeights();
    }

    public HashMap<Alternativa, Label> calculated() {
        Label[] labels2agg = new Label[this.situation.getCriteriaCount()];
        Alternativa[] alternativaArray = this.situation.getAlternatives().getAllAlternative();
        int n = alternativaArray.length;
        int n2 = 0;
        while (n2 < n) {
            Alternativa alter = alternativaArray[n2];
            int i = 0;
            Criterio[] criterioArray = this.situation.getCriteria().getAllCriterion();
            int n3 = criterioArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Criterio crit = criterioArray[n4];
                String nameLabel = this.situation.getEvaluation(alter, crit);
                labels2agg[i++] = this.situation.getFuzzyVariable().getLabel(nameLabel);
                ++n4;
            }
            Label resultat = this.aggregationULOWA(labels2agg, this.labels, this.weights.getWeightsValues());
            this.res.put(alter, resultat);
            ++n2;
        }
        return this.res;
    }

    public Label aggregationULOWA(Label[] labels2aggregate, Label[] labels, float[] w) {
        Label result = labels[0];
        if (labels2aggregate.length >= 2) {
            Arrays.sort(labels2aggregate);
            System.out.print("  Sorted labels: ");
            int i = 0;
            while (i < labels2aggregate.length) {
                System.out.print(String.valueOf(labels2aggregate[i].getId()) + " ");
                ++i;
            }
            System.out.println("");
            float[] w2 = ULOWA.calculateAuxWeigts(w);
            System.out.print("  Auxiliary weights: ");
            int i2 = 0;
            while (i2 < w2.length) {
                System.out.print(String.valueOf(w2[i2]) + " ");
                ++i2;
            }
            System.out.println("");
            int a_pos = labels2aggregate.length - 2;
            int b_pos = labels2aggregate.length - 1;
            Label a = null;
            Label b = labels2aggregate[b_pos];
            while (a_pos > -1) {
                System.out.println("Pos: " + a_pos);
                a = labels2aggregate[a_pos];
                System.out.println("AGGREGATE " + a.getId() + " " + b.getId() + " ");
                System.out.println("w2: " + w2[a_pos] + ", Labels lenght:" + labels.length);
                b = this.aggregateLabelsPairwiseULOWA(w2[a_pos], a, b, labels);
                System.out.println(" --> " + b.getId());
                --a_pos;
            }
            result = b;
        }
        return result;
    }

    public Label aggregateLabelsPairwiseULOWA(float weight, Label a, Label b, Label[] labels) {
        Label res = null;
        if (a.getIndex() < b.getIndex()) {
            Label temp = a;
            a = b;
            b = temp;
            weight = 1.0f - weight;
        }
        if (Math.abs(a.getIndex() - b.getIndex()) == 1) {
            if (b.getIndex() == 0) {
                System.out.println("RETURN " + a.getId());
                return a;
            }
            if (a.getIndex() == labels.length - 1) {
                System.out.println("RETURN " + b.getId());
                return b;
            }
        }
        float intermediate = this.calculateIntermediate(a, b, weight);
        System.out.println("Intermediate -- " + intermediate + ", Labels lenghts: " + labels.length);
        float max_sim = 0.0f;
        int c_pos = 0;
        c_pos = b.getIndex();
        while (c_pos <= a.getIndex()) {
            System.out.println("------------------");
            System.out.println("c_pos: " + c_pos);
            System.out.println("------------------");
            float sim = this.calculateSimilarity(labels[c_pos], intermediate);
            if (sim > max_sim) {
                max_sim = sim;
                res = labels[c_pos];
            }
            ++c_pos;
        }
        return res;
    }

    public static float[] calculateAuxWeigts(float[] w) {
        float[] aux = new float[w.length];
        aux[0] = w[0];
        float ant = 1.0f - w[0];
        int i = 1;
        while (i < aux.length) {
            if (ant == 0.0f) {
                aux[i] = 0.0f;
            } else {
                aux[i] = w[i] / ant;
                ant -= w[i];
            }
            ++i;
        }
        return aux;
    }

    private float calculateSimilarity(Label a, float intermediate) {
        System.out.println(String.valueOf(a.getId()) + " : {" + a.getPoints()[0] + "," + a.getPoints()[1] + "," + a.getPoints()[2] + "," + a.getPoints()[3] + "}");
        float prod = 1.0f;
        int i = 0;
        while (i < 4) {
            prod *= 2.0f - Math.abs(a.getPoints()[i] - intermediate);
            ++i;
        }
        System.out.println(prod);
        float sim = (float)(Math.pow(prod, 0.25) - 1.0);
        System.out.println("SIM of " + a.getId() + " with " + intermediate + " is " + sim);
        return sim;
    }

    private float calculateIntermediate(Label a, Label b, float weight) {
        float[] coga = a.getCoG();
        float[] cogb = b.getCoG();
        float x = coga[0] + (1.0f - weight) * (cogb[0] - coga[0]);
        System.out.println("Intermediate of " + coga[0] + " and " + cogb[0] + " with w=" + weight + " is " + x);
        return x;
    }
}

