/*
 * Decompiled with CFR 0.152.
 */
package main;

import componentes.Alternativa;
import componentes.Alternativas;
import componentes.Criterio;
import componentes.Criterios;
import componentes.FuzzyVariable;
import componentes.Label;
import componentes.Matrix;
import componentes.Par;
import componentes.Situation;
import componentes.Weight;
import componentes.Weights;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.decisionDeck.x2012.xmcda220.Alternative;
import org.decisionDeck.x2012.xmcda220.AlternativeOnCriteriaPerformances;
import org.decisionDeck.x2012.xmcda220.AlternativeValue;
import org.decisionDeck.x2012.xmcda220.Alternatives;
import org.decisionDeck.x2012.xmcda220.AlternativesValues;
import org.decisionDeck.x2012.xmcda220.CategoriesValues;
import org.decisionDeck.x2012.xmcda220.CategoryValue;
import org.decisionDeck.x2012.xmcda220.Criteria;
import org.decisionDeck.x2012.xmcda220.Criterion;
import org.decisionDeck.x2012.xmcda220.FuzzyNumber;
import org.decisionDeck.x2012.xmcda220.PerformanceTable;
import org.decisionDeck.x2012.xmcda220.Value;
import org.decisionDeck.x2012.xmcda220.Values;
import org.decisionDeck.x2012.xmcda220.XMCDADocument;

public class ReadXMCDA {
    public static FuzzyVariable readFuzzy(XMCDADocument.XMCDA xmcda) {
        CategoriesValues cats = xmcda.getCategoriesValuesArray(0);
        CategoryValue cat = cats.getCategoryValueArray(0);
        Values values = cat.getValuesArray(0);
        Value[] value = values.getValueArray();
        FuzzyVariable fuzzySet = new FuzzyVariable();
        int i = 0;
        while (i < value.length) {
            String id = value[i].getId();
            FuzzyNumber.Trapezoidal trapezoidal = value[i].getFuzzyNumber().getTrapezoidal();
            Value val = trapezoidal.getPoint1().getAbscissa();
            Float a = val.isSetInteger() ? Float.valueOf(val.getInteger()) : (val.isSetReal() ? Float.valueOf(val.getReal()) : Float.valueOf(0.0f));
            val = trapezoidal.getPoint2().getAbscissa();
            Float b = val.isSetInteger() ? Float.valueOf(val.getInteger()) : (val.isSetReal() ? Float.valueOf(val.getReal()) : Float.valueOf(0.0f));
            val = trapezoidal.getPoint3().getAbscissa();
            Float c = val.isSetInteger() ? Float.valueOf(val.getInteger()) : (val.isSetReal() ? Float.valueOf(val.getReal()) : Float.valueOf(0.0f));
            val = trapezoidal.getPoint4().getAbscissa();
            Float d = val.isSetInteger() ? Float.valueOf(val.getInteger()) : (val.isSetReal() ? Float.valueOf(val.getReal()) : Float.valueOf(0.0f));
            if (value[i].isSetName()) {
                String name = value[i].getName();
                fuzzySet.setLabel(new Label(id, name, a.floatValue(), b.floatValue(), c.floatValue(), d.floatValue(), i));
            } else {
                fuzzySet.setLabel(new Label(id, a.floatValue(), b.floatValue(), c.floatValue(), d.floatValue(), i));
            }
            ++i;
        }
        return fuzzySet;
    }

    public static Alternativas readAlternatives(XMCDADocument.XMCDA xmcda) {
        Alternatives alts = xmcda.getAlternativesArray(0);
        Alternative[] alt = alts.getAlternativeArray();
        Alternativas alters = new Alternativas();
        int i = 0;
        while (i < alt.length) {
            boolean[] active = alt[i].getActiveArray();
            Alternativa alter = active.length > 0 ? new Alternativa(alt[i].getId(), alt[i].getName(), active[0]) : new Alternativa(alt[i].getId(), alt[i].getName(), true);
            alters.addAlternative(alter);
            ++i;
        }
        return alters;
    }

    public static Criterios readCriteria(XMCDADocument.XMCDA xmcda) {
        Criteria crit = xmcda.getCriteriaArray(0);
        Criterion[] criterion = crit.getCriterionArray();
        Criterios Cri = new Criterios();
        int i = 0;
        while (i < criterion.length) {
            boolean[] active = criterion[i].getActiveArray();
            Criterio criton = active.length > 0 ? new Criterio(criterion[i].getId(), criterion[i].getName(), active[0]) : new Criterio(criterion[i].getId(), criterion[i].getName(), true);
            Cri.addCriterion(criton);
            ++i;
        }
        return Cri;
    }

    public static Weights readWeights(XMCDADocument.XMCDA xmcda) {
        AlternativesValues AltersValues = xmcda.getAlternativesValuesArray(0);
        AlternativeValue AlterValue = AltersValues.getAlternativeValueArray(0);
        Weights weights = new Weights();
        Values values = AlterValue.getValuesArray(0);
        Value[] value = values.getValueArray();
        int x = 0;
        while (x < value.length) {
            float a = 0.0f;
            a = value[x].isSetInteger() ? (float)value[x].getInteger() : (value[x].isSetReal() ? value[x].getReal() : 0.0f);
            Weight weight = new Weight(a);
            weights.addWeight(weight);
            ++x;
        }
        return weights;
    }

    public static Matrix<Par<Alternativa, Criterio>, String> readPreference(XMCDADocument.XMCDA xmcda) {
        PerformanceTable performanceTable = xmcda.getPerformanceTableArray(0);
        AlternativeOnCriteriaPerformances[] alternativePerformance = performanceTable.getAlternativePerformancesArray();
        Matrix<Par<Alternativa, Criterio>, String> matrix = new Matrix<Par<Alternativa, Criterio>, String>();
        int i = 0;
        while (i < alternativePerformance.length) {
            String Id = alternativePerformance[i].getAlternativeID();
            AlternativeOnCriteriaPerformances.Performance[] performance = alternativePerformance[i].getPerformanceArray();
            Alternativa alter = new Alternativa(Id, true);
            int x = 0;
            while (x < performance.length) {
                String Id2 = performance[x].getCriterionID();
                Criterio criton = new Criterio(Id2, true);
                Par<Alternativa, Criterio> pair = new Par<Alternativa, Criterio>(alter, criton);
                Value value = performance[x].getValue();
                if (value.isSetLabel() && value.getLabel() != "") {
                    matrix.setValue(pair, value.getLabel());
                } else {
                    matrix.setValue(pair, null);
                }
                ++x;
            }
            ++i;
        }
        return matrix;
    }

    public static boolean validateXml(XmlObject xml, ArrayList<XmlError> errorList) {
        XmlOptions validateOptions = new XmlOptions();
        validateOptions.setErrorListener(errorList);
        boolean isValid = xml.validate(validateOptions);
        return isValid;
    }

    public static Situation readData(File[] listFile, ArrayList<XmlError> errorList) throws XmlException, IOException {
        Situation situation = new Situation();
        int x = 0;
        while (x < listFile.length) {
            System.out.println(listFile[x].getName());
            File f = listFile[x];
            XMCDADocument xd = XMCDADocument.Factory.parse((File)f);
            if (ReadXMCDA.validateXml((XmlObject)xd, errorList)) {
                CategoriesValues[] xmlFuzzyList;
                AlternativesValues[] xmlCritsValsList;
                PerformanceTable[] xmlPerfTablesList;
                Criteria[] xmlCritsList;
                XMCDADocument.XMCDA xmcda = xd.getXMCDA();
                Alternatives[] xmlAltsList = xmcda.getAlternativesArray();
                if (xmlAltsList.length > 0) {
                    Alternativas alts = ReadXMCDA.readAlternatives(xmcda);
                    situation.setAlternatives(alts);
                }
                if ((xmlCritsList = xmcda.getCriteriaArray()).length > 0) {
                    Criterios crits = ReadXMCDA.readCriteria(xmcda);
                    situation.setCriteria(crits);
                }
                if ((xmlPerfTablesList = xmcda.getPerformanceTableArray()).length > 0) {
                    Matrix<Par<Alternativa, Criterio>, String> matrix = ReadXMCDA.readPreference(xmcda);
                    situation.setEvaluationMatrix(matrix);
                }
                if ((xmlCritsValsList = xmcda.getAlternativesValuesArray()).length > 0) {
                    Weights pesos = ReadXMCDA.readWeights(xmcda);
                    situation.setWeights(pesos);
                }
                if ((xmlFuzzyList = xmcda.getCategoriesValuesArray()).length > 0) {
                    situation.setFuzzyVariable(ReadXMCDA.readFuzzy(xmcda));
                }
            } else {
                System.out.println("Error file " + listFile[x].getName());
                break;
            }
            ++x;
        }
        return situation;
    }
}

