/*
 * Decompiled with CFR 0.152.
 */
package main;

import componentes.FuzzyVariable;
import componentes.Label;
import componentes.Situation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.decisionDeck.x2012.xmcda220.AlternativesValues;
import org.decisionDeck.x2012.xmcda220.CategoriesValues;
import org.decisionDeck.x2012.xmcda220.CategoryValue;
import org.decisionDeck.x2012.xmcda220.FuzzyNumber;
import org.decisionDeck.x2012.xmcda220.Value;
import org.decisionDeck.x2012.xmcda220.Values;
import org.decisionDeck.x2012.xmcda220.XMCDADocument;

public class ReadXMCDA {
    public static FuzzyVariable readFuzzy(XMCDADocument.XMCDA xmcda) {
        CategoriesValues cats = xmcda.getCategoriesValuesArray(0);
        CategoryValue cat = cats.getCategoryValueArray(0);
        Values values = cat.getValuesArray(0);
        Value[] value = values.getValueArray();
        FuzzyVariable fuzzySet = new FuzzyVariable();
        int i = 0;
        while (i < value.length) {
            String id = value[i].getId();
            FuzzyNumber.Trapezoidal trapezoidal = value[i].getFuzzyNumber().getTrapezoidal();
            Value val = trapezoidal.getPoint1().getAbscissa();
            Float a = val.isSetInteger() ? Float.valueOf(val.getInteger()) : (val.isSetReal() ? Float.valueOf(val.getReal()) : Float.valueOf(0.0f));
            val = trapezoidal.getPoint2().getAbscissa();
            Float b = val.isSetInteger() ? Float.valueOf(val.getInteger()) : (val.isSetReal() ? Float.valueOf(val.getReal()) : Float.valueOf(0.0f));
            val = trapezoidal.getPoint3().getAbscissa();
            Float c = val.isSetInteger() ? Float.valueOf(val.getInteger()) : (val.isSetReal() ? Float.valueOf(val.getReal()) : Float.valueOf(0.0f));
            val = trapezoidal.getPoint4().getAbscissa();
            Float d = val.isSetInteger() ? Float.valueOf(val.getInteger()) : (val.isSetReal() ? Float.valueOf(val.getReal()) : Float.valueOf(0.0f));
            if (value[i].isSetName()) {
                String name = value[i].getName();
                fuzzySet.setLabel(new Label(id, name, a.floatValue(), b.floatValue(), c.floatValue(), d.floatValue(), i));
            }
            ++i;
        }
        return fuzzySet;
    }

    public static AlternativesValues readAlternativesValues(XMCDADocument.XMCDA xmcda) {
        return xmcda.getAlternativesValuesArray(0);
    }

    public static boolean validateXml(XmlObject xml, ArrayList<XmlError> errorList) {
        XmlOptions validateOptions = new XmlOptions();
        validateOptions.setErrorListener(errorList);
        boolean isValid = xml.validate(validateOptions);
        return isValid;
    }

    public static Situation readData(File[] listFile, ArrayList<XmlError> errorList) throws XmlException, IOException {
        Situation situation = new Situation();
        int x = 0;
        while (x < listFile.length) {
            File f = listFile[x];
            XMCDADocument xd = XMCDADocument.Factory.parse((File)f);
            if (ReadXMCDA.validateXml((XmlObject)xd, errorList)) {
                CategoriesValues[] xmlFuzzyList;
                XMCDADocument.XMCDA xmcda = xd.getXMCDA();
                AlternativesValues[] xmlAlternativesValsList = xmcda.getAlternativesValuesArray();
                if (xmlAlternativesValsList.length > 0) {
                    situation.setFuzzyValues(ReadXMCDA.readAlternativesValues(xmcda));
                }
                if ((xmlFuzzyList = xmcda.getCategoriesValuesArray()).length > 0) {
                    situation.setFuzzyVariable(ReadXMCDA.readFuzzy(xmcda));
                }
            } else {
                System.out.println("Error file " + listFile[x].getName());
                break;
            }
            ++x;
        }
        return situation;
    }
}

